/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing;

import com.paterva.maltego.typing.editing.controls.AttachPanelController;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.progress.ProgressController;
import com.paterva.maltego.util.ui.progress.ProgressDescriptor;
import com.paterva.maltego.util.ui.progress.ProgressDialogFactory;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;

public abstract class AbstractAddAttachmentsAction {
    public abstract void attachFile(Object var1, File var2, FastURL var3) throws IOException;

    public abstract void attachFile(List var1, File var2, FastURL var3) throws IOException;

    public abstract void done();

    public void perform(List objs) {
        AttachPanelController editor = new AttachPanelController();
        EditDialogDescriptor dd = new EditDialogDescriptor("Attach File(s)/URL(s)", (WizardDescriptor.Panel)editor);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == EditDialogDescriptor.OK_OPTION) {
            Object source = dd.getProperty("attachSource");
            if (AttachPanelController.SOURCE_FILES.equals(source)) {
                List files = (List)dd.getProperty("sourceFiles");
                this.attachFiles(objs, files);
            } else if (AttachPanelController.SOURCE_URLS.equals(source)) {
                List urls = (List)dd.getProperty("sourceURLs");
                this.attachURLs(objs, urls);
            }
        }
    }

    public void attachFiles(final List objs, final List<File> files) {
        ProgressDescriptor progress = ProgressDialogFactory.createProgressDialog((String)"Attaching File(s)", (boolean)true);
        final ProgressController controller = progress.getController();
        Component component = progress.getGUIComponent();
        Thread process = new Thread(new Runnable(){

            @Override
            public void run() {
                controller.start(objs.size() * files.size());
                int progress = 0;
                for (File file : files) {
                    if (controller.isCanceled()) break;
                    String msg = String.format("(%d/%d) Attaching %s", progress + 1, files.size(), file.getName());
                    controller.progress(msg, progress);
                    ++progress;
                    try {
                        AbstractAddAttachmentsAction.this.attachFile(objs, file, new FastURL(file.toURI().toURL().toString()));
                    }
                    catch (IOException ex) {
                        AbstractAddAttachmentsAction.this.showError("Unable to attach " + file.getName());
                    }
                }
                controller.finish();
                AbstractAddAttachmentsAction.this.onDone();
            }
        }, "Many-to-many File Attacher");
        process.start();
        component.setVisible(true);
    }

    public void attachFiles(final Map<Object, File> files) {
        ProgressDescriptor progress = ProgressDialogFactory.createProgressDialog((String)"Attaching File(s)", (boolean)true);
        final ProgressController controller = progress.getController();
        Component component = progress.getGUIComponent();
        Thread process = new Thread(new Runnable(){

            @Override
            public void run() {
                controller.start(files.size());
                int progress = 0;
                for (Map.Entry entry : files.entrySet()) {
                    Object obj = entry.getKey();
                    File file = (File)entry.getValue();
                    if (controller.isCanceled()) break;
                    String msg = String.format("(%d/%d) Attaching %s", progress + 1, files.size(), file.getName());
                    controller.progress(msg, progress);
                    ++progress;
                    try {
                        AbstractAddAttachmentsAction.this.attachFile(obj, file, new FastURL(file.toURI().toURL().toString()));
                    }
                    catch (IOException ex) {
                        AbstractAddAttachmentsAction.this.showError("Unable to attach " + file.getName());
                    }
                }
                controller.finish();
                AbstractAddAttachmentsAction.this.onDone();
            }
        }, "One-to-one File Attacher");
        process.start();
        component.setVisible(true);
    }

    protected void attachURLs(final List objs, final List<FastURL> urls) {
        ProgressDescriptor progress = ProgressDialogFactory.createProgressDialog((String)"Attaching URL(s)", (boolean)true);
        final ProgressController controller = progress.getController();
        Component component = progress.getGUIComponent();
        Thread process = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    controller.start(urls.size() * 100);
                    int progress = 0;
                    File dir = FileUtilities.createTempDir((String)"FromURL");
                    for (FastURL fastURL : urls) {
                        if (controller.isCanceled()) {
                            break;
                        }
                        String message = String.format("(%d/%d) Downloading %s", progress + 1, urls.size(), fastURL.toString());
                        controller.progress(message, progress * 100);
                        FileUtilities.deleteContents((File)dir);
                        InputStream is = null;
                        try {
                            URL url = fastURL.getURL();
                            int contentLength = url.openConnection().getContentLength();
                            is = url.openStream();
                            String urlFilename = FileUtilities.replaceIllegalCharsKeepDots((String)url.getPath());
                            String filename = new File(urlFilename).getName();
                            File file = new File(dir, filename);
                            this.write(file, is, contentLength, progress);
                            if (controller.isCanceled()) break;
                            if (!filename.contains(".")) {
                                try {
                                    String format = ImageUtils.getImageFormatName((Object)file);
                                    File renamedFile = new File(file.getAbsolutePath() + "." + format.toLowerCase());
                                    if (file.renameTo(renamedFile)) {
                                        file = renamedFile;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            message = String.format("(%d/%d) Attaching %s", progress + 1, urls.size(), file.getName());
                            controller.progress(message);
                            AbstractAddAttachmentsAction.this.attachFile(objs, file, fastURL);
                        }
                        catch (Exception ex) {
                            this.handleError(fastURL);
                        }
                        finally {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        ++progress;
                    }
                }
                catch (Exception ex) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
                finally {
                    controller.finish();
                    AbstractAddAttachmentsAction.this.onDone();
                }
            }

            private void handleError(final FastURL fastURL) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            String errorMsg = "Unable to attach " + fastURL + "\nPlease check that the URL points to a file and that it is accessible.";
                            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)errorMsg, 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void write(File file, InputStream is, int contentLength, int progress1) throws IOException {
                try (FileOutputStream os = null;){
                    byte[] buffer = new byte[1024];
                    os = new FileOutputStream(file);
                    int read = is.read(buffer, 0, buffer.length);
                    int totalRead = 0;
                    while (read > 0) {
                        totalRead += read;
                        if (contentLength > 0) {
                            int prog = progress1 * 100 + totalRead * 100 / contentLength;
                            controller.progress(prog);
                        }
                        if (controller.isCanceled()) {
                            break;
                        }
                        os.write(buffer, 0, read);
                        read = is.read(buffer, 0, buffer.length);
                    }
                }
            }
        }, "URL Attacher");
        process.start();
        component.setVisible(true);
    }

    private void onDone() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AbstractAddAttachmentsAction.this.done();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private void showError(final String error) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)error, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

