/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.PropertyToColumnMap;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.ui.serializer.MappingSerializer;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.util.FileUtilities;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class DefaultMappingRegistry
extends MappingRegistry {
    private Map<TabularGraph, String> mappings;

    public DefaultMappingRegistry() {
    }

    public DefaultMappingRegistry(FileObject configRoot) {
        super(configRoot);
    }

    public TabularGraph get(String mappingName) {
        TabularGraph foundMapping = null;
        for (Map.Entry<TabularGraph, String> entry : this.getMappings().entrySet()) {
            TabularGraph mapping = entry.getKey();
            if (!mappingName.equals(mapping.getName())) continue;
            foundMapping = mapping;
            break;
        }
        return foundMapping;
    }

    public synchronized Set<TabularGraph> getAll() {
        return Collections.unmodifiableSet(this.getMappings().keySet());
    }

    private synchronized Map<TabularGraph, String> getMappings() {
        if (this.mappings == null) {
            this.mappings = this.load();
        }
        return this.mappings;
    }

    public void put(TabularGraph mapping) {
        try {
            Map<TabularGraph, String> graphMappings = this.getMappings();
            TabularGraph existingMapping = this.get(mapping.getName());
            if (existingMapping != null) {
                String filename = graphMappings.get(existingMapping);
                graphMappings.remove(existingMapping);
                graphMappings.put(mapping, filename);
                this.update(mapping, filename);
                this.fireMappingUpdated();
            } else {
                String filename = this.save(mapping);
                graphMappings.put(mapping, filename);
                this.fireMappingAdded();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void remove(String mappingName) {
        Map<TabularGraph, String> graphMappings = this.getMappings();
        TabularGraph existingMapping = this.get(mappingName);
        if (existingMapping != null) {
            String filename = graphMappings.get(existingMapping);
            graphMappings.remove(existingMapping);
            this.delete(filename);
            this.fireMappingRemoved();
        }
    }

    public boolean contains(String mappingName) {
        return this.get(mappingName) != null;
    }

    public void refreshProperties() {
        HashSet<TabularGraph> graphMappings = new HashSet<TabularGraph>(this.getAll());
        for (TabularGraph tabularGraph : graphMappings) {
            for (TabularGraphEntity tabularEntity : tabularGraph.getEntities()) {
                String specName = tabularEntity.getEntitySpecName();
                EntityRegistry registry = EntityRegistry.getDefault();
                TypeSpec spec = registry.get(specName);
                this.refreshProperties((SpecRegistry)registry, spec, (PropertyToColumnMap)tabularEntity);
            }
            for (TabularGraphLink tabularLink : tabularGraph.getLinks()) {
                LinkRegistry registry = LinkRegistry.getDefault();
                MaltegoLinkSpec spec = MaltegoLinkSpec.getManualSpec();
                this.refreshProperties((SpecRegistry)registry, (TypeSpec)spec, (PropertyToColumnMap)tabularLink);
            }
        }
        this.saveAll(graphMappings);
    }

    private void saveAll(Set<TabularGraph> mappings) {
        for (TabularGraph mapping : mappings) {
            this.put(mapping);
        }
    }

    private <T extends TypeSpec> void refreshProperties(SpecRegistry<T> registry, TypeSpec spec, PropertyToColumnMap map) {
        if (spec != null) {
            DisplayDescriptorCollection specProps = InheritanceHelper.getAggregatedProperties(registry, (String)spec.getTypeName());
            for (int column : map.getColumns()) {
                PropertyDescriptor pd = map.getProperty(column);
                DisplayDescriptor specProp = specProps.get(pd.getName());
                if (specProp == null) continue;
                map.put(column, (PropertyDescriptor)new DisplayDescriptor(specProp));
            }
        }
    }

    private Map<TabularGraph, String> load() {
        Map<TabularGraph, String> childMappings = new HashMap<TabularGraph, String>();
        try {
            FileObject folder = this.getFolder();
            if (folder != null) {
                childMappings = this.loadFromFolder(folder);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return childMappings;
    }

    private Map<TabularGraph, String> loadFromFolder(FileObject folder) throws IOException {
        HashMap<TabularGraph, String> childMappings = new HashMap<TabularGraph, String>();
        for (FileObject fileObject : folder.getChildren()) {
            TabularGraph mapping;
            if (fileObject.isFolder() || !"tmapping".equals(fileObject.getExt()) || (mapping = this.load(fileObject)) == null) continue;
            childMappings.put(mapping, fileObject.getName());
        }
        return childMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TabularGraph load(FileObject fileObject) throws IOException {
        TabularGraph mapping = null;
        try (InputStream inputStream = null;){
            inputStream = fileObject.getInputStream();
            mapping = MappingSerializer.getDefault().read(inputStream);
        }
        return mapping;
    }

    private String save(TabularGraph mapping) throws IOException {
        String name = mapping.getName();
        FileObject file = FileUtilities.createUniqueFile((FileObject)this.getFolder(), (String)DefaultMappingRegistry.getFileNameNoExt(name), (String)"tmapping");
        this.save(mapping, file);
        return file.getName();
    }

    private void update(TabularGraph mapping, String filename) throws IOException {
        FileObject file = this.getFolder().getFileObject(filename + "." + "tmapping");
        this.save(mapping, file);
    }

    private void save(TabularGraph mapping, FileObject file) throws IOException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(file.getOutputStream());){
            MappingSerializer.getDefault().write(mapping, outputStream);
        }
    }

    private void delete(String filename) {
        try {
            FileObject file = this.getFolder().getFileObject(filename + "." + "tmapping");
            if (file != null) {
                file.delete();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private FileObject getFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this._configRoot, (String)"Maltego/TabularMappings/");
    }

    private static String getFileNameNoExt(String name) {
        return FileUtilities.replaceIllegalChars((String)name.toLowerCase());
    }
}

