/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.EntityDetector;
import com.paterva.maltego.graph.table.io.impl.TabularGraphUtils;
import com.paterva.maltego.graph.table.ui.wizard.EntityPropertyTableModel;
import com.paterva.maltego.graph.table.ui.wizard.EntitySampleTableModel;
import com.paterva.maltego.graph.table.ui.wizard.MappingPanel;
import com.paterva.maltego.typing.descriptor.TypeSpecDisplayNameComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openide.util.Exceptions;

public class EntityMappingPanel
extends MappingPanel {
    private static final String HINT_STEP1 = "Select multiple \"Unmapped\" columns that should be mapped to an entity.";
    private static final String HINT_STEP2 = "<HTML>Select the type of the entity from the \"Map to\" list.<br> Tip: to add or remove a column from the selected entity hold down &lt;Ctrl&gt; and click on the column.</HTML>";
    private static final String HINT_STEP3 = "To change the property mapping change the appropriate value in the \"Property\" column.";

    public EntityMappingPanel() {
        super(new EntitySampleTableModel(), new EntityPropertyTableModel());
    }

    public void attemptToPreMapEntities() {
        try {
            EntityDetector.getInstance().detectEntities(this.getTabularGraph(), this.getFile());
            this.updateHtoComboBox();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    protected List getMappableItems() {
        ArrayList entitySpecs = new ArrayList(EntityRegistry.getDefault().getAllVisible());
        Collections.sort(entitySpecs, new TypeSpecDisplayNameComparator());
        return entitySpecs;
    }

    @Override
    protected Object getItem(int column) {
        return TabularGraphUtils.getEntity((TabularGraph)this.getTabularGraph(), (int)column);
    }

    @Override
    protected List getItems(int[] columns) {
        List entities = TabularGraphUtils.getEntities((TabularGraph)this.getTabularGraph(), (int[])columns);
        return entities;
    }

    @Override
    protected Object getMappedItem(Object columnItem) {
        return TabularGraphUtils.getSpec((TabularGraphEntity)((TabularGraphEntity)columnItem));
    }

    @Override
    protected void onComboChanged(Object comboItem) {
        int[] selectedColumns = this.getSelectedColumns();
        this.getTabularGraph().putEntity(((MaltegoEntitySpec)comboItem).getTypeName(), selectedColumns);
    }

    @Override
    protected void removeMapping(int[] columns) {
        this.getTabularGraph().removeColumnsFromEntities(columns);
    }

    @Override
    protected String getTooltip(int state) {
        switch (state) {
            case 0: {
                return HINT_STEP1;
            }
            case 1: {
                return HINT_STEP2;
            }
            case 2: {
                return HINT_STEP3;
            }
        }
        return "";
    }
}

