/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.external.text;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.external.api.GraphXDescriptor;
import com.paterva.maltego.graph.external.api.GraphXEntryPoint;
import com.paterva.maltego.graph.external.api.GraphXException;
import com.paterva.maltego.graph.external.api.GraphXNewGraphResult;
import com.paterva.maltego.graph.external.api.GraphXRegistry;
import com.paterva.maltego.graph.external.api.GraphXUpdateResult;
import com.paterva.maltego.graph.external.text.TextGraphXTranslator;
import com.paterva.maltego.graph.external.text.json.JsonGraphXSerializer;
import com.paterva.maltego.graph.external.text.stubs.RequestGraphStub;
import com.paterva.maltego.graph.external.text.stubs.RequestGraphsStub;
import com.paterva.maltego.graph.external.text.stubs.RequestNewGraphStub;
import com.paterva.maltego.graph.external.text.stubs.RequestRemoveStub;
import com.paterva.maltego.graph.external.text.stubs.RequestStub;
import com.paterva.maltego.graph.external.text.stubs.RequestUpdateStub;
import com.paterva.maltego.graph.external.text.stubs.ResponseGraphStub;
import com.paterva.maltego.graph.external.text.stubs.ResponseGraphsStub;
import com.paterva.maltego.graph.external.text.stubs.ResponseNewGraphStub;
import com.paterva.maltego.graph.external.text.stubs.ResponseRemoveStub;
import com.paterva.maltego.graph.external.text.stubs.ResponseStub;
import com.paterva.maltego.graph.external.text.stubs.ResponseUpdateStub;
import com.paterva.maltego.graph.external.text.xml.XmlGraphXSerializer;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.matching.StatelessMatchingRuleDescriptor;
import com.paterva.maltego.matching.api.GraphMatchStrategy;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.serializers.compact.DeserializedGraph;
import com.paterva.maltego.serializers.compact.stubs.EntityStub;
import com.paterva.maltego.serializers.compact.stubs.ErrorStub;
import com.paterva.maltego.serializers.compact.stubs.LinkStub;
import com.paterva.maltego.serializers.compact.stubs.OrderedStub;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openide.util.Exceptions;

class TextGraphXExecutor {
    private final Integer _graphId;
    private final TextGraphXTranslator _translator = new TextGraphXTranslator();

    public TextGraphXExecutor() {
        this(null);
    }

    public TextGraphXExecutor(Integer graphId) {
        this._graphId = graphId;
    }

    public String execute(String text) {
        String response = "";
        String string = text = text != null ? text.trim() : null;
        if (StringUtilities.isNullOrEmpty((String)text)) {
            return "";
        }
        boolean isXml = this.isXML(text);
        try {
            response = isXml ? this.executeXml(text) : this.executeJson(text);
        }
        catch (Exception ex) {
            try {
                NormalException.logStackTrace((Throwable)ex);
                ResponseStub stub = new ResponseStub();
                stub.setError(ErrorStub.create((Exception)ex));
                response = isXml ? new XmlGraphXSerializer().toXml(stub) : new JsonGraphXSerializer().toJson(stub);
            }
            catch (Exception ex1) {
                Exceptions.printStackTrace((Throwable)ex1);
            }
        }
        return response;
    }

    private boolean isXML(String text) {
        return text.startsWith("<");
    }

    private String executeXml(String text) throws IOException, GraphXException {
        XmlGraphXSerializer serializer = new XmlGraphXSerializer();
        RequestStub request = serializer.fromXml(text);
        ResponseStub response = this.execute(request);
        JsonGraphXSerializer s = new JsonGraphXSerializer();
        String resp = "JSON request:\n" + s.toJson(request) + "\nXML response:\n" + serializer.toXml(response) + "\nJSON response:\n" + s.toJson(response);
        return resp;
    }

    private String executeJson(String text) throws IOException, GraphXException {
        JsonGraphXSerializer serializer = new JsonGraphXSerializer();
        RequestStub request = serializer.fromJson(text);
        ResponseStub response = this.execute(request);
        return serializer.toJson(response);
    }

    private ResponseStub execute(RequestStub request) throws GraphXException {
        List<OrderedStub> requests = this._translator.translateRequest(request);
        List<OrderedStub> results = this.execute(requests);
        return this._translator.translateResponse(results);
    }

    private List<OrderedStub> execute(List<OrderedStub> requests) throws GraphXException {
        ArrayList<OrderedStub> responses = new ArrayList<OrderedStub>();
        for (OrderedStub request : requests) {
            Object response = null;
            if (request instanceof RequestGraphsStub) {
                response = this.execute((RequestGraphsStub)request);
            } else if (request instanceof RequestGraphStub) {
                response = this.execute((RequestGraphStub)request);
            } else if (request instanceof RequestUpdateStub) {
                response = this.execute((RequestUpdateStub)request);
            } else if (request instanceof RequestRemoveStub) {
                response = this.execute((RequestRemoveStub)request);
            } else if (request instanceof RequestNewGraphStub) {
                response = this.execute((RequestNewGraphStub)request);
            } else {
                throw new GraphXException("Unknown request: " + request.getClass().getSimpleName());
            }
            if (response == null) {
                throw new GraphXException("No response from " + request.getClass().getSimpleName());
            }
            response.setNum(request.getNum());
            responses.add((OrderedStub)response);
        }
        return responses;
    }

    private ResponseGraphsStub execute(RequestGraphsStub request) {
        ResponseGraphsStub stub = new ResponseGraphsStub();
        try {
            List graphs = GraphXEntryPoint.getDefault().getGraphs();
            stub = this._translator.translateGraphs(graphs);
        }
        catch (Exception ex) {
            this.handleError(stub, ex);
        }
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseGraphStub execute(RequestGraphStub request) {
        ResponseGraphStub stub = new ResponseGraphStub();
        Integer gid = this._graphId != null ? this._graphId : request.getGid();
        try {
            this.checkGraphId(gid);
            GraphID graphID = GraphXEntryPoint.getDefault().getGraphID(gid.intValue(), false);
            stub = this._translator.translateGraphResponse(request, graphID);
            GraphXDescriptor descriptor = GraphXRegistry.getDefault().getGraphXDescriptor(gid.intValue());
            stub.setName(descriptor.getName());
        }
        catch (Exception ex) {
            this.handleError((OrderedStub)stub, ex);
        }
        finally {
            stub.setGid(request.getGid());
        }
        return stub;
    }

    private ResponseNewGraphStub execute(RequestNewGraphStub request) {
        ResponseNewGraphStub stub = new ResponseNewGraphStub();
        try {
            GraphXNewGraphResult result = GraphXEntryPoint.getDefault().newGraph(request.getName());
            stub.setGid(result.getGid());
            stub.setName(result.getName());
        }
        catch (Exception ex) {
            this.handleError(stub, ex);
        }
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseUpdateStub execute(RequestUpdateStub request) {
        ResponseUpdateStub stub = new ResponseUpdateStub();
        Integer gid = this._graphId != null ? this._graphId : request.getGid();
        try {
            this.checkGraphId(gid);
            this.checkTypes(request);
            String ems = request.getEntityMergeStrategy();
            String lms = request.getLinkMergeStrategy();
            MatchingRuleDescriptor entityMatchRule = StatelessMatchingRuleDescriptor.Default;
            MatchingRuleDescriptor linkMatchRule = StatelessMatchingRuleDescriptor.Default;
            if ("keep both".equals(ems)) {
                entityMatchRule = null;
                ems = null;
                for (EntityStub entityStub : request.getEntities()) {
                    entityStub.setID(null);
                }
            }
            if ("keep both".equals(lms)) {
                linkMatchRule = null;
                lms = null;
                for (LinkStub linkStub : request.getLinks()) {
                    linkStub.setID(null);
                }
            }
            GraphMatchStrategy matchStrat = new GraphMatchStrategy(entityMatchRule, linkMatchRule);
            GraphMergeStrategy mergeStrat = this._translator.translateMergeStrategies(ems, lms);
            GraphID graphID = GraphXRegistry.getDefault().getGraphID(gid.intValue());
            DeserializedGraph graph = this._translator.translateUpdateGraph(request, graphID);
            GraphXUpdateResult result = GraphXEntryPoint.getDefault().update(gid.intValue(), graph.getGraphSnippet(), matchStrat, mergeStrat);
            stub = this._translator.translateUpdateResult(graph, result);
        }
        catch (Exception ex) {
            this.handleError((OrderedStub)stub, ex);
        }
        finally {
            stub.setGid(request.getGid());
        }
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseRemoveStub execute(RequestRemoveStub request) {
        ResponseRemoveStub stub = new ResponseRemoveStub();
        Integer gid = this._graphId != null ? this._graphId : request.getGid();
        try {
            this.checkGraphId(gid);
            GraphID graphID = GraphXRegistry.getDefault().getGraphID(gid.intValue());
            ArrayList<EntityStub> entitiesToRemove = new ArrayList<EntityStub>();
            for (Object entityStub : request.getEntities()) {
                String entityId = entityStub.getID();
                if (entityId != null && this.exists(graphID, EntityID.parse((String)entityId))) continue;
                entitiesToRemove.add((EntityStub)entityStub);
            }
            request.removeEntities(entitiesToRemove);
            ArrayList<LinkStub> linksToRemove = new ArrayList<LinkStub>();
            for (LinkStub linkStub : request.getLinks()) {
                String linkId = linkStub.getID();
                if (linkId != null && this.exists(graphID, LinkID.parse((String)linkId))) continue;
                linksToRemove.add(linkStub);
            }
            request.removeLinks(linksToRemove);
            List entityStubs = request.getEntities();
            List linkStubs = request.getLinks();
            if (!entityStubs.isEmpty() || !linkStubs.isEmpty()) {
                EntityStub resultStub;
                DeserializedGraph graph = this._translator.translateUpdateGraph(request, graphID);
                Set entityIDs = GraphStoreHelper.getIds((Collection)graph.getEntities());
                Set linkIDs = GraphStoreHelper.getIds((Collection)graph.getLinks());
                String descriptionStr = "%s" + (entityIDs.size() + linkIDs.size()) + " items";
                SimilarStrings description = new SimilarStrings(descriptionStr, "Delete", "Add");
                GraphTransactionHelper.doDeleteEntitiesAndLinks((SimilarStrings)description, (GraphID)graphID, (Set)entityIDs, (Set)linkIDs);
                for (EntityStub entityStub : entityStubs) {
                    resultStub = new EntityStub();
                    resultStub.setID(entityStub.getID());
                    resultStub.setNum(entityStub.getNum());
                    stub.add(resultStub);
                }
                for (LinkStub linkStub : linkStubs) {
                    resultStub = new LinkStub();
                    resultStub.setID(linkStub.getID());
                    resultStub.setNum(linkStub.getNum());
                    stub.add((LinkStub)resultStub);
                }
            }
        }
        catch (Exception ex) {
            this.handleError((OrderedStub)stub, ex);
        }
        finally {
            stub.setGid(request.getGid());
        }
        return stub;
    }

    private void checkGraphId(Integer gid) throws GraphXException {
        if (gid == null) {
            throw new GraphXException("Graph id attribute required");
        }
    }

    private void handleError(OrderedStub stub, Exception ex) {
        NormalException.logStackTrace((Throwable)ex);
        stub.setError(ErrorStub.create((Exception)ex));
    }

    private void checkTypes(RequestUpdateStub request) throws GraphXException {
        String ems = request.getEntityMergeStrategy();
        if ("keep both".equals(ems) || "keep new".equals(ems)) {
            for (EntityStub entityStub : request.getEntities()) {
                if (entityStub.getType() != null) continue;
                throw new GraphXException("Entity type must be provided for new entities");
            }
        }
    }

    private boolean exists(GraphID graphID, EntityID entityID) {
        boolean exists = false;
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            exists = structureReader.exists(entityID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return exists;
    }

    private boolean exists(GraphID graphID, LinkID linkID) {
        boolean exists = false;
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            exists = structureReader.exists(linkID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return exists;
    }
}

