/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform.classpath;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;

public class PlatformClassPathProvider
implements ClassPathProvider {
    private static final SpecificationVersion JAVA_9 = new SpecificationVersion("9");
    private static final Set<? extends String> SUPPORTED_CLASS_PATH_TYPES = new HashSet<String>(Arrays.asList("classpath/source", "classpath/boot", "classpath/compile", "modules/boot"));
    private FileObject lastUsedRoot;
    private JavaPlatform lastUsedPlatform;
    private ClassPath emptyCp;

    public ClassPath findClassPath(FileObject fo, String type) {
        JavaPlatform[] platforms;
        if (!SUPPORTED_CLASS_PATH_TYPES.contains(type)) {
            return null;
        }
        if (fo == null || type == null) {
            throw new IllegalArgumentException();
        }
        JavaPlatform lp = this.getLastUsedPlatform(fo);
        if (lp != null) {
            platforms = new JavaPlatform[]{lp};
        } else {
            JavaPlatformManager manager = JavaPlatformManager.getDefault();
            platforms = manager.getInstalledPlatforms();
        }
        for (JavaPlatform jp : platforms) {
            ClassPath bootClassPath = jp.getBootstrapLibraries();
            ClassPath libraryPath = jp.getStandardLibraries();
            ClassPath sourcePath = jp.getSourceFolders();
            FileObject root = null;
            if ("classpath/source".equals(type) && sourcePath != null && (root = sourcePath.findOwnerRoot(fo)) != null) {
                this.setLastUsedPlatform(root, jp);
                return sourcePath;
            }
            if ("classpath/boot".equals(type) && (root = PlatformClassPathProvider.getArtefactOwner(fo, bootClassPath, libraryPath, sourcePath)) != null) {
                this.setLastUsedPlatform(root, jp);
                return bootClassPath;
            }
            if ("classpath/compile".equals(type)) {
                if (libraryPath != null && (root = libraryPath.findOwnerRoot(fo)) != null) {
                    this.setLastUsedPlatform(root, jp);
                    return libraryPath;
                }
                if ((bootClassPath == null || (root = bootClassPath.findOwnerRoot(fo)) == null) && (sourcePath == null || (root = sourcePath.findOwnerRoot(fo)) == null)) continue;
                return this.getEmptyClassPath();
            }
            if (!"modules/boot".equals(type) || JAVA_9.compareTo((Object)jp.getSpecification().getVersion()) > 0 || (root = PlatformClassPathProvider.getArtefactOwner(fo, bootClassPath, libraryPath, sourcePath)) == null) continue;
            this.setLastUsedPlatform(root, jp);
            return bootClassPath;
        }
        return null;
    }

    private synchronized ClassPath getEmptyClassPath() {
        if (this.emptyCp == null) {
            this.emptyCp = ClassPathSupport.createClassPath(Collections.emptyList());
        }
        return this.emptyCp;
    }

    private synchronized void setLastUsedPlatform(FileObject root, JavaPlatform platform) {
        this.lastUsedRoot = root;
        this.lastUsedPlatform = platform;
    }

    private synchronized JavaPlatform getLastUsedPlatform(FileObject file) {
        if (this.lastUsedRoot != null && FileUtil.isParentOf((FileObject)this.lastUsedRoot, (FileObject)file)) {
            return this.lastUsedPlatform;
        }
        return null;
    }

    @CheckForNull
    private static FileObject getArtefactOwner(@NonNull FileObject file, ClassPath ... cps) {
        for (ClassPath cp : cps) {
            FileObject root;
            if (cp == null || (root = cp.findOwnerRoot(file)) == null) continue;
            return root;
        }
        return null;
    }
}

