/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.data;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.transforms.tabular.TabularTransformNames;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TabularTransform {
    private final List<Integer> linkIndexes;
    private final boolean reverse;
    private final boolean favorite;

    public TabularTransform(List<Integer> linkIndexes, boolean reverse, boolean favorite) {
        Args.notNull(linkIndexes, (String)"linkIndexes");
        if (linkIndexes.isEmpty()) {
            throw new IllegalArgumentException("Link indexes may not be empty");
        }
        this.linkIndexes = Collections.unmodifiableList(new ArrayList<Integer>(linkIndexes));
        this.reverse = reverse;
        this.favorite = favorite;
    }

    public List<Integer> getLinkIndexes() {
        return this.linkIndexes;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public String getTransformName(TabularTransformSource source) {
        return TabularTransformNames.getTransformName(source, this);
    }

    public String getTransformDisplayName(TabularTransformSource source) {
        return TabularTransformNames.getTransformDisplayName(source, this);
    }

    public List<TabularGraphLink> getLinks(TabularGraph tabularGraph) {
        return tabularGraph.getLinks().stream().filter(l -> this.getLinkIndexes().contains(l.getIndex())).collect(Collectors.toList());
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + Objects.hashCode(this.linkIndexes);
        hash = 23 * hash + (this.reverse ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TabularTransform other = (TabularTransform)obj;
        if (this.reverse != other.reverse) {
            return false;
        }
        return Objects.equals(this.linkIndexes, other.linkIndexes);
    }
}

