/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TabularGraphUtils {
    TabularGraphUtils() {
    }

    public static boolean isEqual(TabularGraph graphA, TabularGraph graphB) {
        if (graphA == graphB) {
            return true;
        }
        if (graphA == null || graphB == null) {
            return false;
        }
        if (graphA.hasHeaderRow() != graphB.hasHeaderRow()) {
            return false;
        }
        if (!graphA.getName().equals(graphB.getName())) {
            return false;
        }
        if (!graphA.getDescription().equals(graphB.getDescription())) {
            return false;
        }
        if (!TabularGraphUtils.tabularGraphEntitiesAreEqual(graphA.getEntities(), graphB.getEntities())) {
            return false;
        }
        if (!TabularGraphUtils.tabularGraphLinksAreEqual(graphA.getLinks(), graphB.getLinks())) {
            return false;
        }
        return TabularGraphUtils.propertiesAreEqual(graphA.getTypeStrictProperties(), graphB.getTypeStrictProperties());
    }

    private static boolean tabularGraphEntitiesAreEqual(TabularGraphEntity entityA, TabularGraphEntity entityB) {
        return entityA.getEntitySpecName().equals(entityB.getEntitySpecName());
    }

    private static boolean tabularGraphEntitiesAreEqual(List<TabularGraphEntity> entitiesA, List<TabularGraphEntity> entitiesB) {
        if (entitiesA == entitiesB) {
            return true;
        }
        if (entitiesA == null || entitiesB == null) {
            return false;
        }
        if (entitiesA.size() != entitiesB.size()) {
            return false;
        }
        for (int i = 0; i < entitiesA.size(); ++i) {
            if (TabularGraphUtils.tabularGraphEntitiesAreEqual(entitiesA.get(i), entitiesB.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean tabularGraphLinksAreEqual(TabularGraphLink linkA, TabularGraphLink linkB) {
        return linkA.getIndex() == linkB.getIndex() && TabularGraphUtils.tabularGraphEntitiesAreEqual(linkA.getSource(), linkB.getSource()) && TabularGraphUtils.tabularGraphEntitiesAreEqual(linkA.getTarget(), linkB.getTarget());
    }

    private static boolean tabularGraphLinksAreEqual(List<TabularGraphLink> linksA, List<TabularGraphLink> linksB) {
        if (linksA == linksB) {
            return true;
        }
        if (linksA == null || linksB == null) {
            return false;
        }
        if (linksA.size() != linksB.size()) {
            return false;
        }
        for (int i = 0; i < linksA.size(); ++i) {
            if (TabularGraphUtils.tabularGraphLinksAreEqual(linksA.get(i), linksB.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean propertiesAreEqual(Map<String, Set<String>> propertiesA, Map<String, Set<String>> propertiesB) {
        Set<String> setB;
        Set<String> setA;
        if (propertiesA == propertiesB) {
            return true;
        }
        if (propertiesA == null || propertiesB == null) {
            return false;
        }
        if (propertiesA.size() != propertiesB.size()) {
            return false;
        }
        for (String key : propertiesA.keySet()) {
            setA = propertiesA.get(key);
            if (TabularGraphUtils.stringSetsAreEqual(setA, setB = propertiesB.get(key))) continue;
            return false;
        }
        for (String key : propertiesB.keySet()) {
            setA = propertiesA.get(key);
            if (TabularGraphUtils.stringSetsAreEqual(setA, setB = propertiesB.get(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean stringSetsAreEqual(Set<String> setA, Set<String> setB) {
        return setB.containsAll(setA) && setA.containsAll(setB);
    }
}

