/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.maltego.tx3.java.api.discovery.DisplayField;
import com.maltego.tx3.java.api.discovery.V3EntityOverlay;
import com.maltego.tx3.java.api.execution.Property;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Entity {
    private final String id;
    private final String valueRef;
    private final String iconUrl;
    private final Integer weight;
    private final List<Property> properties;
    private final List<DisplayField> displayInformation;
    private final String type;
    private final Bookmark bookmark;
    private final List<String> baseEntities;
    private final List<V3EntityOverlay> overlays;
    private final String note;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Entity(@JsonProperty(value="id") String id, @JsonProperty(value="valueRef") String valueRef, @JsonProperty(value="iconUrl") String iconUrl, @JsonProperty(value="weight") Integer weight, @JsonProperty(value="properties") List<Property> properties, @JsonProperty(value="displayInformation") List<DisplayField> displayInformation, @JsonProperty(value="type") String type, @JsonProperty(value="bookmark") Bookmark bookmark, @JsonProperty(value="baseEntities") List<String> baseEntities, @JsonProperty(value="overlays") List<V3EntityOverlay> overlays, @JsonProperty(value="note") String note) {
        this.id = id;
        this.valueRef = valueRef;
        this.iconUrl = iconUrl;
        this.weight = weight;
        this.properties = properties;
        this.displayInformation = displayInformation;
        this.type = type;
        this.bookmark = bookmark;
        this.baseEntities = baseEntities;
        this.overlays = overlays;
        this.note = note;
    }

    public String getId() {
        return this.id;
    }

    public String getValueRef() {
        return this.valueRef;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<DisplayField> getDisplayInformation() {
        return this.displayInformation;
    }

    public String getType() {
        return this.type;
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    public List<String> getBaseEntities() {
        return this.baseEntities;
    }

    public List<V3EntityOverlay> getOverlays() {
        return this.overlays;
    }

    public String getNote() {
        return this.note;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        return Objects.equals(this.id, entity.id) && Objects.equals(this.valueRef, entity.valueRef) && Objects.equals(this.iconUrl, entity.iconUrl) && Objects.equals(this.weight, entity.weight) && Objects.equals(this.properties, entity.properties) && Objects.equals(this.displayInformation, entity.displayInformation) && Objects.equals(this.type, entity.type) && Objects.equals((Object)this.bookmark, (Object)entity.bookmark) && Objects.equals(this.baseEntities, entity.baseEntities) && Objects.equals(this.overlays, entity.overlays) && Objects.equals(this.note, entity.note);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.valueRef, this.iconUrl, this.weight, this.properties, this.displayInformation, this.type, this.bookmark, this.baseEntities, this.overlays, this.note});
    }

    public static enum Bookmark {
        NONE(-1),
        BLUE(0),
        GREEN(1),
        YELLOW(2),
        PURPLE(3),
        RED(4);

        private final Integer code;

        private Bookmark(Integer code) {
            this.code = code;
        }

        @JsonValue
        public Integer getCode() {
            return this.code;
        }

        @JsonCreator
        public static Bookmark fromCode(Integer code) {
            if (code == null) {
                return null;
            }
            for (Bookmark bookmark : Bookmark.values()) {
                if (!Objects.equals(bookmark.getCode(), code)) continue;
                return bookmark;
            }
            throw new IllegalArgumentException("Invalid value for Bookmark: " + code);
        }
    }
}

