/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp;

import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.XmlPullParserUtils;
import com.paterva.maltego.collab.session.CollaborationServerInfo;
import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import com.paterva.maltego.collab.session.xmpp.PayloadEncoder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

class Utils {
    public static final String MTG_EXT = "mtg";

    private Utils() {
    }

    public static String getConferenceRoom(CollaborationSessionInfo info) {
        CollaborationServerInfo serverInfo = info.getServerInfo();
        String conferenceService = serverInfo.getConferenceService();
        return String.format("%s@%s", info.getRoomName().toLowerCase(), conferenceService.toLowerCase());
    }

    public static String getMyJid(CollaborationSessionInfo info) {
        return String.format("%s/%s", Utils.getConferenceRoom(info), info.getUsername().toLowerCase());
    }

    static String createEncodedContent(PayloadEncoder encoder, String payload) throws CollaborationException {
        return encoder.encode(String.format("<%s>%s</%s>", MTG_EXT, payload, MTG_EXT));
    }

    public static String getRoom(String jid) {
        if (jid != null) {
            int pos = jid.indexOf("/");
            if (pos > 0) {
                return jid.substring(0, pos);
            }
            return jid;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> parsePayloads(String xml) throws CollaborationException {
        try {
            XmlPullParser parser = Utils.parserFactory().newPullParser();
            try (StringReader reader = new StringReader(xml);){
                parser.setInput((Reader)reader);
                Map<String, String> map = Utils.parsePayloads(parser);
                return map;
            }
        }
        catch (XmlPullParserException ex) {
            throw new CollaborationException(ex, true);
        }
    }

    private static XmlPullParserFactory parserFactory() throws XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        return factory;
    }

    public static String stripOuterTags(XmlPullParser parser) throws CollaborationException {
        try {
            return Utils.stripOuterTags(XmlPullParserUtils.toXml(parser));
        }
        catch (XmlPullParserException ex) {
            throw new CollaborationException(ex, true);
        }
        catch (IOException ex) {
            throw new CollaborationException(ex, true);
        }
    }

    public static String stripOuterTags(String xml) {
        int end;
        int start = xml.indexOf(62);
        if (start > 0 && (end = xml.lastIndexOf("</")) > start) {
            return xml.substring(start + 1, end).trim();
        }
        return xml;
    }

    private static Map<String, String> parsePayloads(XmlPullParser parser) throws XmlPullParserException, IOException {
        int eventType;
        boolean stop;
        boolean start = false;
        int startDepth = -1;
        LinkedHashMap<String, String> payloads = new LinkedHashMap<String, String>();
        do {
            eventType = parser.next();
            int currentDepth = parser.getDepth();
            boolean bl = stop = currentDepth < startDepth;
            if (eventType == 2) {
                if (start) {
                    String xml = XmlPullParserUtils.toXml(parser);
                    if (xml != null) {
                        xml = xml.trim();
                    }
                    payloads.put(parser.getName(), xml);
                    continue;
                }
                start = MTG_EXT.equals(parser.getName());
                continue;
            }
            if (eventType != 3) continue;
            boolean bl2 = stop = currentDepth < startDepth;
        } while (!stop && eventType != 1);
        return payloads;
    }
}

