/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public class SkippableWizardIterator<Data>
implements WizardDescriptor.Iterator<Data> {
    private WizardDescriptor.Panel<Data>[] _panels;
    private int _index = 0;
    private ChangeSupport _changeSupport;

    public SkippableWizardIterator(WizardDescriptor.Panel<Data>[] panels) {
        this._panels = panels;
    }

    public WizardDescriptor.Panel<Data> current() {
        System.out.println("getting " + (this._index + 1));
        return this._panels[this._index];
    }

    public String name() {
        return "hannes";
    }

    public boolean hasNext() {
        return this._index < this._panels.length - 1;
    }

    public boolean hasPrevious() {
        return this._index > 0;
    }

    public void nextPanel() {
        ++this._index;
        System.out.println("moved to " + (this._index + 1));
    }

    public void previousPanel() {
        --this._index;
    }

    public void moveTo(int index) {
        this._index = index;
        this._changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener cl) {
        if (this._changeSupport == null) {
            this._changeSupport = new ChangeSupport((Object)this);
        }
        this._changeSupport.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this._changeSupport != null) {
            this._changeSupport.removeChangeListener(cl);
        }
    }

    private static class NumberPanel
    implements WizardDescriptor.Panel {
        private int _number;

        public NumberPanel(int number) {
            this._number = number;
        }

        public Component getComponent() {
            System.out.println("retrieve " + this._number);
            return new JLabel(String.valueOf(this._number));
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(Object data) {
            System.out.println("read " + this._number);
        }

        public void storeSettings(Object data) {
            System.out.println("store " + this._number);
        }

        public boolean isValid() {
            return true;
        }

        public void addChangeListener(ChangeListener cl) {
        }

        public void removeChangeListener(ChangeListener cl) {
        }
    }
}

