/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.fonts;

import com.paterva.maltego.util.ui.fonts.FontSizeRegistry;
import com.paterva.maltego.util.ui.fonts.OtherComponentsFontSize;
import java.awt.Font;
import javax.swing.JLabel;

public class FontUtils {
    public static Font defaultFont() {
        return new JLabel().getFont();
    }

    public static Font defaultScaled(float change) {
        return FontUtils.scale(FontUtils.defaultFont(), change);
    }

    public static Font defaultStyledScaled(int style, float change) {
        return FontUtils.defaultScaled(change).deriveFont(style);
    }

    public static Font scale(Font font, float change) {
        return font.deriveFont((float)font.getSize() + change);
    }

    public static Font scale(Font font) {
        int sizeDiff;
        if (font != null && (sizeDiff = FontUtils.getSizeDiff()) != 0) {
            font = FontUtils.scale(font, sizeDiff);
        }
        return font;
    }

    public static int getSizeDiff() {
        FontSizeRegistry registry = FontSizeRegistry.getDefault();
        int currentSize = registry.getFontSize("otherComponentsFontSize");
        int sizeDiff = currentSize - OtherComponentsFontSize.DEFAULT;
        return sizeDiff;
    }
}

