/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.list.bundle;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettingsEvent;
import com.paterva.maltego.util.ui.components.LeftAlignedToggleButton;
import com.paterva.maltego.view.customization.api.CustomizableViewRegistry;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.AbstractAction;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;

public final class ListViewButton
extends LeftAlignedToggleButton {
    private final GraphID graphID;
    private TopComponent tc;
    private PropertyChangeListener settingsListener;

    public ListViewButton(GraphID graphID) {
        this.graphID = graphID;
        this.setAction(new ELVAction());
        this.setIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/view/list/bundle/listview16.png", (boolean)false));
        this.setOpaque(false);
        this.setToolTipText("List View");
        this.setMaximumSize(new Dimension(28, 28));
    }

    public void addNotify() {
        super.addNotify();
        this.settingsListener = new SettingsListener();
        EntityPainterSettings.getDefault().addPropertyChangeListener(this.settingsListener);
        this.updateSelected();
    }

    public void removeNotify() {
        EntityPainterSettings.getDefault().removePropertyChangeListener(this.settingsListener);
        this.settingsListener = null;
        super.removeNotify();
    }

    private void updateSelected() {
        this.setSelected(this.isSelectedCustom());
    }

    private boolean isSelectedCustom() {
        return "ListView".equals(EntityPainterSettings.getDefault().getEntityPainter(this.graphID).getName());
    }

    private synchronized TopComponent getTc() {
        if (this.tc == null) {
            GraphEditorRegistry registry = GraphEditorRegistry.getDefault();
            TopComponent tComponent = registry.getTopmost();
            if (this.isButtonTc(tComponent)) {
                this.tc = tComponent;
            } else {
                for (TopComponent topComponent : registry.getOpen()) {
                    if (Objects.equals(tComponent, topComponent) || !this.isButtonTc(topComponent)) continue;
                    this.tc = topComponent;
                    break;
                }
            }
        }
        return this.tc;
    }

    private boolean isButtonTc(TopComponent component) {
        GraphCookie lookup = (GraphCookie)component.getLookup().lookup(GraphCookie.class);
        return lookup != null && this.graphID.equals((Object)lookup.getGraphID());
    }

    private class SettingsListener
    implements PropertyChangeListener {
        private SettingsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("painterChanged".equals(evt.getPropertyName())) {
                TopComponent.SubComponent[] subComponents;
                TopComponent tc;
                EntityPainterSettingsEvent event = (EntityPainterSettingsEvent)evt.getNewValue();
                if (ListViewButton.this.graphID.equals((Object)event.getGraphID()) && (tc = ListViewButton.this.getTc()) != null && (subComponents = tc.getSubComponents()).length > 1) {
                    if ("ListView".equals(event.getPainterNameAfter())) {
                        subComponents[1].activate();
                        ListViewButton.this.setSelected(true);
                    } else {
                        subComponents[0].activate();
                        ListViewButton.this.setSelected(false);
                    }
                }
            }
        }
    }

    private class ELVAction
    extends AbstractAction {
        private ELVAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ListViewButton.this.isSelectedCustom()) {
                EntityPainterSettings.getDefault().setEntityPainter(ListViewButton.this.graphID, "ListView");
                CustomizableViewRegistry.getDefault().getView(ListViewButton.this.graphID).setActiveViewlet("ListView");
            }
            ListViewButton.this.setSelected(true);
        }
    }
}

