/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.merge;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.merging.PartMergeStrategy;
import com.paterva.maltego.ui.graph.merge.MergeEntityPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;

public class MergeOptionsPanel
extends JPanel {
    private final GraphID _destGraphID;
    private final GraphID _srcGraphID;
    private final MaltegoEntity _srcEntity;
    private final MaltegoEntity _destEntity;
    private JCheckBox _doForAllCheckBox;
    private JRadioButton _keepBothRadioButton;
    private JRadioButton _keepOriginalRadioButton;
    private JRadioButton _mergeRadioButton;
    private JPanel _newPanel;
    private JPanel _originalPanel;
    private JRadioButton _preferNewRadioButton;
    private JRadioButton _preferOriginalRadioButton;
    private JRadioButton _replaceRadioButton;
    private JRadioButton _skipRadioButton;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;

    public MergeOptionsPanel(GraphID destGraphID, GraphID srcGraphID, MaltegoEntity destEntity, MaltegoEntity srcEntity, int remaining) {
        this._destGraphID = destGraphID;
        this._srcGraphID = srcGraphID;
        this._destEntity = destEntity;
        this._srcEntity = srcEntity;
        this.initComponents();
        this._doForAllCheckBox.setSelected(false);
        if (remaining > 0) {
            this._doForAllCheckBox.setText("Do this for all remaining matches (" + remaining + ")");
        } else {
            this._doForAllCheckBox.setVisible(false);
        }
        this.populateEntityPanel(this._originalPanel, this._destGraphID, this._destGraphID, this._destEntity, "Original");
        this.populateEntityPanel(this._newPanel, this._srcGraphID, this._destGraphID, this._srcEntity, "New");
    }

    public void setSkipEntities() {
        this._skipRadioButton.setSelected(true);
        this.updateStrategyRadioButtons();
    }

    public void setKeepBothEntities() {
        this._keepBothRadioButton.setSelected(true);
        this.updateStrategyRadioButtons();
    }

    public void setMergeEntities() {
        this._mergeRadioButton.setSelected(true);
        this.updateStrategyRadioButtons();
    }

    public boolean isSkipEntity() {
        return this._skipRadioButton.isSelected();
    }

    public boolean isKeepBothEntity() {
        return this._keepBothRadioButton.isSelected();
    }

    public boolean isMergeEntities() {
        return this._mergeRadioButton.isSelected();
    }

    public void setMergeStrategy(PartMergeStrategy strat) {
        if (PartMergeStrategy.PreferNew.equals(strat)) {
            this._preferNewRadioButton.setSelected(true);
        } else if (PartMergeStrategy.PreferOriginal.equals(strat)) {
            this._preferOriginalRadioButton.setSelected(true);
        } else if (PartMergeStrategy.Replace.equals(strat)) {
            this._replaceRadioButton.setSelected(true);
        } else if (PartMergeStrategy.KeepOriginal.equals(strat)) {
            this._keepOriginalRadioButton.setSelected(true);
        }
    }

    public PartMergeStrategy getMergeStrategy() {
        if (this._preferNewRadioButton.isSelected()) {
            return PartMergeStrategy.PreferNew;
        }
        if (this._preferOriginalRadioButton.isSelected()) {
            return PartMergeStrategy.PreferOriginal;
        }
        if (this._replaceRadioButton.isSelected()) {
            return PartMergeStrategy.Replace;
        }
        if (this._keepOriginalRadioButton.isSelected()) {
            return PartMergeStrategy.KeepOriginal;
        }
        return null;
    }

    public boolean isDoForAll() {
        return this._doForAllCheckBox.isSelected();
    }

    private void initComponents() {
        ButtonGroup mergeRadioButtonGroup = new ButtonGroup();
        ButtonGroup strategyButtonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this._originalPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this._newPanel = new JPanel();
        this.jPanel3 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jPanel4 = new JPanel();
        this._doForAllCheckBox = new JCheckBox();
        this._keepBothRadioButton = new JRadioButton();
        this._mergeRadioButton = new JRadioButton();
        JLabel jLabel2 = new JLabel();
        this._preferNewRadioButton = new JRadioButton();
        this._preferOriginalRadioButton = new JRadioButton();
        this._replaceRadioButton = new JRadioButton();
        this._keepOriginalRadioButton = new JRadioButton();
        this._skipRadioButton = new JRadioButton();
        this.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 0));
        GroupLayout _originalPanelLayout = new GroupLayout(this._originalPanel);
        this._originalPanel.setLayout(_originalPanelLayout);
        _originalPanelLayout.setHorizontalGroup(_originalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        _originalPanelLayout.setVerticalGroup(_originalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 103, Short.MAX_VALUE));
        this.jPanel1.add(this._originalPanel);
        this.jPanel2.setLayout(new BorderLayout());
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 1, this.jLabel3.getFont().getSize() + 7));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText(NbBundle.getMessage(MergeOptionsPanel.class, (String)"MergeOptionsPanel.jLabel3.text"));
        this.jPanel2.add((Component)this.jLabel3, "Center");
        this.jPanel1.add(this.jPanel2);
        GroupLayout _newPanelLayout = new GroupLayout(this._newPanel);
        this._newPanel.setLayout(_newPanelLayout);
        _newPanelLayout.setHorizontalGroup(_newPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        _newPanelLayout.setVerticalGroup(_newPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 103, Short.MAX_VALUE));
        this.jPanel1.add(this._newPanel);
        this.add((Component)this.jPanel1, "Center");
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel3.setLayout(new BorderLayout());
        jLabel1.setText(NbBundle.getMessage(MergeOptionsPanel.class, (String)"MergeOptionsPanel.jLabel1.text"));
        this.jPanel3.add((Component)jLabel1, "Center");
        this.add((Component)this.jPanel3, "North");
        this._doForAllCheckBox.setText(NbBundle.getMessage(MergeOptionsPanel.class, (String)"MergeOptionsPanel._doForAllCheckBox.text"));
        mergeRadioButtonGroup.add(this._keepBothRadioButton);
        this._keepBothRadioButton.setText(NbBundle.getMessage(MergeOptionsPanel.class, (String)"MergeOptionsPanel._keepBothRadioButton.text"));
        this._keepBothRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeOptionsPanel.this._keepBothRadioButtonActionPerformed(evt);
            }
        });
        mergeRadioButtonGroup.add(this._mergeRadioButton);
        this._mergeRadioButton.setText(NbBundle.getMessage(MergeOptionsPanel.class, (String)"MergeOptionsPanel._mergeRadioButton.text"));
        this._mergeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeOptionsPanel.this._mergeRadioButtonActionPerformed(evt);
            }
        });
        jLabel2.setText(NbBundle.getMessage(MergeOptionsPanel.class, (String)"MergeOptionsPanel.jLabel2.text"));
        strategyButtonGroup.add(this._preferNewRadioButton);
        this._preferNewRadioButton.setText(NbBundle.getMessage(MergeOptionsPanel.class, (String)"MergeOptionsPanel._preferNewRadioButton.text"));
        strategyButtonGroup.add(this._preferOriginalRadioButton);
        this._preferOriginalRadioButton.setText(NbBundle.getMessage(MergeOptionsPanel.class, (String)"MergeOptionsPanel._preferOriginalRadioButton.text"));
        strategyButtonGroup.add(this._replaceRadioButton);
        this._replaceRadioButton.setText(NbBundle.getMessage(MergeOptionsPanel.class, (String)"MergeOptionsPanel._replaceRadioButton.text"));
        strategyButtonGroup.add(this._keepOriginalRadioButton);
        this._keepOriginalRadioButton.setText(NbBundle.getMessage(MergeOptionsPanel.class, (String)"MergeOptionsPanel._keepOriginalRadioButton.text"));
        mergeRadioButtonGroup.add(this._skipRadioButton);
        this._skipRadioButton.setText(NbBundle.getMessage(MergeOptionsPanel.class, (String)"MergeOptionsPanel._skipRadioButton.text"));
        this._skipRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeOptionsPanel.this._skipRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._doForAllCheckBox).addComponent(this._skipRadioButton).addComponent(this._mergeRadioButton).addComponent(this._keepBothRadioButton).addGroup(jPanel4Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._preferOriginalRadioButton).addComponent(this._preferNewRadioButton).addComponent(this._replaceRadioButton).addComponent(this._keepOriginalRadioButton))).addComponent(jLabel2)).addContainerGap(62, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._skipRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._keepBothRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._mergeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._preferNewRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._preferOriginalRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._replaceRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._keepOriginalRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._doForAllCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel4, "South");
    }

    private void _mergeRadioButtonActionPerformed(ActionEvent evt) {
        this.updateStrategyRadioButtons();
    }

    private void _keepBothRadioButtonActionPerformed(ActionEvent evt) {
        this.updateStrategyRadioButtons();
    }

    private void _skipRadioButtonActionPerformed(ActionEvent evt) {
        this.updateStrategyRadioButtons();
    }

    private void populateEntityPanel(JPanel panel, GraphID graphID, GraphID registryGraphID, MaltegoEntity entity, String title) {
        MergeEntityPanel p = new MergeEntityPanel(graphID, registryGraphID, entity, title);
        panel.setLayout(new BorderLayout());
        panel.add(p);
    }

    private void updateStrategyRadioButtons() {
        boolean isMerge = this.isMergeEntities();
        this._preferNewRadioButton.setEnabled(isMerge);
        this._preferOriginalRadioButton.setEnabled(isMerge);
        this._replaceRadioButton.setEnabled(isMerge);
        this._keepOriginalRadioButton.setEnabled(isMerge);
    }
}

