/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import yguard.A.A.E;
import yguard.A.A.X;
import yguard.A.A.Y;
import yguard.A.G.RA;
import yguard.A.G.n;

public abstract class AbstractAlignLayouter
implements n {
    protected abstract double getAlignDirectionMin(RA var1, Y var2);

    protected abstract double getAlignDirectionSize(RA var1, Y var2);

    protected abstract double getAlignDimensionMin(RA var1, Y var2);

    protected abstract double getAlignDimensionSize(RA var1, Y var2);

    protected abstract double getAlignPercentage();

    protected abstract void setAlignDimensionMin(RA var1, Y var2, double var3);

    protected double getMargin() {
        return 10.0;
    }

    public void doLayout(RA graph) {
        if (graph.\u00c4()) {
            return;
        }
        X sortedNodes = new X(graph.\u00a4());
        sortedNodes.sort((Comparator)new AlignValueComparator(graph));
        ArrayList<List<Y>> nodeMatrix = new ArrayList<List<Y>>();
        E nc = sortedNodes.\u0121();
        while (nc.ok()) {
            Y node = nc.B();
            List<Y> listForNode = this.findNodeList(graph, nodeMatrix, node);
            if (listForNode == null) {
                listForNode = new ArrayList<Y>();
                nodeMatrix.add(listForNode);
            }
            listForNode.add(node);
            nc.next();
        }
        double alignValue = this.getAlignValue(graph, (Y)sortedNodes.get(0));
        List prevNodeList = null;
        for (List list : nodeMatrix) {
            if (prevNodeList != null) {
                double prevListMax = this.getAlignDimensionMax(graph, prevNodeList);
                double minToAlignValue = this.getMaxDiffBetweenMinAndAlignValue(graph, list);
                alignValue = prevListMax + this.getMargin() + minToAlignValue;
            }
            for (Y listNode : list) {
                this.setAlignValue(graph, listNode, alignValue);
            }
            prevNodeList = list;
        }
    }

    private double getAlignValue(RA graph, Y node) {
        double min = this.getAlignDimensionMin(graph, node);
        double size = this.getAlignDimensionSize(graph, node);
        return min + size * this.getAlignPercentage();
    }

    private void setAlignValue(RA graph, Y node, double value) {
        double size = this.getAlignDimensionSize(graph, node);
        double min = value - size * this.getAlignPercentage();
        this.setAlignDimensionMin(graph, node, min);
    }

    private List<Y> findNodeList(RA graph, List<List<Y>> nodeMatrix, Y node) {
        double nodeMin = this.getAlignDirectionMin(graph, node);
        double nodeSize = this.getAlignDirectionSize(graph, node);
        List<Y> listForNode = null;
        for (List<Y> nodeList : nodeMatrix) {
            if (this.intersectsAny(graph, nodeList, nodeMin, nodeSize)) continue;
            listForNode = nodeList;
            break;
        }
        return listForNode;
    }

    private boolean intersectsAny(RA graph, List<Y> nodeList, double nodeMin, double nodeSize) {
        double nodeMax = nodeMin + nodeSize;
        for (Y listNode : nodeList) {
            double listNodeMax;
            double listNodeMin = this.getAlignDirectionMin(graph, listNode);
            if (!this.intersects(nodeMin, nodeMax, listNodeMin, listNodeMax = listNodeMin + this.getAlignDirectionSize(graph, listNode))) continue;
            return true;
        }
        return false;
    }

    private boolean intersects(double min1, double max1, double min2, double max2) {
        return !(max1 < min2) && !(max2 < min1);
    }

    private double getAlignDimensionMax(RA graph, List<Y> nodes) {
        double maxValue = -1.7976931348623157E308;
        for (Y node : nodes) {
            double min = this.getAlignDimensionMin(graph, node);
            double size = this.getAlignDimensionSize(graph, node);
            double value = min + size;
            maxValue = Math.max(maxValue, value);
        }
        return maxValue;
    }

    private double getMaxDiffBetweenMinAndAlignValue(RA graph, List<Y> nodes) {
        double maxDiff = -1.7976931348623157E308;
        for (Y node : nodes) {
            double min = this.getAlignDimensionMin(graph, node);
            double alignValue = this.getAlignValue(graph, node);
            double diff = alignValue - min;
            maxDiff = Math.max(maxDiff, diff);
        }
        return maxDiff;
    }

    public boolean canLayout(RA graph) {
        return true;
    }

    private class AlignValueComparator
    implements Comparator<Y> {
        private RA _graph;

        public AlignValueComparator(RA graph) {
            this._graph = graph;
        }

        @Override
        public int compare(Y node1, Y node2) {
            double alignValue2;
            double alignValue1 = AbstractAlignLayouter.this.getAlignValue(this._graph, node1);
            return alignValue1 <= (alignValue2 = AbstractAlignLayouter.this.getAlignValue(this._graph, node2)) ? -1 : 1;
        }
    }
}

