/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2;

import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.caret.CaretInfo;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.DocUtils;
import org.netbeans.modules.editor.lib2.RectangularSelectionCaretAccessor;
import org.netbeans.modules.editor.lib2.RectangularSelectionUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EditorCaretTransferHandler
extends TransferHandler {
    private static final DataFlavor RECTANGULAR_SELECTION_FLAVOR = new DataFlavor(RectangularSelectionData.class, NbBundle.getMessage(EditorCaretTransferHandler.class, (String)"MSG_RectangularSelectionClipboardFlavor"));
    private static final DataFlavor MULTI_CARET_FLAVOR = new DataFlavor(MultiCaretData.class, NbBundle.getMessage(EditorCaretTransferHandler.class, (String)"MSG_MultiCaretClipboardFlavor"));
    private static final String RECTANGULAR_SELECTION_PROPERTY = "rectangular-selection";
    private static final String PASTE_LINES_PROPERTY = "clipboard-lines";
    private static final Logger LOG = Logger.getLogger(EditorCaretTransferHandler.class.getName());
    private final TransferHandler delegate;

    public static void install(JTextComponent c) {
        TransferHandler origHandler = c.getTransferHandler();
        if (!(origHandler instanceof EditorCaretTransferHandler)) {
            c.setTransferHandler(new EditorCaretTransferHandler(c.getTransferHandler()));
        }
    }

    public static void uninstall(JTextComponent c) {
        TransferHandler origHandler = c.getTransferHandler();
        if (origHandler instanceof EditorCaretTransferHandler) {
            c.setTransferHandler(((EditorCaretTransferHandler)origHandler).getDelegate());
        }
    }

    public EditorCaretTransferHandler(TransferHandler delegate) {
        this.delegate = delegate;
    }

    TransferHandler getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return this.delegate.canImport(support);
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return this.delegate.canImport(comp, transferFlavors);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        try {
            Method method = this.delegate.getClass().getDeclaredMethod("createTransferable", JComponent.class);
            method.setAccessible(true);
            return (Transferable)method.invoke((Object)this.delegate, c);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        this.delegate.exportAsDrag(comp, e, action);
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        try {
            Method method = this.delegate.getClass().getDeclaredMethod("exportDone", JComponent.class, Transferable.class, Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this.delegate, source, data, new Integer(action));
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportToClipboard(JComponent c, Clipboard clip, int action) throws IllegalStateException {
        List<Position> regions;
        if (c instanceof JTextComponent && Boolean.TRUE.equals(c.getClientProperty(RECTANGULAR_SELECTION_PROPERTY)) && (regions = RectangularSelectionUtils.regionsCopy(c)) != null) {
            String[] data;
            StringBuilder stringSelectionBuffer;
            JTextComponent tc = (JTextComponent)c;
            AbstractDocument doc = (AbstractDocument)tc.getDocument();
            doc.readLock();
            try {
                CharSequence docText = DocumentUtilities.getText((Document)doc);
                stringSelectionBuffer = new StringBuilder(100);
                int size = regions.size();
                data = new String[size >>> 1];
                for (int i = 0; i < size; ++i) {
                    Position startPos = regions.get(i++);
                    Position endPos = regions.get(i);
                    CharSequence lineSel = docText.subSequence(startPos.getOffset(), endPos.getOffset());
                    int halfI = i >>> 1;
                    if (halfI != 0) {
                        stringSelectionBuffer.append('\n');
                    }
                    stringSelectionBuffer.append(lineSel);
                    data[halfI] = lineSel.toString();
                }
            }
            finally {
                doc.readUnlock();
            }
            clip.setContents(new RectangularTransferable(new StringSelection(stringSelectionBuffer.toString()), new RectangularSelectionData(data)), null);
            if (action == 2) {
                try {
                    RectangularSelectionUtils.removeSelection(doc, regions);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return;
        }
        if (c instanceof JTextComponent && ((JTextComponent)c).getCaret() instanceof EditorCaret && ((EditorCaret)((JTextComponent)c).getCaret()).getCarets().size() > 1) {
            StringBuilder stringSelectionBuffer;
            EditorCaret editorCaret = (EditorCaret)((JTextComponent)c).getCaret();
            JTextComponent tc = (JTextComponent)c;
            String[] lines = null;
            AbstractDocument doc = (AbstractDocument)tc.getDocument();
            doc.readLock();
            try {
                CharSequence docText = DocumentUtilities.getText((Document)doc);
                stringSelectionBuffer = new StringBuilder(100);
                List<CaretInfo> carets = editorCaret.getSortedCarets();
                lines = new String[carets.size()];
                boolean newline = false;
                for (int i = 0; i < carets.size(); ++i) {
                    CaretInfo caret = carets.get(i);
                    if (!caret.isSelection()) continue;
                    int startOffset = caret.getSelectionStart();
                    int endOffset = caret.getSelectionEnd();
                    CharSequence lineSel = docText.subSequence(startOffset, endOffset);
                    if (newline) {
                        stringSelectionBuffer.append('\n');
                    } else {
                        newline = true;
                    }
                    stringSelectionBuffer.append(lineSel);
                    lines[i] = lineSel.toString();
                }
            }
            finally {
                doc.readUnlock();
            }
            clip.setContents(new MultiCaretTransferable(new StringSelection(stringSelectionBuffer.toString()), new MultiCaretData(lines)), null);
            if (action == 2) {
                List<CaretInfo> carets = editorCaret.getSortedCarets();
                for (CaretInfo caret : carets) {
                    if (!caret.isSelection()) continue;
                    int dot = caret.getDot();
                    int mark = caret.getMark();
                    try {
                        if (RectangularSelectionUtils.isRectangularSelection(tc)) {
                            RectangularSelectionUtils.removeSelection(tc);
                            RectangularSelectionCaretAccessor.get().setRectangularSelectionToDotAndMark(editorCaret);
                            continue;
                        }
                        doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
                    }
                    catch (BadLocationException ble) {
                        LOG.log(Level.FINE, null, ble);
                    }
                }
            }
            return;
        }
        this.delegate.exportToClipboard(c, clip, action);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return this.delegate.getSourceActions(c);
    }

    @Override
    public Icon getVisualRepresentation(Transferable t) {
        return this.delegate.getVisualRepresentation(t);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        Component c = support.getComponent();
        Transferable t = support.getTransferable();
        if (c instanceof JTextComponent) {
            JTextComponent tc = (JTextComponent)c;
            if (RectangularSelectionUtils.isRectangularSelection(tc)) {
                if (t.isDataFlavorSupported(RECTANGULAR_SELECTION_FLAVOR)) {
                    boolean result = false;
                    try {
                        final RectangularSelectionData data = (RectangularSelectionData)t.getTransferData(RECTANGULAR_SELECTION_FLAVOR);
                        final List<Position> regions = RectangularSelectionUtils.regionsCopy(tc);
                        final Document doc = tc.getDocument();
                        DocUtils.runAtomicAsUser(doc, new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    int doubleI;
                                    RectangularSelectionUtils.removeSelection(doc, regions);
                                    String[] strings = data.strings();
                                    for (int i = 0; i < strings.length && (doubleI = i << 1) < regions.size(); ++i) {
                                        Position linePos = (Position)regions.get(doubleI);
                                        doc.insertString(linePos.getOffset(), strings[i], null);
                                    }
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        });
                        result = true;
                    }
                    catch (UnsupportedFlavorException | IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return result;
                }
                if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        String s = (String)t.getTransferData(DataFlavor.stringFlavor);
                        final List<String> dataLines = EditorCaretTransferHandler.splitByLines(s);
                        final List<Position> regions = RectangularSelectionUtils.regionsCopy(tc);
                        final Document doc = tc.getDocument();
                        final int dataLinesSize = dataLines.size();
                        final int regionsSize = regions.size();
                        if (dataLinesSize > 0 && regionsSize > 0) {
                            DocUtils.runAtomicAsUser(doc, new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        RectangularSelectionUtils.removeSelection(doc, regions);
                                        int dataLineIndex = 0;
                                        for (int i = 0; i < regionsSize; i += 2) {
                                            Position linePos = (Position)regions.get(i);
                                            doc.insertString(linePos.getOffset(), (String)dataLines.get(dataLineIndex++), null);
                                            if (dataLineIndex < dataLinesSize) continue;
                                            dataLineIndex = 0;
                                        }
                                    }
                                    catch (BadLocationException badLocationException) {
                                        // empty catch block
                                    }
                                }
                            });
                            return true;
                        }
                        return false;
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            } else {
                Caret caret = ((JTextComponent)c).getCaret();
                if (caret instanceof EditorCaret && ((EditorCaret)caret).getSortedCarets().size() > 1) {
                    Object content;
                    final EditorCaret editorCaret = (EditorCaret)caret;
                    boolean result = false;
                    MultiCaretData multiCaretData = null;
                    if (t.isDataFlavorSupported(MULTI_CARET_FLAVOR)) {
                        try {
                            multiCaretData = (MultiCaretData)t.getTransferData(MULTI_CARET_FLAVOR);
                        }
                        catch (UnsupportedFlavorException | IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    boolean pasteLines = false;
                    if (Boolean.TRUE.equals(((JTextComponent)c).getClientProperty(PASTE_LINES_PROPERTY))) {
                        if (multiCaretData != null) {
                            pasteLines = true;
                        } else {
                            try {
                                content = (String)t.getTransferData(DataFlavor.stringFlavor);
                                if (content != null && ((String)content).length() > 0) {
                                    multiCaretData = new MultiCaretData(((String)content).split("\n", editorCaret.getCarets().size()));
                                    pasteLines = true;
                                }
                            }
                            catch (UnsupportedFlavorException | IOException ex) {
                                LOG.info("Problem getting stringFlavor for paste as Lines.");
                            }
                        }
                    }
                    if (multiCaretData != null && (pasteLines || multiCaretData.strings().length == editorCaret.getCarets().size())) {
                        content = multiCaretData;
                        final Document doc = ((JTextComponent)c).getDocument();
                        DocUtils.runAtomicAsUser(doc, new Runnable((MultiCaretData)content){
                            final /* synthetic */ MultiCaretData val$content;
                            {
                                this.val$content = multiCaretData;
                            }

                            @Override
                            public void run() {
                                List<CaretInfo> sortedCarets = editorCaret.getSortedCarets();
                                for (int i = 0; i < sortedCarets.size(); ++i) {
                                    CaretInfo ci = sortedCarets.get(i);
                                    try {
                                        int startOffset = ci.getSelectionStart();
                                        int endOffset = ci.getSelectionEnd();
                                        if (startOffset != endOffset) {
                                            doc.remove(startOffset, endOffset - startOffset);
                                        }
                                        if (this.val$content.strings().length <= i || this.val$content.strings()[i] == null || this.val$content.strings()[i].length() <= 0) continue;
                                        doc.insertString(startOffset, this.val$content.strings()[i], null);
                                        continue;
                                    }
                                    catch (BadLocationException badLocationException) {
                                        // empty catch block
                                    }
                                }
                            }
                        });
                    } else {
                        try {
                            content = (String)t.getTransferData(DataFlavor.stringFlavor);
                            final Document doc = ((JTextComponent)c).getDocument();
                            DocUtils.runAtomicAsUser(doc, new Runnable((String)content){
                                final /* synthetic */ String val$content;
                                {
                                    this.val$content = string;
                                }

                                @Override
                                public void run() {
                                    for (CaretInfo ci : editorCaret.getSortedCarets()) {
                                        try {
                                            int startOffset = ci.getSelectionStart();
                                            int endOffset = ci.getSelectionEnd();
                                            if (startOffset != endOffset) {
                                                doc.remove(startOffset, endOffset - startOffset);
                                            }
                                            if (this.val$content == null || this.val$content.length() <= 0) continue;
                                            doc.insertString(startOffset, this.val$content, null);
                                        }
                                        catch (BadLocationException badLocationException) {}
                                    }
                                }
                            });
                            result = true;
                        }
                        catch (UnsupportedFlavorException | IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    return result;
                }
            }
        }
        return this.delegate.importData(support);
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        return this.delegate.importData(comp, t);
    }

    private static List<String> splitByLines(String s) {
        StringTokenizer splitByLines = new StringTokenizer(s, "\n", false);
        ArrayList<String> lines = new ArrayList<String>();
        while (splitByLines.hasMoreTokens()) {
            lines.add(splitByLines.nextToken());
        }
        return lines;
    }

    public static final class RectangularSelectionData {
        private final String[] strings;

        public RectangularSelectionData(String[] strings) {
            this.strings = strings;
        }

        public String[] strings() {
            return this.strings;
        }
    }

    public static final class MultiCaretData {
        private final String[] strings;

        public MultiCaretData(String[] strings) {
            this.strings = strings;
        }

        public String[] strings() {
            return this.strings;
        }
    }

    private static final class MultiCaretTransferable
    implements Transferable {
        private final Transferable delegate;
        private final MultiCaretData multiCaretData;
        private DataFlavor[] transferDataFlavorsCache;

        public MultiCaretTransferable(Transferable delegate, MultiCaretData multiCaretData) {
            this.delegate = delegate;
            this.multiCaretData = multiCaretData;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            if (this.transferDataFlavorsCache != null) {
                return this.transferDataFlavorsCache;
            }
            DataFlavor[] flavors = this.delegate.getTransferDataFlavors();
            DataFlavor[] result = Arrays.copyOf(flavors, flavors.length + 1);
            result[flavors.length] = MULTI_CARET_FLAVOR;
            this.transferDataFlavorsCache = result;
            return result;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return MULTI_CARET_FLAVOR.equals(flavor) || this.delegate.isDataFlavorSupported(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (MULTI_CARET_FLAVOR.equals(flavor)) {
                return this.multiCaretData;
            }
            return this.delegate.getTransferData(flavor);
        }
    }

    private static final class RectangularTransferable
    implements Transferable {
        private final Transferable delegate;
        private final RectangularSelectionData rectangularSelectionData;
        private DataFlavor[] transferDataFlavorsCache;

        public RectangularTransferable(Transferable delegate, RectangularSelectionData rectangularSelectionData) {
            this.delegate = delegate;
            this.rectangularSelectionData = rectangularSelectionData;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            if (this.transferDataFlavorsCache != null) {
                return this.transferDataFlavorsCache;
            }
            DataFlavor[] flavors = this.delegate.getTransferDataFlavors();
            DataFlavor[] result = Arrays.copyOf(flavors, flavors.length + 1);
            result[flavors.length] = RECTANGULAR_SELECTION_FLAVOR;
            this.transferDataFlavorsCache = result;
            return result;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return RECTANGULAR_SELECTION_FLAVOR.equals(flavor) || this.delegate.isDataFlavorSupported(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (RECTANGULAR_SELECTION_FLAVOR.equals(flavor)) {
                return this.rectangularSelectionData;
            }
            return this.delegate.getTransferData(flavor);
        }
    }
}

