/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.analytics;

import com.maltego.analytics.api.AnalyticsClient;
import com.maltego.analytics.api.AnalyticsEvent;
import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.util.NormalException;
import java.io.IOException;

public class RunMachineEvent {
    private static final String TRIGGER_KEY = "trigger";

    private RunMachineEvent() {
    }

    public static void send(String machineName, Trigger trigger) {
        try {
            boolean customMachine;
            MachineDescriptor descriptor = MachineRepository.getDefault().get(machineName);
            boolean bl = customMachine = !descriptor.isReadOnly();
            if (customMachine) {
                String machineNameHash = Integer.toHexString(machineName.hashCode());
                machineName = "machine-" + machineNameHash;
            }
        }
        catch (IOException ex) {
            NormalException.logStackTrace((Throwable)ex);
        }
        AnalyticsEvent event = new AnalyticsEvent("run_machine", new AnalyticsEvent.Property[]{AnalyticsEvent.Property.of((String)"machine_name", (Object)machineName), AnalyticsEvent.Property.of((String)TRIGGER_KEY, (Object)trigger.label)});
        AnalyticsClient.getDefault().send(event);
    }

    public static void send(String machineName, String rootComponent) {
        Trigger triggerForComponent = RunMachineEvent.getTriggerForComponent(rootComponent);
        RunMachineEvent.send(machineName, triggerForComponent);
    }

    private static Trigger getTriggerForComponent(String rootComponent) {
        Trigger trigger = null;
        if ("context-menu".equals(rootComponent)) {
            trigger = Trigger.TRANSFORM_CONTEXT_MENU;
        } else if ("run-view".equals(rootComponent)) {
            trigger = Trigger.RUN_VIEW;
        }
        return trigger;
    }

    public static enum Trigger {
        TRANSFORM_CONTEXT_MENU("transform_context_menu"),
        RUN_VIEW("run_view"),
        TITLE_BAR("title_bar"),
        MACHINES_TAB("machines_tab"),
        COMMAND_LINE("command_line");

        String label;

        private Trigger(String label) {
            this.label = label;
        }
    }
}

