/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.automation.imex.MachineAttributesWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class MachineAttributesEntry
extends Entry<MachineAttributesWrapper> {
    private static final String ATTR_ENABLED = "enabled";
    private static final String ATTR_FAVORITE = "favorite";
    public static final String DefaultFolder = "Machines";
    public static final String Type = "properties";

    public MachineAttributesEntry(MachineAttributesWrapper wrapper) {
        super((Object)wrapper, DefaultFolder, wrapper.getFileName() + "." + Type, wrapper.getFileName() + "'s attributes");
    }

    public MachineAttributesEntry(String path) {
        super(path);
    }

    protected MachineAttributesWrapper read(InputStream is) throws IOException {
        Properties properties = new Properties();
        properties.load(is);
        boolean enabled = Boolean.parseBoolean((String)properties.get(ATTR_ENABLED));
        Object favoriteProp = properties.get(ATTR_FAVORITE);
        boolean favorite = false;
        if (favoriteProp instanceof String) {
            favorite = Boolean.parseBoolean((String)favoriteProp);
        }
        return new MachineAttributesWrapper(this.getTypeName(), enabled, favorite);
    }

    protected void write(MachineAttributesWrapper wrapper, OutputStream os) throws IOException {
        Properties properties = new Properties();
        properties.put(ATTR_ENABLED, Boolean.toString(wrapper.isEnabled()));
        properties.put(ATTR_FAVORITE, Boolean.toString(wrapper.isFavorite()));
        properties.store(os, null);
    }
}

