/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.imex;

import com.paterva.maltego.automation.CompilationException;
import com.paterva.maltego.automation.MachineCompilation;
import com.paterva.maltego.automation.MachineCompiler;
import com.paterva.maltego.automation.MachineCompilerOptions;
import com.paterva.maltego.automation.MachineDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class MachineSerializer {
    private static final Logger LOG = Logger.getLogger(MachineSerializer.class.getName());
    private static final Pattern HEADER_PATTERN = Pattern.compile("machine\\s*\\(\\s*\"([^\"]*)\"\\s*,\\s*displayName\\s*:\\s*\"([^\"]*)\",\\s*author\\s*:\\s*\"([^\"]*)\",\\s*description\\s*:\\s*\"([^\"]*)\"", 8);
    private static int unknownNum = 0;

    public static void write(MachineDescriptor machine, OutputStream os) throws IOException {
        IOUtils.write((String)((String)machine.getData()), (OutputStream)os, (String)"UTF-8");
    }

    public static MachineDescriptor read(InputStream is) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
        String text = writer.toString();
        return MachineSerializer.read(text, false, true, false);
    }

    public static MachineDescriptor read(String text, Boolean isFavorite, Boolean enabled, Boolean readOnly) {
        MachineDescriptor machine = new MachineDescriptor();
        machine.setData(text);
        try {
            MachineCompilation compilation = MachineCompiler.getDefault().compile(text, MachineCompilerOptions.DEFAULT);
            machine.setEnabled(enabled);
            machine.setName(compilation.getName());
            machine.setAuthor(compilation.getAuthor());
            machine.setDescription(compilation.getDescription());
            machine.setDisplayName(compilation.getDisplayName());
            machine.setFavorite(isFavorite);
            machine.setReadOnly(readOnly);
        }
        catch (CompilationException ex) {
            machine.setEnabled(false);
            Matcher matcher = HEADER_PATTERN.matcher(text);
            if (matcher.find()) {
                String name = matcher.group(1);
                String displayName = matcher.group(2);
                String author = matcher.group(3);
                String description = matcher.group(4);
                machine.setName(name);
                machine.setDisplayName(displayName);
                machine.setAuthor(author);
                machine.setDescription(description);
            } else {
                String name = "uncompilable_" + ++unknownNum;
                machine.setName(name);
                machine.setDisplayName(name);
                machine.setAuthor("");
                machine.setDescription(ex.getMessage());
            }
            LOG.warning(() -> "Failed to compile machine '" + machine.getName() + "': " + ex);
        }
        return machine;
    }
}

