/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora.structure;

import com.paterva.graph.store.pandora.parts.PandoraPartsWriter;
import com.paterva.graph.store.pandora.structure.PandoraGraphStructureReader;
import com.paterva.graph.store.pandora.structure.StructureArtifactUtils;
import com.paterva.graph.store.pandora.structure.StructureCache;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.cache.FifoCache;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureWriter;
import com.pinkmatter.pandora.Artifact;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PandoraGraphStructureWriter
extends PandoraPartsWriter
implements GraphStructureWriter {
    private static final Logger LOG = Logger.getLogger(PandoraGraphStructureWriter.class.getName());
    private final boolean IS_CHECK_MODS = true;
    private final PandoraGraphStructureReader _reader;
    private final StructureCache _cache;
    private GraphStructureMods _eventMods;

    PandoraGraphStructureWriter(GraphID id, PandoraGraphStructureReader reader, PropertyChangeSupport changeSupport, StructureCache cache) {
        super(id, changeSupport);
        this._reader = reader;
        this._cache = cache;
    }

    public void endUpdate(Boolean layout) {
        if (layout != null && this._eventMods != null) {
            this._eventMods.setLayoutNew(layout.booleanValue());
        }
        super.endUpdate((Object)layout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Collection<EntityID> entityIDs) throws GraphStoreException {
        try {
            this.beginUpdate();
            for (EntityID entityID : entityIDs) {
                this.add(entityID);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void add(EntityID entityID) throws GraphStoreException {
        try {
            Integer count;
            this.beginUpdate();
            LOG.log(Level.FINE, "Add entity {0}", entityID);
            this.getEntityStore().add(entityID.getValue(), Collections.EMPTY_MAP);
            GraphStructureMods event = this.getEventMods();
            if (!event.getEntitiesRemoved().remove(entityID)) {
                event.getEntitiesAdded().add(entityID);
            }
            if ((count = this._cache.getEntityCount()) != null) {
                this._cache.setEntityCount(count + 1);
            }
            this._cache.getIncomingLinks().put((Object)entityID, new HashSet());
            this._cache.getOutgoingLinks().put((Object)entityID, new HashSet());
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not add entity " + entityID, (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map<LinkID, LinkEntityIDs> linkIDs) throws GraphStoreException {
        try {
            this.beginUpdate();
            for (Map.Entry<LinkID, LinkEntityIDs> entry : linkIDs.entrySet()) {
                LinkID linkID = entry.getKey();
                LinkEntityIDs entityIDs = entry.getValue();
                this.connect(linkID, entityIDs.getSourceID(), entityIDs.getTargetID());
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void connect(LinkID linkID, LinkEntityIDs entityIDs) throws GraphStoreException {
        try {
            Set outgoing;
            this.beginUpdate();
            EntityID sourceID = entityIDs.getSourceID();
            EntityID targetID = entityIDs.getTargetID();
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("source", sourceID.getValue());
            map.put("target", targetID.getValue());
            LOG.log(Level.FINE, "Add link {0} ({1}->{2})", new Object[]{linkID, sourceID, targetID});
            this.getLinkStore().add(linkID.getValue(), map);
            GraphStructureMods event = this.getEventMods();
            if (event.getLinksRemoved().remove(linkID) == null) {
                event.getLinksAdded().add(linkID);
            }
            this._cache.getLinkEntities().put((Object)linkID, (Object)entityIDs);
            Set incoming = (Set)this._cache.getIncomingLinks().get((Object)targetID);
            if (incoming != null) {
                incoming.add(linkID);
            }
            if ((outgoing = (Set)this._cache.getOutgoingLinks().get((Object)sourceID)) != null) {
                outgoing.add(linkID);
            }
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not add link " + linkID, (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    public void connect(LinkID linkID, EntityID sourceID, EntityID targetID) throws GraphStoreException {
        this.connect(linkID, new LinkEntityIDs(sourceID, targetID));
    }

    private void addLinkToSource(EntityID sourceID, LinkID linkID) throws GraphStoreException {
        try {
            Artifact artifact = this.getEntityStore().getArtifact(sourceID.getValue());
            Set<Long> outLinks = StructureArtifactUtils.getOutgoingLong(artifact);
            if (outLinks.contains(linkID.getValue())) {
                throw new GraphStoreException("Unable to add link " + linkID + ", source entity already associated: " + sourceID);
            }
            outLinks.add(linkID.getValue());
            artifact.put("out", (Object)outLinks.toArray());
            this.getEntityStore().remove(sourceID.getValue());
            this.getEntityStore().add(sourceID.getValue(), (Map)artifact);
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not add link " + linkID + " to source entity " + sourceID, (Throwable)ex);
        }
    }

    private void addLinkToTarget(EntityID targetID, LinkID linkID) throws GraphStoreException {
        try {
            Artifact artifact = this.getEntityStore().getArtifact(targetID.getValue());
            Set<Long> inLinks = StructureArtifactUtils.getIncomingLong(artifact);
            if (inLinks.contains(linkID.getValue())) {
                throw new GraphStoreException("Unable to add link " + linkID + ", target entity already associated: " + targetID);
            }
            inLinks.add(linkID.getValue());
            artifact.put("in", (Object)inLinks.toArray());
            this.getEntityStore().remove(targetID.getValue());
            this.getEntityStore().add(targetID.getValue(), (Map)artifact);
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not add link " + linkID + " to target entity " + targetID, (Throwable)ex);
        }
    }

    public Set<LinkID> removeEntities(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashSet<LinkID> removedLinks = new HashSet<LinkID>();
        try {
            this.beginUpdate();
            Set<LinkID> links = this._reader.getLinks(entityIDs);
            if (links != null && !links.isEmpty()) {
                removedLinks.addAll(links);
                this.removeLinks(links, true);
            }
            this.getPinCache().remove(entityIDs);
            for (EntityID entityID : entityIDs) {
                Integer count;
                LOG.log(Level.FINE, "Remove entity {0}", entityID);
                this.getEntityStore().remove(entityID.getValue());
                GraphStructureMods event = this.getEventMods();
                if (!event.getEntitiesAdded().remove(entityID)) {
                    event.getEntitiesRemoved().add(entityID);
                }
                if ((count = this._cache.getEntityCount()) == null) continue;
                int newCount = (int)this._reader.getEntitySearch().query().count();
                this._cache.setEntityCount(newCount);
            }
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not remove entities " + entityIDs, (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
        return removedLinks;
    }

    public void removeLinks(Collection<LinkID> linkIDs) throws GraphStoreException {
        try {
            this.beginUpdate();
            this.removeLinks(linkIDs, true);
        }
        finally {
            this.endUpdate();
        }
    }

    private void removeLinks(Collection<LinkID> linkIDs, boolean removeFromEntities) throws GraphStoreException {
        Map<LinkID, LinkEntityIDs> links = this._reader.getEntities(linkIDs);
        this.removeLinks(links, removeFromEntities);
    }

    private void removeLinks(Map<LinkID, LinkEntityIDs> links, boolean removeFromEntities) throws GraphStoreException {
        for (Map.Entry<LinkID, LinkEntityIDs> entry : links.entrySet()) {
            LinkID linkID = entry.getKey();
            LinkEntityIDs entityIDs = entry.getValue();
            this.removeLink(linkID, entityIDs, removeFromEntities);
        }
    }

    private void removeLink(LinkID linkID, LinkEntityIDs entityIDs, boolean removeFromEntities) throws GraphStoreException {
        try {
            Set outgoing;
            GraphStructureMods event;
            this.getLinkStore().remove(linkID.getValue());
            EntityID sourceID = entityIDs.getSourceID();
            EntityID targetID = entityIDs.getTargetID();
            LOG.log(Level.FINE, "Remove link {0} ({1}->{2})", new Object[]{linkID, sourceID, targetID});
            if (removeFromEntities) {
                // empty if block
            }
            if (!(event = this.getEventMods()).getLinksAdded().remove(linkID)) {
                event.getLinksRemoved().put(linkID, new LinkEntityIDs(sourceID, targetID));
            }
            this._cache.getLinkEntities().remove((Object)linkID);
            Set incoming = (Set)this._cache.getIncomingLinks().get((Object)targetID);
            if (incoming != null) {
                incoming.remove(linkID);
            }
            if ((outgoing = (Set)this._cache.getOutgoingLinks().get((Object)sourceID)) != null) {
                outgoing.remove(linkID);
            }
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not remove link " + linkID, (Throwable)ex);
        }
    }

    private void removeFromSource(EntityID sourceID, LinkID linkID) throws GraphStoreException {
        try {
            Artifact artifact = this.getEntityStore().getArtifact(sourceID.getValue());
            Set<Long> outLinks = StructureArtifactUtils.getOutgoingLong(artifact);
            if (outLinks == null || !outLinks.contains(linkID.getValue())) {
                throw new GraphStoreException("Source entity " + sourceID + " does not have outgoing link " + linkID);
            }
            outLinks.remove(linkID.getValue());
            if (outLinks.isEmpty()) {
                artifact.remove((Object)"out");
            } else {
                artifact.put("out", (Object)outLinks.toArray());
            }
            this.getEntityStore().remove(sourceID.getValue());
            this.getEntityStore().add(sourceID.getValue(), (Map)artifact);
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not remove link " + linkID + " from source entity " + sourceID, (Throwable)ex);
        }
    }

    private void removeFromTarget(EntityID targetID, LinkID linkID) throws GraphStoreException {
        try {
            Artifact artifact = this.getEntityStore().getArtifact(targetID.getValue());
            Set<Long> inLinks = StructureArtifactUtils.getIncomingLong(artifact);
            if (inLinks == null || !inLinks.contains(linkID.getValue())) {
                throw new GraphStoreException("Target entity " + targetID + " does not have incoming link " + linkID);
            }
            inLinks.remove(linkID.getValue());
            if (inLinks.isEmpty()) {
                artifact.remove((Object)"in");
            } else {
                artifact.put("in", (Object)inLinks.toArray());
            }
            this.getEntityStore().remove(targetID.getValue());
            this.getEntityStore().add(targetID.getValue(), (Map)artifact);
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not remove link " + linkID + " from target entity " + targetID, (Throwable)ex);
        }
    }

    public void remove(Collection<EntityID> entityIDs, Collection<LinkID> linkIDs) throws GraphStoreException {
        try {
            this.beginUpdate();
            this.removeLinks(linkIDs);
            this.removeEntities(entityIDs);
        }
        finally {
            this.endUpdate();
        }
    }

    public void clear() throws GraphStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setPinned(Map<EntityID, Boolean> pinnedEntities) throws GraphStoreException {
        try {
            this.beginUpdate();
            for (Map.Entry<EntityID, Boolean> entry : pinnedEntities.entrySet()) {
                EntityID entityID = entry.getKey();
                Boolean pinned = entry.getValue();
                this.setPinnedInner(entityID, pinned);
            }
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    public void setPinned(Collection<EntityID> entityIDs, boolean pinned) throws GraphStoreException {
        try {
            this.beginUpdate();
            for (EntityID entityID : entityIDs) {
                this.setPinnedInner(entityID, pinned);
            }
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    private void setPinnedInner(EntityID entityID, Boolean pinned) throws GraphStoreException {
        try {
            if (pinned != null && !pinned.equals(this.getPinCache().get((Object)entityID))) {
                Map<String, Boolean> pinnedMap = Collections.singletonMap("pinned", pinned);
                LOG.log(Level.FINE, "Set pinned {0} {1}", new Object[]{entityID, pinned});
                this.getEntityStore().remove(entityID.getValue());
                this.getEntityStore().add(entityID.getValue(), pinnedMap);
                this.getPinCache().put((Object)entityID, (Object)pinned);
                GraphStructureMods mods = this.getEventMods();
                Set entitiesPinned = mods.getEntitiesPinned();
                Set entitiesUnpinned = mods.getEntitiesUnpinned();
                if (pinned.booleanValue()) {
                    entitiesUnpinned.remove(entityID);
                    entitiesPinned.add(entityID);
                } else {
                    entitiesPinned.remove(entityID);
                    entitiesUnpinned.add(entityID);
                }
            }
        }
        catch (Exception ex) {
            throw new GraphStoreException("Entity " + entityID, (Throwable)ex);
        }
    }

    public void initForCloud() {
        Integer count = this._cache.getEntityCount();
        if (count == null) {
            this._cache.setEntityCount(0);
        }
    }

    protected void fireEvent() {
        if (this._eventMods != null && !this._eventMods.isEmpty()) {
            GraphStructureMods eventMods = this._eventMods;
            this._eventMods = null;
            if (!eventMods.isEmpty()) {
                LOG.log(Level.FINE, "Fire events: {0}", eventMods);
                eventMods.makeReadOnly();
                this.getChangeSupport().firePropertyChange("structureModified", null, eventMods);
            }
        }
    }

    private GraphStructureMods getEventMods() {
        if (this._eventMods == null) {
            this._eventMods = new GraphStructureMods();
        }
        return this._eventMods;
    }

    private FifoCache<EntityID, Boolean> getPinCache() {
        return this._cache.getPinCache();
    }
}

