/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.lazy.outline;

import com.paterva.maltego.treelist.lazy.outline.LazyOutline;
import com.paterva.maltego.util.HtmlUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.LabelUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.CheckRenderDataProvider;
import org.netbeans.swing.outline.RenderDataProvider;

public class DefaultOutlineCellRenderer
extends DefaultTableCellRenderer {
    private static int expansionHandleWidth = 0;
    private static int expansionHandleHeight = 0;
    private boolean expanded = false;
    private boolean leaf = true;
    private boolean showHandle = true;
    private int nestingDepth = 0;
    private final JCheckBox theCheckBox;
    private final CellRendererPane fakeCellRendererPane;
    private JCheckBox checkBox;
    private Reference<RenderDataProvider> lastRendererRef = new WeakReference<Object>(null);
    private Reference<Object> lastRenderedValueRef = new WeakReference<Object>(null);
    private final Border expansionBorder = new ExpansionHandleBorder();
    private static final Class htmlRendererClass = DefaultOutlineCellRenderer.useSwingHtmlRendering() ? null : HtmlRenderer.getDelegate();
    private final HtmlRenderer.Renderer htmlRenderer = htmlRendererClass != null ? HtmlRenderer.access$100(htmlRendererClass) : null;
    private final boolean swingRendering = this.htmlRenderer == null;
    private final boolean _small;
    private final Color _flashColor = UIManager.getLookAndFeelDefaults().getColor("graph-collection-flashing-background-color");
    private int _flashingRow = -1;
    private boolean _isFlashTimerRunning = false;
    private boolean _showFlashColour = false;
    private final Color _hoverColor = UIManager.getLookAndFeelDefaults().getColor("graph-collection-hover-background-color");
    private int _hoveredRow = -1;

    private static boolean useSwingHtmlRendering() {
        try {
            return Boolean.getBoolean("nb.useSwingHtmlRendering");
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public DefaultOutlineCellRenderer() {
        this(false);
    }

    public DefaultOutlineCellRenderer(boolean small) {
        this._small = small;
        this.theCheckBox = new JCheckBox();
        this.theCheckBox.setSize(this.theCheckBox.getPreferredSize());
        this.theCheckBox.setBorderPainted(false);
        this.theCheckBox.setOpaque(false);
        this.fakeCellRendererPane = new CellRendererPane();
        this.fakeCellRendererPane.add(this.theCheckBox);
    }

    @Override
    public final void setBorder(Border b) {
        if (!this.swingRendering) {
            super.setBorder(b);
            return;
        }
        if (b == this.expansionBorder) {
            super.setBorder(b);
        } else {
            super.setBorder(BorderFactory.createCompoundBorder(b, this.expansionBorder));
        }
    }

    @Override
    protected void setValue(Object value) {
        if (this.swingRendering) {
            super.setValue(value);
        }
    }

    private static Icon getDefaultOpenIcon() {
        return null;
    }

    private static Icon getDefaultClosedIcon() {
        return null;
    }

    private static Icon getDefaultLeafIcon() {
        return null;
    }

    Icon getExpandedIcon() {
        String prop = this._small ? "Tree.expandedSmallIcon" : "Tree.expandedIcon";
        return UIManager.getIcon(prop);
    }

    Icon getCollapsedIcon() {
        String prop = this._small ? "Tree.collapsedSmallIcon" : "Tree.collapsedIcon";
        return UIManager.getIcon(prop);
    }

    int getNestingWidth() {
        return this._small ? 0 : 0;
    }

    int getExpansionHandleWidth() {
        return this._small ? 0 : 3;
    }

    int getExpansionHandleHeight() {
        return this.getExpansionHandleWidth();
    }

    private void setNestingDepth(int i) {
        this.nestingDepth = i;
    }

    private void setExpanded(boolean val) {
        this.expanded = val;
    }

    private void setLeaf(boolean val) {
        this.leaf = val;
    }

    private void setShowHandle(boolean val) {
        this.showHandle = val;
    }

    private void setCheckBox(JCheckBox checkBox) {
        this.checkBox = checkBox;
    }

    private boolean isLeaf() {
        return this.leaf;
    }

    private boolean isExpanded() {
        return this.expanded;
    }

    private boolean isShowHandle() {
        return this.showHandle;
    }

    private int getNestingDepth() {
        return this.nestingDepth;
    }

    private JCheckBox getCheckBox() {
        return this.checkBox;
    }

    int getTheCheckBoxWidth() {
        return this.theCheckBox.getSize().width;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setForeground(null);
        this.setBackground(null);
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        JLabel label = null;
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        if (!this.swingRendering) {
            this.htmlRenderer.setColors(this.getForeground(), this.getBackground());
            label = (JLabel)this.htmlRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            LabelUI labelUI = label.getUI();
            if (labelUI != null && labelUI.getClass().getName().contains("org.openide.awt.HtmlLabelUI")) {
                if (this._small) {
                    label.putClientProperty("htmlLabelDrawSelectionBorder", Boolean.FALSE);
                } else {
                    label.putClientProperty("htmlLabelSelectionBorderColor", laf.getColor("detail-view-list-selection-label-border-color"));
                    label.putClientProperty("htmlLabelIgnoreEnsureContrastingColor", Boolean.TRUE);
                    label.putClientProperty("htmlLabelCustomSelectionForegroundColor", Boolean.TRUE);
                }
            }
        }
        LazyOutline tbl = (LazyOutline)table;
        int viewRow = row;
        if (tbl.isTreeColumnIndex(column)) {
            int nd;
            AbstractLayoutCache layout = tbl.getLayoutCache();
            row = tbl.convertRowIndexToModel(row);
            boolean isleaf = tbl.getOutlineModel().isLeaf(value);
            this.setLeaf(isleaf);
            this.setShowHandle(true);
            TreePath path = layout.getPathForRow(row);
            boolean isExpanded = layout.isExpanded(path);
            this.setExpanded(isExpanded);
            int n = path == null ? 0 : (nd = path.getPathCount() - (tbl.isRootVisible() ? 1 : 2));
            if (nd < 0) {
                nd = 0;
            }
            this.setNestingDepth(nd);
            RenderDataProvider rendata = tbl.getRenderDataProvider();
            Icon icon = null;
            if (rendata != null && value != null) {
                CheckRenderDataProvider crendata;
                Color displayNameFg = null;
                String displayName = rendata.getDisplayName(value);
                if (displayName != null) {
                    if (rendata.isHtmlDisplayName(value) && !displayName.startsWith("<html") && !displayName.startsWith("<HTML")) {
                        if (this.swingRendering) {
                            this.setText("<html>" + displayName.replaceAll(" ", "&nbsp;") + "</html>");
                        } else {
                            label.setText("<html>" + displayName.replaceAll(" ", "&nbsp;") + "</html>");
                        }
                    } else if (this.swingRendering) {
                        this.setText(displayName);
                    } else {
                        label.setText(displayName);
                    }
                    displayNameFg = HtmlUtils.getColor((String)displayName);
                }
                this.lastRendererRef = new WeakReference<RenderDataProvider>(rendata);
                this.lastRenderedValueRef = new WeakReference<Object>(value);
                Color bg = rendata.getBackground(value);
                Color fg = rendata.getForeground(value);
                if (bg != null && !isSelected) {
                    if (this.swingRendering) {
                        this.setBackground(bg);
                    } else {
                        label.setBackground(bg);
                    }
                } else if (!this.swingRendering) {
                    label.setBackground(this.getBackground());
                }
                icon = rendata.getIcon(value);
                if (fg != null && !isSelected) {
                    if (this.swingRendering) {
                        this.setForeground(fg);
                    } else {
                        label.setForeground(fg);
                    }
                } else if (!this.swingRendering) {
                    if (this._small) {
                        label.setForeground(this.getForeground());
                    } else if (displayNameFg != null) {
                        label.setForeground(displayNameFg);
                    } else if (icon == null) {
                        label.setForeground(laf.getColor("detail-view-list-htmllabel-fg"));
                    } else {
                        label.setForeground(laf.getColor("detail-view-list-htmllabel-main-fg"));
                    }
                }
                JCheckBox cb = null;
                if (rendata instanceof CheckRenderDataProvider && (crendata = (CheckRenderDataProvider)rendata).isCheckable(value)) {
                    cb = this.theCheckBox;
                    Boolean chSelected = crendata.isSelected(value);
                    cb.setEnabled(true);
                    cb.setSelected(!Boolean.FALSE.equals(chSelected));
                    cb.getModel().setArmed(chSelected == null);
                    cb.getModel().setPressed(chSelected == null);
                    cb.setEnabled(crendata.isCheckEnabled(value));
                    cb.setBackground(this.getBackground());
                }
                this.setCheckBox(cb);
            } else {
                this.setCheckBox(null);
                if (this._small) {
                    if (this._hoveredRow != -1 && viewRow == this._hoveredRow) {
                        label.setBackground(this._hoverColor);
                    } else if (this._flashingRow != -1 && viewRow == this._flashingRow && this._isFlashTimerRunning && this._showFlashColour) {
                        label.setBackground(this._flashColor);
                    } else {
                        label.setBackground(this.getBackground());
                    }
                }
            }
            if (icon == null) {
                icon = !isleaf ? (isExpanded ? DefaultOutlineCellRenderer.getDefaultOpenIcon() : DefaultOutlineCellRenderer.getDefaultClosedIcon()) : DefaultOutlineCellRenderer.getDefaultLeafIcon();
            }
            if (this.swingRendering) {
                this.setIcon(icon);
            } else {
                label.setIcon(icon);
            }
        } else {
            this.setCheckBox(null);
            if (this.swingRendering) {
                this.setIcon(null);
            } else {
                label.setIcon(null);
            }
            this.setShowHandle(false);
            this.lastRendererRef = new WeakReference<Object>(null);
            this.lastRenderedValueRef = new WeakReference<Object>(null);
        }
        if (this.swingRendering) {
            return this;
        }
        Border b = this.getBorder();
        if (b == null) {
            label.setBorder(this.expansionBorder);
        } else {
            label.setBorder(BorderFactory.createCompoundBorder(b, this.expansionBorder));
        }
        label.setOpaque(true);
        label.putClientProperty(DefaultOutlineCellRenderer.class, this);
        return label;
    }

    @Override
    public String getToolTipText() {
        String toolT;
        RenderDataProvider rendata = this.lastRendererRef.get();
        Object value = this.lastRenderedValueRef.get();
        if (rendata != null && value != null && (toolT = rendata.getTooltipText(value)) != null && (toolT = toolT.trim()).length() > 0) {
            return toolT;
        }
        return super.getToolTipText();
    }

    public void setHoveredRow(int row) {
        this._hoveredRow = row;
    }

    public void setFlashingRow(int row) {
        this._flashingRow = row;
    }

    public void setFlashTimerRunning(boolean state) {
        this._isFlashTimerRunning = state;
    }

    public void setShowFlashColour(boolean showFlashColour) {
        this._showFlashColour = showFlashColour;
    }

    private static final class HtmlRenderer {
        private static final String HTML_RENDERER_CLASS = "org.openide.awt.HtmlRenderer";

        private HtmlRenderer() {
        }

        static Class getDelegate() {
            Class<?> delegate;
            try {
                delegate = ClassLoader.getSystemClassLoader().loadClass(HTML_RENDERER_CLASS);
            }
            catch (ClassNotFoundException ex) {
                try {
                    delegate = Thread.currentThread().getContextClassLoader().loadClass(HTML_RENDERER_CLASS);
                }
                catch (ClassNotFoundException ex2) {
                    try {
                        Class<?> lookupClass = ClassLoader.getSystemClassLoader().loadClass("org.openide.util.Lookup");
                        try {
                            Object defaultLookup = lookupClass.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
                            ClassLoader systemClassLoader = (ClassLoader)lookupClass.getMethod("lookup", Class.class).invoke(defaultLookup, ClassLoader.class);
                            if (systemClassLoader == null) {
                                return null;
                            }
                            delegate = systemClassLoader.loadClass(HTML_RENDERER_CLASS);
                        }
                        catch (NoSuchMethodException mex) {
                            Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, ex);
                            return null;
                        }
                        catch (SecurityException mex) {
                            Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, ex);
                            return null;
                        }
                        catch (IllegalAccessException mex) {
                            Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, ex);
                            return null;
                        }
                        catch (IllegalArgumentException mex) {
                            Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, ex);
                            return null;
                        }
                        catch (InvocationTargetException mex) {
                            Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, ex);
                            return null;
                        }
                    }
                    catch (ClassNotFoundException ex3) {
                        return null;
                    }
                    catch (SecurityException se) {
                        return null;
                    }
                }
                catch (SecurityException se) {
                    return null;
                }
            }
            catch (SecurityException se) {
                return null;
            }
            return delegate;
        }

        private static Renderer createRenderer(Class htmlRendererClass) {
            try {
                Method createRenderer = htmlRendererClass.getMethod("createRenderer", new Class[0]);
                return new Renderer(createRenderer.invoke(null, new Object[0]));
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            catch (SecurityException ex) {
                Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        static /* synthetic */ Renderer access$100(Class x0) {
            return HtmlRenderer.createRenderer(x0);
        }

        private static class Renderer {
            private Object renderer;
            private Method getTableCellRendererComponent;

            private Renderer(Object renderer) throws NoSuchMethodException {
                this.renderer = renderer;
                this.getTableCellRendererComponent = TableCellRenderer.class.getMethod("getTableCellRendererComponent", JTable.class, Object.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE);
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean leadSelection, int row, int column) {
                try {
                    return (Component)this.getTableCellRendererComponent.invoke(this.renderer, table, value, selected, leadSelection, row, column);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IllegalStateException(ex);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IllegalStateException(ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IllegalStateException(ex);
                }
            }

            private void setColors(Color foreground, Color background) {
                Component c = (Component)this.renderer;
                c.setForeground(foreground);
                c.setBackground(background);
            }
        }
    }

    private class ExpansionHandleBorder
    implements Border {
        private final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID());
        private Insets insets = new Insets(0, 0, 0, 0);
        private JLabel lExpandedIcon = new JLabel(DefaultOutlineCellRenderer.this.getExpandedIcon(), 11);
        private JLabel lCollapsedIcon = new JLabel(DefaultOutlineCellRenderer.this.getCollapsedIcon(), 11);

        private ExpansionHandleBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            DefaultOutlineCellRenderer ren = (DefaultOutlineCellRenderer)((JComponent)c).getClientProperty(DefaultOutlineCellRenderer.class);
            if (ren == null) {
                ren = (DefaultOutlineCellRenderer)c;
            }
            if (ren.isShowHandle()) {
                this.insets.left = DefaultOutlineCellRenderer.this.getExpansionHandleWidth() + ren.getNestingDepth() * DefaultOutlineCellRenderer.this.getNestingWidth();
                this.insets.top = 1;
                this.insets.right = 1;
                this.insets.bottom = 1;
            } else {
                this.insets.left = 1;
                this.insets.top = 1;
                this.insets.right = 1;
                this.insets.bottom = 1;
            }
            if (ren.getCheckBox() != null) {
                this.insets.left += ((DefaultOutlineCellRenderer)ren).getCheckBox().getSize().width;
            }
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JCheckBox chBox;
            DefaultOutlineCellRenderer ren = (DefaultOutlineCellRenderer)((JComponent)c).getClientProperty(DefaultOutlineCellRenderer.class);
            if (ren == null) {
                ren = (DefaultOutlineCellRenderer)c;
            }
            if (ren.isShowHandle() && !ren.isLeaf()) {
                Icon icon = ren.isExpanded() ? DefaultOutlineCellRenderer.this.getExpandedIcon() : DefaultOutlineCellRenderer.this.getCollapsedIcon();
                int iconX = ren.getNestingDepth() * DefaultOutlineCellRenderer.this.getNestingWidth() + 2;
                int iconY = icon.getIconHeight() < height ? height / 2 - icon.getIconHeight() / 2 : 0;
                iconY += 2;
                if (this.isGtk) {
                    JLabel lbl = ren.isExpanded() ? this.lExpandedIcon : this.lCollapsedIcon;
                    lbl.setSize(Math.max(DefaultOutlineCellRenderer.this.getExpansionHandleWidth(), iconX + DefaultOutlineCellRenderer.this.getExpansionHandleWidth()), height);
                    lbl.paint(g);
                } else {
                    icon.paintIcon(c, g, iconX, iconY);
                }
            }
            if ((chBox = ren.getCheckBox()) != null) {
                int chBoxX = DefaultOutlineCellRenderer.this.getExpansionHandleWidth() + ren.getNestingDepth() * DefaultOutlineCellRenderer.this.getNestingWidth();
                Dimension chDim = chBox.getSize();
                Graphics gch = g.create(chBoxX, 0, chDim.width, chDim.height);
                chBox.paint(gch);
                gch.dispose();
            }
        }
    }
}

