/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.ui.DarculaComboPopup;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.ReflectionUtil;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.Position;
import sun.swing.DefaultLookup;

public class DarculaComboBoxUI
extends BasicComboBoxUI
implements Border {
    private static final String FORWARD_ENTER_KEY_EVENT = "JComboBox.darculaForwardEnterKeyEvent";
    private static final String MY_IS_TABLE_CELL_EDITOR = "JComboBox.isTableCellEditor";
    private static final StringBuffer MY_HIDE_POPUP_KEY = new StringBuffer("HidePopupKey");
    private final int shiftArrowButtonLeft = 3;
    private final JComboBox myComboBox;
    private boolean myIsDisplaySizeDirty = true;
    private final Dimension myCachedDisplaySize = new Dimension(0, 0);
    private Insets myPadding;
    private long myLastTime = 0L;
    private long myTime = 0L;
    private long myTimeFactor = 1000L;
    private MyHandler myHandler;
    private MouseWheelListener myMouseWheelListener;
    private JComboBox.KeySelectionManager myKeySelectionManager;
    private boolean myIsTableCellEditor = false;

    public DarculaComboBoxUI(JComboBox comboBox) {
        this.myComboBox = comboBox;
        this.myComboBox.setBorder(this);
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarculaComboBoxUI((JComboBox)c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.myPadding = UIManager.getLookAndFeelDefaults().getInsets("ComboBox.padding");
        Long l = (Long)UIManager.get("ComboBox.timeFactor");
        this.myTimeFactor = l == null ? 1000L : l;
    }

    @Override
    protected JButton createArrowButton() {
        Color bg = this.myComboBox.getBackground();
        Color fg = this.myComboBox.getForeground();
        BasicArrowButton button = new BasicArrowButton(5, bg, fg, fg, fg){

            @Override
            public void paint(Graphics g2) {
                Graphics2D g = (Graphics2D)g2;
                GraphicsConfig config = new GraphicsConfig(g);
                int w = this.getWidth();
                int h = this.getHeight();
                if (!DarculaComboBoxUI.isTableCellEditorComponent(DarculaComboBoxUI.this.myComboBox)) {
                    g.setColor(DarculaComboBoxUI.this.getArrowButtonFillColor(UIUtil.getControlColor()));
                    g.fillRect(0, 0, w, h);
                }
                Color arrowForeground = DarculaComboBoxUI.this.comboBox.isEnabled() ? (this.getModel().isRollover() ? UIManager.getLookAndFeelDefaults().getColor("7-focus-color") : UIManager.getLookAndFeelDefaults().getColor("ComboBox.darculaMod.arrowButtonForeground")) : UIManager.getLookAndFeelDefaults().getColor("ComboBox.darculaMod.arrowButtonDisabledForeground");
                g.setColor(arrowForeground);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                int height = 6 < h ? 6 : h;
                int width = 10 < w ? 10 : w;
                int offsetY = (h - height) / 2;
                int offsetX = (w - width) / 2;
                g.setStroke(new BasicStroke(2.0f));
                g.translate(offsetX, offsetY);
                g.drawLine(0, 0, 5, height);
                g.drawLine(5, height, width, 0);
                g.translate(-offsetX, -offsetY);
                if (!DarculaComboBoxUI.isTableCellEditorComponent(DarculaComboBoxUI.this.myComboBox)) {
                    g.setColor(DarculaComboBoxUI.this.getArrowButtonFillColor(DarculaComboBoxUI.getArrowButtonFillColorForTableCellEditor()));
                    g.drawLine(0, -1, 0, h);
                }
                config.restore();
            }

            @Override
            public Dimension getPreferredSize() {
                Insets d = DarculaComboBoxUI.this.comboBox.getInsets();
                int size = this.getFont().getSize() + d.top + d.bottom;
                if (size % 2 == 1) {
                    ++size;
                }
                return new DimensionUIResource(size + 3, size);
            }
        };
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(false);
        return button;
    }

    protected Color getArrowButtonFillColor(Color defaultColor) {
        Color color;
        Color color2 = color = this.myComboBox.hasFocus() ? UIManager.getLookAndFeelDefaults().getColor("ComboBox.darcula.arrowButtonFocusedFillColor") : UIManager.getLookAndFeelDefaults().getColor("ComboBox.darcula.arrowButtonFillColor");
        return color == null ? defaultColor : (this.comboBox != null && !this.comboBox.isEnabled() ? UIManager.getLookAndFeelDefaults().getColor("ComboBox.darculaMod.arrowButtonDisabledFillColor") : color);
    }

    private String getCallerClassName(int callStackDepth) {
        Class c = ReflectionUtil.findCallerClass(callStackDepth);
        if (c != null) {
            return c.getName();
        }
        return "";
    }

    @Override
    protected Insets getInsets() {
        if ("javax.swing.plaf.basic.BasicComboBoxUI$Handler".equals(this.getCallerClassName(3)) || "com.bulenkov.darcula.ui.DarculaComboBoxUI$MyHandler".equals(this.getCallerClassName(3))) {
            return new InsetsUIResource(1, 1, 1, 1);
        }
        return new InsetsUIResource(4, 6, 4, 6);
    }

    @Override
    protected Dimension getDisplaySize() {
        if (!this.myIsDisplaySizeDirty) {
            return new Dimension(this.myCachedDisplaySize);
        }
        Dimension display = new Dimension();
        DefaultListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
        }
        boolean sameBaseline = true;
        Object prototypeValue = this.comboBox.getPrototypeDisplayValue();
        if (prototypeValue != null) {
            display = this.getSizeForComponent(renderer.getListCellRendererComponent(this.listBox, prototypeValue, -1, false, false));
        } else {
            ComboBoxModel model = this.comboBox.getModel();
            int baseline = -1;
            if (model.getSize() > 0) {
                for (int i = 0; i < model.getSize(); ++i) {
                    Object value = model.getElementAt(i);
                    Component rendererComponent = renderer.getListCellRendererComponent(this.listBox, value, -1, false, false);
                    Dimension d = this.getSizeForComponent(rendererComponent);
                    if (!(!sameBaseline || value == null || value instanceof String && "".equals(value))) {
                        int newBaseline = rendererComponent.getBaseline(d.width, d.height);
                        if (newBaseline == -1) {
                            sameBaseline = false;
                        } else if (baseline == -1) {
                            baseline = newBaseline;
                        } else if (baseline != newBaseline) {
                            sameBaseline = false;
                        }
                    }
                    display.width = Math.max(display.width, d.width);
                    display.height = Math.max(display.height, d.height);
                }
            } else {
                display = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    display.width = 100;
                }
            }
        }
        if (this.myPadding != null) {
            display.width += this.myPadding.left + this.myPadding.right;
            display.height += this.myPadding.top + this.myPadding.bottom;
        }
        this.myCachedDisplaySize.setSize(display.width, display.height);
        this.myIsDisplaySizeDirty = false;
        return display;
    }

    @Override
    protected Dimension getSizeForComponent(Component comp) {
        this.currentValuePane.add(comp);
        comp.setFont(this.comboBox.getFont());
        Dimension d = comp.getPreferredSize();
        this.currentValuePane.remove(comp);
        return d;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Container parent = c.getParent();
        if (parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Rectangle r = this.rectangleForCurrentValue();
        if (!DarculaComboBoxUI.isTableCellEditorComponent(c)) {
            this.paintBorder(c, g, 0, 0, c.getWidth(), c.getHeight());
            this.hasFocus = this.comboBox.hasFocus();
            this.paintCurrentValueBackground(g, r, this.hasFocus);
        }
        this.paintCurrentValue(g, r, this.hasFocus);
    }

    private static boolean isTableCellEditorComponent(JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(MY_IS_TABLE_CELL_EDITOR));
    }

    @Override
    protected ComboPopup createPopup() {
        return new DarculaComboPopup(this.comboBox);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        boolean changeOpaque;
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        } else {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setBackground(UIManager.getLookAndFeelDefaults().getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c.setForeground(this.listBox.getForeground());
            c.setBackground(this.listBox.getBackground());
        } else if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledForeground", null));
            c.setBackground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledBackground", null));
        }
        boolean bl = changeOpaque = c instanceof JComponent && DarculaComboBoxUI.isTableCellEditorComponent(this.comboBox) && c.isOpaque();
        if (changeOpaque) {
            ((JComponent)c).setOpaque(false);
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        Rectangle r = new Rectangle(bounds);
        if (this.myPadding != null) {
            r.x += this.myPadding.left;
            r.y += this.myPadding.top;
            r.width -= this.myPadding.left + this.myPadding.right;
            r.height -= this.myPadding.top + this.myPadding.bottom;
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, r.x, r.y, r.width, r.height, shouldValidate);
        if (changeOpaque) {
            ((JComponent)c).setOpaque(true);
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor comboBoxEditor = super.createEditor();
        if (comboBoxEditor != null && comboBoxEditor.getEditorComponent() != null) {
            comboBoxEditor.getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    this.process(e);
                }

                private void process(KeyEvent e) {
                    int code = e.getKeyCode();
                    if ((code == 38 || code == 40) && e.getModifiers() == 0) {
                        DarculaComboBoxUI.this.comboBox.dispatchEvent(e);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    this.process(e);
                }
            });
            comboBoxEditor.getEditorComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    DarculaComboBoxUI.this.comboBox.revalidate();
                    DarculaComboBoxUI.this.comboBox.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    DarculaComboBoxUI.this.comboBox.revalidate();
                    DarculaComboBoxUI.this.comboBox.repaint();
                }
            });
        }
        return comboBoxEditor;
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        if (this.comboBox == null || this.arrowButton == null) {
            return;
        }
        this.hasFocus = false;
        this.checkFocus();
        Graphics2D g = (Graphics2D)g2;
        Rectangle arrowButtonBounds = this.arrowButton.getBounds();
        int xxx = arrowButtonBounds.x - 3;
        GraphicsConfig config = new GraphicsConfig(g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        if (this.editor != null && this.comboBox.isEditable()) {
            ((JComponent)this.editor).setBorder(null);
            g.setColor(this.editor.getBackground());
        } else {
            g.setColor(UIManager.getLookAndFeelDefaults().getColor("ComboBox.darculaMod.panelBackgroundColor"));
        }
        g.fillRect(x + 1, y + 1, width - 2, height - 2);
        g.setColor(this.getArrowButtonFillColor(this.arrowButton.getBackground()));
        g.fillRect(xxx, y + 1, width - 2, height - 2);
        Rectangle r = this.rectangleForCurrentValue();
        this.paintCurrentValueBackground(g, r, this.hasFocus);
        this.paintCurrentValue(g, r, false);
        if (this.hasFocus) {
            g.setColor(DarculaComboBoxUI.getFocusedBorderColor());
        } else {
            g.setColor(DarculaComboBoxUI.getBorderColor());
        }
        g.drawRect(0, 0, width - 1, height - 1);
        config.restore();
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        Rectangle r = super.rectangleForCurrentValue();
        r.width -= 3;
        return r;
    }

    private void checkFocus() {
        this.hasFocus = DarculaComboBoxUI.hasFocus(this.comboBox);
        if (this.hasFocus) {
            return;
        }
        ComboBoxEditor ed = this.comboBox.getEditor();
        Component component = this.editor = ed == null ? null : ed.getEditorComponent();
        if (this.editor != null) {
            this.hasFocus = DarculaComboBoxUI.hasFocus(this.editor);
        }
    }

    private static boolean hasFocus(Component c) {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return owner != null && SwingUtilities.isDescendingFrom(owner, c);
    }

    private static Color getBorderColor() {
        return UIManager.getLookAndFeelDefaults().getColor("ComboBox.darculaMod.borderColor");
    }

    private static Color getFocusedBorderColor() {
        return UIManager.getLookAndFeelDefaults().getColor("ComboBox.darculaMod.focusedBorderColor");
    }

    private static Color getArrowButtonFillColorForTableCellEditor() {
        return UIManager.getLookAndFeelDefaults().getColor("ComboBox.darculaMod.arrowButtonFillColorForTableCellEditor");
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new InsetsUIResource(4, 6, 4, 6);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void installUI(JComponent c) {
        this.isMinimumSizeDirty = true;
        this.comboBox = (JComboBox)c;
        this.installDefaults();
        this.popup = this.createPopup();
        this.listBox = this.popup.getList();
        Boolean inTable = (Boolean)c.getClientProperty(MY_IS_TABLE_CELL_EDITOR);
        if (inTable != null) {
            boolean bl = this.myIsTableCellEditor = inTable.equals(Boolean.TRUE);
        }
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(this.createRenderer());
        }
        if (this.comboBox.getEditor() == null || this.comboBox.getEditor() instanceof UIResource) {
            this.comboBox.setEditor(this.createEditor());
        }
        this.installListeners();
        this.installComponents();
        this.comboBox.setLayout(this.createLayoutManager());
        this.comboBox.setRequestFocusEnabled(true);
        this.installKeyboardActions();
        this.comboBox.putClientProperty("doNotCancelPopup", MY_HIDE_POPUP_KEY);
        if (this.myKeySelectionManager == null || this.myKeySelectionManager instanceof UIResource) {
            this.myKeySelectionManager = new MyDefaultKeySelectionManager();
        }
        this.comboBox.setKeySelectionManager(this.myKeySelectionManager);
    }

    @Override
    public void uninstallUI(JComponent c) {
        ComboBoxEditor comboBoxEditor;
        this.setPopupVisible(this.comboBox, false);
        this.popup.uninstallingUI();
        this.uninstallKeyboardActions();
        this.comboBox.setLayout(null);
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(null);
        }
        if ((comboBoxEditor = this.comboBox.getEditor()) instanceof UIResource) {
            if (comboBoxEditor.getEditorComponent().hasFocus()) {
                this.comboBox.requestFocusInWindow();
            }
            this.comboBox.setEditor(null);
        }
        if (this.myKeySelectionManager instanceof UIResource) {
            this.comboBox.setKeySelectionManager(null);
        }
        this.myHandler = null;
        this.keyListener = null;
        this.focusListener = null;
        this.listDataListener = null;
        this.propertyChangeListener = null;
        this.popup = null;
        this.listBox = null;
        this.comboBox = null;
    }

    @Override
    protected void selectNextPossibleValue() {
        int si = this.comboBox.isPopupVisible() ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (si < this.comboBox.getModel().getSize() - 1) {
            this.listBox.setSelectedIndex(si + 1);
            this.listBox.ensureIndexIsVisible(si + 1);
            if (!(this.myIsTableCellEditor || UIManager.getBoolean("ComboBox.noActionOnKeyNavigation") && this.comboBox.isPopupVisible())) {
                this.comboBox.setSelectedIndex(si + 1);
            }
            this.comboBox.repaint();
        }
    }

    @Override
    protected void selectPreviousPossibleValue() {
        int si = this.comboBox.isPopupVisible() ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (si > 0) {
            this.listBox.setSelectedIndex(si - 1);
            this.listBox.ensureIndexIsVisible(si - 1);
            if (!(this.myIsTableCellEditor || UIManager.getBoolean("ComboBox.noActionOnKeyNavigation") && this.comboBox.isPopupVisible())) {
                this.comboBox.setSelectedIndex(si - 1);
            }
            this.comboBox.repaint();
        }
    }

    boolean isTableCellEditor() {
        return this.myIsTableCellEditor;
    }

    private boolean isNavigationKey(int keyCode, int modifiers) {
        InputMap inputMap = this.comboBox.getInputMap(1);
        KeyStroke key = KeyStroke.getKeyStroke(keyCode, modifiers);
        return inputMap != null && inputMap.get(key) != null;
    }

    private boolean myIsMenuShortcutKeyDown(InputEvent event) {
        return (event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    private boolean myIsLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    private void myUpdateToolTipTextForChildren() {
        Component[] children = this.comboBox.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof JComponent)) continue;
            ((JComponent)children[i]).setToolTipText(this.comboBox.getToolTipText());
        }
    }

    private MouseWheelListener myCreateMouseWheelListener() {
        return this.myGetHandler();
    }

    @Override
    protected KeyListener createKeyListener() {
        return this.myGetHandler();
    }

    @Override
    protected FocusListener createFocusListener() {
        return this.myGetHandler();
    }

    @Override
    protected ListDataListener createListDataListener() {
        return this.myGetHandler();
    }

    @Override
    protected ItemListener createItemListener() {
        return null;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return this.myGetHandler();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return this.myGetHandler();
    }

    @Override
    protected void installListeners() {
        this.itemListener = this.createItemListener();
        if (this.itemListener != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.comboBox.addKeyListener(this.keyListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.comboBox.addFocusListener(this.focusListener);
        }
        if ((this.popupMouseListener = this.popup.getMouseListener()) != null) {
            this.comboBox.addMouseListener(this.popupMouseListener);
        }
        if ((this.popupMouseMotionListener = this.popup.getMouseMotionListener()) != null) {
            this.comboBox.addMouseMotionListener(this.popupMouseMotionListener);
        }
        if ((this.popupKeyListener = this.popup.getKeyListener()) != null) {
            this.comboBox.addKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && (this.listDataListener = this.createListDataListener()) != null) {
            this.comboBox.getModel().addListDataListener(this.listDataListener);
        }
        if ((this.myMouseWheelListener = this.myCreateMouseWheelListener()) != null) {
            this.comboBox.addMouseWheelListener(this.myMouseWheelListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        if (this.keyListener != null) {
            this.comboBox.removeKeyListener(this.keyListener);
        }
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.focusListener != null) {
            this.comboBox.removeFocusListener(this.focusListener);
        }
        if (this.popupMouseListener != null) {
            this.comboBox.removeMouseListener(this.popupMouseListener);
        }
        if (this.popupMouseMotionListener != null) {
            this.comboBox.removeMouseMotionListener(this.popupMouseMotionListener);
        }
        if (this.popupKeyListener != null) {
            this.comboBox.removeKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && this.listDataListener != null) {
            this.comboBox.getModel().removeListDataListener(this.listDataListener);
        }
        if (this.myMouseWheelListener != null) {
            this.comboBox.removeMouseWheelListener(this.myMouseWheelListener);
        }
    }

    @Override
    protected void configureEditor() {
        this.editor.setEnabled(this.comboBox.isEnabled());
        this.editor.setFocusable(this.comboBox.isFocusable());
        this.editor.setFont(this.comboBox.getFont());
        if (this.focusListener != null) {
            this.editor.addFocusListener(this.focusListener);
        }
        this.editor.addFocusListener(this.myGetHandler());
        this.comboBox.getEditor().addActionListener(this.myGetHandler());
        if (this.editor instanceof JComponent) {
            ((JComponent)this.editor).putClientProperty("doNotCancelPopup", MY_HIDE_POPUP_KEY);
            ((JComponent)this.editor).setInheritsPopupMenu(true);
        }
        this.comboBox.configureEditor(this.comboBox.getEditor(), this.comboBox.getSelectedItem());
        this.editor.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void unconfigureEditor() {
        if (this.focusListener != null) {
            this.editor.removeFocusListener(this.focusListener);
        }
        this.editor.removePropertyChangeListener(this.propertyChangeListener);
        this.editor.removeFocusListener(this.myGetHandler());
        this.comboBox.getEditor().removeActionListener(this.myGetHandler());
    }

    private MyHandler myGetHandler() {
        if (this.myHandler == null) {
            this.myHandler = new MyHandler();
        }
        return this.myHandler;
    }

    private class MyHandler
    implements ActionListener,
    FocusListener,
    KeyListener,
    LayoutManager,
    ListDataListener,
    PropertyChangeListener,
    MouseWheelListener {
        private MyHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getSource() == DarculaComboBoxUI.this.editor) {
                if ("border".equals(propertyName)) {
                    DarculaComboBoxUI.this.isMinimumSizeDirty = true;
                    DarculaComboBoxUI.this.myIsDisplaySizeDirty = true;
                    DarculaComboBoxUI.this.comboBox.revalidate();
                }
            } else {
                JComboBox comboBox = (JComboBox)e.getSource();
                if ("model".equals(propertyName)) {
                    ComboBoxModel newModel = (ComboBoxModel)e.getNewValue();
                    ComboBoxModel oldModel = (ComboBoxModel)e.getOldValue();
                    if (oldModel != null && DarculaComboBoxUI.this.listDataListener != null) {
                        oldModel.removeListDataListener(DarculaComboBoxUI.this.listDataListener);
                    }
                    if (newModel != null && DarculaComboBoxUI.this.listDataListener != null) {
                        newModel.addListDataListener(DarculaComboBoxUI.this.listDataListener);
                    }
                    if (DarculaComboBoxUI.this.editor != null) {
                        comboBox.configureEditor(comboBox.getEditor(), comboBox.getSelectedItem());
                    }
                    DarculaComboBoxUI.this.isMinimumSizeDirty = true;
                    DarculaComboBoxUI.this.myIsDisplaySizeDirty = true;
                    comboBox.revalidate();
                    comboBox.repaint();
                } else if ("editor".equals(propertyName) && comboBox.isEditable()) {
                    DarculaComboBoxUI.this.addEditor();
                    comboBox.revalidate();
                } else if ("editable".equals(propertyName)) {
                    if (comboBox.isEditable()) {
                        comboBox.setRequestFocusEnabled(false);
                        DarculaComboBoxUI.this.addEditor();
                    } else {
                        comboBox.setRequestFocusEnabled(true);
                        DarculaComboBoxUI.this.removeEditor();
                    }
                    DarculaComboBoxUI.this.myUpdateToolTipTextForChildren();
                    comboBox.revalidate();
                } else if ("enabled".equals(propertyName)) {
                    boolean enabled = comboBox.isEnabled();
                    if (DarculaComboBoxUI.this.editor != null) {
                        DarculaComboBoxUI.this.editor.setEnabled(enabled);
                    }
                    if (DarculaComboBoxUI.this.arrowButton != null) {
                        DarculaComboBoxUI.this.arrowButton.setEnabled(enabled);
                    }
                    comboBox.repaint();
                } else if ("focusable".equals(propertyName)) {
                    boolean focusable = comboBox.isFocusable();
                    if (DarculaComboBoxUI.this.editor != null) {
                        DarculaComboBoxUI.this.editor.setFocusable(focusable);
                    }
                    if (DarculaComboBoxUI.this.arrowButton != null) {
                        DarculaComboBoxUI.this.arrowButton.setFocusable(focusable);
                    }
                    comboBox.repaint();
                } else if ("maximumRowCount".equals(propertyName)) {
                    if (DarculaComboBoxUI.this.isPopupVisible(comboBox)) {
                        DarculaComboBoxUI.this.setPopupVisible(comboBox, false);
                        DarculaComboBoxUI.this.setPopupVisible(comboBox, true);
                    }
                } else if ("font".equals(propertyName)) {
                    DarculaComboBoxUI.this.listBox.setFont(comboBox.getFont());
                    if (DarculaComboBoxUI.this.editor != null) {
                        DarculaComboBoxUI.this.editor.setFont(comboBox.getFont());
                    }
                    DarculaComboBoxUI.this.isMinimumSizeDirty = true;
                    DarculaComboBoxUI.this.myIsDisplaySizeDirty = true;
                    comboBox.validate();
                } else if (propertyName == "ToolTipText") {
                    DarculaComboBoxUI.this.myUpdateToolTipTextForChildren();
                } else if (propertyName == DarculaComboBoxUI.MY_IS_TABLE_CELL_EDITOR) {
                    Boolean inTable = (Boolean)e.getNewValue();
                    DarculaComboBoxUI.this.myIsTableCellEditor = inTable.equals(Boolean.TRUE);
                } else if (propertyName == "prototypeDisplayValue") {
                    DarculaComboBoxUI.this.isMinimumSizeDirty = true;
                    DarculaComboBoxUI.this.myIsDisplaySizeDirty = true;
                    comboBox.revalidate();
                } else if (propertyName == "renderer") {
                    DarculaComboBoxUI.this.isMinimumSizeDirty = true;
                    DarculaComboBoxUI.this.myIsDisplaySizeDirty = true;
                    comboBox.revalidate();
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (DarculaComboBoxUI.this.isNavigationKey(e.getKeyCode(), e.getModifiers())) {
                DarculaComboBoxUI.this.myLastTime = 0L;
            } else if (DarculaComboBoxUI.this.comboBox.isEnabled() && DarculaComboBoxUI.this.comboBox.getModel().getSize() != 0 && this.isTypeAheadKey(e) && e.getKeyChar() != '\uffff') {
                DarculaComboBoxUI.this.myTime = e.getWhen();
                if (DarculaComboBoxUI.this.comboBox.selectWithKeyChar(e.getKeyChar())) {
                    e.consume();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        private boolean isTypeAheadKey(KeyEvent e) {
            return !e.isAltDown() && !DarculaComboBoxUI.this.myIsMenuShortcutKeyDown(e);
        }

        @Override
        public void focusGained(FocusEvent e) {
            ComboBoxEditor comboBoxEditor = DarculaComboBoxUI.this.comboBox.getEditor();
            if (comboBoxEditor != null && e.getSource() == comboBoxEditor.getEditorComponent()) {
                return;
            }
            DarculaComboBoxUI.this.hasFocus = true;
            DarculaComboBoxUI.this.comboBox.repaint();
            if (DarculaComboBoxUI.this.comboBox.isEditable() && DarculaComboBoxUI.this.editor != null) {
                DarculaComboBoxUI.this.editor.requestFocus();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            ComboBoxEditor editor = DarculaComboBoxUI.this.comboBox.getEditor();
            if (editor != null && e.getSource() == editor.getEditorComponent()) {
                Object item = editor.getItem();
                Object selectedItem = DarculaComboBoxUI.this.comboBox.getSelectedItem();
                if (!e.isTemporary() && item != null && !item.equals(selectedItem == null ? "" : selectedItem)) {
                    DarculaComboBoxUI.this.comboBox.actionPerformed(new ActionEvent(editor, 0, "", EventQueue.getMostRecentEventTime(), 0));
                }
            }
            DarculaComboBoxUI.this.hasFocus = false;
            if (!e.isTemporary()) {
                DarculaComboBoxUI.this.setPopupVisible(DarculaComboBoxUI.this.comboBox, false);
            }
            DarculaComboBoxUI.this.comboBox.repaint();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (e.getIndex0() != -1 || e.getIndex1() != -1) {
                DarculaComboBoxUI.this.isMinimumSizeDirty = true;
                DarculaComboBoxUI.this.comboBox.revalidate();
            }
            if (DarculaComboBoxUI.this.comboBox.isEditable() && DarculaComboBoxUI.this.editor != null) {
                DarculaComboBoxUI.this.comboBox.configureEditor(DarculaComboBoxUI.this.comboBox.getEditor(), DarculaComboBoxUI.this.comboBox.getSelectedItem());
            }
            DarculaComboBoxUI.this.myIsDisplaySizeDirty = true;
            DarculaComboBoxUI.this.comboBox.repaint();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonHeight;
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = DarculaComboBoxUI.this.getInsets();
            int buttonWidth = buttonHeight = height - (insets.top + insets.bottom);
            if (DarculaComboBoxUI.this.arrowButton != null) {
                Insets arrowInsets = DarculaComboBoxUI.this.arrowButton.getInsets();
                int n = buttonWidth = DarculaComboBoxUI.this.squareButton ? buttonHeight : ((DarculaComboBoxUI)DarculaComboBoxUI.this).arrowButton.getPreferredSize().width + arrowInsets.left + arrowInsets.right;
            }
            if (DarculaComboBoxUI.this.arrowButton != null) {
                if (DarculaComboBoxUI.this.myIsLeftToRight(cb)) {
                    DarculaComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    DarculaComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            if (DarculaComboBoxUI.this.editor != null) {
                Rectangle cvb = DarculaComboBoxUI.this.rectangleForCurrentValue();
                DarculaComboBoxUI.this.editor.setBounds(cvb);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object item = DarculaComboBoxUI.this.comboBox.getEditor().getItem();
            if (item != null) {
                Object keyEvent;
                Action action;
                ActionMap am;
                if (!DarculaComboBoxUI.this.comboBox.isPopupVisible() && !item.equals(DarculaComboBoxUI.this.comboBox.getSelectedItem())) {
                    DarculaComboBoxUI.this.comboBox.setSelectedItem(DarculaComboBoxUI.this.comboBox.getEditor().getItem());
                }
                if ((am = DarculaComboBoxUI.this.comboBox.getActionMap()) != null && (action = am.get("enterPressed")) != null && DarculaComboBoxUI.this.comboBox != null && ((keyEvent = DarculaComboBoxUI.this.comboBox.getClientProperty(DarculaComboBoxUI.FORWARD_ENTER_KEY_EVENT)) == null || keyEvent == Boolean.TRUE)) {
                    action.actionPerformed(new ActionEvent(DarculaComboBoxUI.this.comboBox, evt.getID(), evt.getActionCommand(), evt.getModifiers()));
                }
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            e.consume();
        }
    }

    private class MyDefaultKeySelectionManager
    implements JComboBox.KeySelectionManager,
    UIResource {
        private String prefix = "";
        private String typedString = "";

        private MyDefaultKeySelectionManager() {
        }

        public int selectionForKey(char aKey, ComboBoxModel aModel) {
            int index;
            if (DarculaComboBoxUI.this.myLastTime == 0L) {
                this.prefix = "";
                this.typedString = "";
            }
            boolean startingFromSelection = true;
            int startIndex = DarculaComboBoxUI.this.comboBox.getSelectedIndex();
            if (DarculaComboBoxUI.this.myTime - DarculaComboBoxUI.this.myLastTime < DarculaComboBoxUI.this.myTimeFactor) {
                this.typedString = this.typedString + aKey;
                if (this.prefix.length() == 1 && aKey == this.prefix.charAt(0)) {
                    ++startIndex;
                } else {
                    this.prefix = this.typedString;
                }
            } else {
                ++startIndex;
                this.prefix = this.typedString = "" + aKey;
            }
            DarculaComboBoxUI.this.myLastTime = DarculaComboBoxUI.this.myTime;
            if (startIndex < 0 || startIndex >= aModel.getSize()) {
                startingFromSelection = false;
                startIndex = 0;
            }
            if ((index = DarculaComboBoxUI.this.listBox.getNextMatch(this.prefix, startIndex, Position.Bias.Forward)) < 0 && startingFromSelection) {
                index = DarculaComboBoxUI.this.listBox.getNextMatch(this.prefix, 0, Position.Bias.Forward);
            }
            return index;
        }
    }
}

