/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.GraphicsUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class DarculaProgressBarUI
extends BasicProgressBarUI {
    protected volatile int offset = 0;

    public static ComponentUI createUI(JComponent c) {
        c.setBorder(new BorderUIResource(new EmptyBorder(0, 0, 0, 0)));
        return new DarculaProgressBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.FALSE);
    }

    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getPreferredSize().height - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        g.setColor(UIManager.getLookAndFeelDefaults().getColor("ProgressBar.darculaMod.IndeterminateColor1"));
        int w = barRectWidth;
        int h = barRectHeight;
        g.fillRect(0, 0, w, h);
        g.setColor(UIManager.getLookAndFeelDefaults().getColor("ProgressBar.darculaMod.IndeterminateColor2"));
        GraphicsUtil.setupAAPainting(g);
        Path2D.Double path = new Path2D.Double();
        int ww = this.getPeriodLength() / 2;
        path.moveTo(0.0, 0.0);
        path.lineTo(ww, 0.0);
        path.lineTo(ww - h / 2, h);
        path.lineTo(-h / 2, h);
        path.lineTo(0.0, 0.0);
        path.closePath();
        for (int x = -this.offset; x < Math.max(barRectWidth, barRectHeight); x += this.getPeriodLength()) {
            g.translate(x, 0);
            ((Graphics2D)g).fill(path);
            g.translate(-x, 0);
        }
        this.offset = (this.offset + 1) % this.getPeriodLength();
        Area area = new Area(new Rectangle2D.Double(0.0, 0.0, w, h));
        area.subtract(new Area(new RoundRectangle2D.Double(1.0, 1.0, w - 2, h - 2, 0.0, 0.0)));
        ((Graphics2D)g).setPaint(UIManager.getLookAndFeelDefaults().getColor("ProgressBar.darculaMod.IndeterminateBorderColor"));
        ((Graphics2D)g).fill(area);
        area.subtract(new Area(new RoundRectangle2D.Double(0.0, 0.0, w, h, 0.0, 0.0)));
        ((Graphics2D)g).setPaint(UIManager.getLookAndFeelDefaults().getColor("ProgressBar.darculaMod.IndeterminateBackgroundColor"));
        ((Graphics2D)g).fill(area);
        g.drawRoundRect(1, 1, w - 3, h - 3, 0, 0);
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.x, this.boxRect.width);
            } else {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.y, this.boxRect.height);
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return super.getPreferredSize(c);
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        if (this.progressBar.getOrientation() != 0 || !c.getComponentOrientation().isLeftToRight()) {
            super.paintDeterminate(g, c);
            return;
        }
        GraphicsUtil.setupAAPainting(g);
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getPreferredSize().height - (b.top + b.bottom);
        int w = barRectWidth;
        int h = barRectHeight;
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(UIManager.getLookAndFeelDefaults().getColor("ProgressBar.darculaMod.DeterminateBorderColor"));
        g2.fill(new RoundRectangle2D.Double(0.0, 0.0, w - 1, h - 1, 0.0, 0.0));
        g2.setColor(UIManager.getLookAndFeelDefaults().getColor("ProgressBar.darculaMod.DeterminateBackgroundColor"));
        g2.fill(new RoundRectangle2D.Double(1.0, 1.0, w - 3, h - 3, 0.0, 0.0));
        g2.setColor(UIManager.getLookAndFeelDefaults().getColor("ProgressBar.darculaMod.DeterminateLeftBackgroundColor"));
        g2.fill(new RoundRectangle2D.Double(2.0, 2.0, amountFull - 5, h - 5, 0.0, 0.0));
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    public void paintString(Graphics g, int x, int y, int w, int h, int fillStart, int amountFull) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        GraphicsUtil.setupTextAntialiasing(g, null);
        String progressString = this.progressBar.getString();
        g2.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, w, h);
        Rectangle oldClip = g2.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g2.setColor(this.getSelectionBackground());
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(fillStart, y, amountFull, h);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
        } else {
            g2.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g2.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g2, progressString, x, y, w, h);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(x, fillStart, w, amountFull);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
        }
        g2.setClip(oldClip);
    }

    @Override
    protected int getBoxLength(int availableLength, int otherDimension) {
        return availableLength;
    }

    protected int getPeriodLength() {
        return 16;
    }
}

