/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.ui.DarculaTextFieldUI;
import com.bulenkov.iconloader.util.GraphicsConfig;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class DarculaTextBorder
implements Border,
UIResource {
    public static final String NO_BORDER_TEXTFIELD = "noBorderTextField";
    public static final int X_BORDER_NORMAL = 7;
    public static final int X_BORDER_SMALL = 1;

    @Override
    public Insets getBorderInsets(Component c) {
        int vOffset;
        int n = vOffset = c instanceof JPasswordField ? 3 : 4;
        if (DarculaTextFieldUI.isSearchField(c)) {
            if (DarculaTextFieldUI.isSmall(c)) {
                return new InsetsUIResource(1, 1, 1, 8);
            }
            return new InsetsUIResource(vOffset, 7, vOffset, 7 + DarculaTextFieldUI.ICON_SIZE_NORMAL);
        }
        if (DarculaTextFieldUI.isSmall(c)) {
            return new InsetsUIResource(1, 1, 1, 1);
        }
        return new InsetsUIResource(vOffset, 7, vOffset, 7);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        boolean editable;
        if (DarculaTextFieldUI.isSmall(c) || DarculaTextFieldUI.isSearchField(c) && Boolean.TRUE.equals(((JTextField)c).getClientProperty("JTextField.Search.noBorderRing")) || c instanceof JTextField && Boolean.TRUE.equals(((JTextField)c).getClientProperty(NO_BORDER_TEXTFIELD))) {
            return;
        }
        Graphics2D g = (Graphics2D)g2;
        GraphicsConfig config = new GraphicsConfig(g);
        g.translate(x, y);
        boolean bl = editable = !(c instanceof JTextComponent) || ((JTextComponent)c).isEditable();
        if (c.hasFocus() && editable) {
            g.setColor(UIManager.getLookAndFeelDefaults().getColor("darculaMod.borderFocusGlowColor"));
        } else {
            g.setColor(c.isEnabled() && editable ? UIManager.getLookAndFeelDefaults().getColor("darculaMod.textBorderEnabledEditableColor") : UIManager.getLookAndFeelDefaults().getColor("darculaMod.textBorderNotEnabledOrNotEditableColor"));
        }
        g.drawRect(0, 0, width - 1, height - 1);
        g.translate(-x, -y);
        config.restore();
    }
}

