/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.actions.TopGraphSelectionContextAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.util.Exceptions;

public class AddCommonSiblingsAction
extends TopGraphSelectionContextAction {
    public String getName() {
        return "Add Similar Siblings";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/SelectChildren.png";
    }

    @Override
    protected void actionPerformed(GraphView graphView) {
        try {
            GraphID graphID = this.getTopGraphID();
            GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
            Set selectedEntities = selection.getSelectedModelEntities();
            HashSet<EntityID> addToSelection = new HashSet<EntityID>();
            for (EntityID modelEntity : selectedEntities) {
                addToSelection.addAll(this.getCommonSiblings(graphID, modelEntity));
            }
            selection.addSelectedModelEntities(addToSelection);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Set<EntityID> getCommonSiblings(GraphID graphID, EntityID modelEntity) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
        String type = dataReader.getEntityType(modelEntity);
        Set parents = structureReader.getParents(modelEntity);
        Set<EntityID> siblings = this.getChildrenOfType(graphID, parents, type);
        return siblings;
    }

    private Set<EntityID> getChildrenOfType(GraphID graphID, Set<EntityID> parents, String type) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
        HashSet<EntityID> childrenOfType = new HashSet<EntityID>();
        Map children = structureReader.getChildren(parents);
        for (Map.Entry entry : children.entrySet()) {
            Set siblingChildren = (Set)entry.getValue();
            for (EntityID sibling : siblingChildren) {
                String siblingType = dataReader.getEntityType(sibling);
                if (!type.equals(siblingType)) continue;
                childrenOfType.add(sibling);
            }
        }
        return childrenOfType;
    }
}

