/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.data.sort.SortField;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.view2d.layout.SmartLayouter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import yguard.A.A.D;
import yguard.A.A.E;
import yguard.A.A.I;
import yguard.A.A.K;
import yguard.A.A.Y;
import yguard.A.G.RA;
import yguard.A.G.n;

public class NodeOrderLayouter
extends SmartLayouter {
    public static final String NODE_ORDER_DPKEY = "nodeOrder";
    private static final Logger LOG = Logger.getLogger(NodeOrderLayouter.class.getName());

    public boolean canLayout(RA lg) {
        return true;
    }

    public void doLayout(RA lg) {
        n coreLayouter = this.getCoreLayouter();
        if (coreLayouter != null && coreLayouter.canLayout(lg)) {
            try {
                this.initialize(lg);
                this.configureNodeOrder();
                coreLayouter.doLayout(lg);
            }
            finally {
                this.disposeNodeMap(lg, NODE_ORDER_DPKEY);
                this.uninitialize();
            }
        }
    }

    protected void configureNodeOrder() {
        GraphID graphID = GraphIDProvider.forGraph((D)this.getOriginalGraph());
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
        HashMap<EntityID, Y> entityIDToNodes = new HashMap<EntityID, Y>();
        E nc = this.getLayoutGraph().\u00a4();
        while (nc.ok()) {
            Y layoutNode = nc.B();
            Y originalNode = this.getOriginalNode(layoutNode);
            entityIDToNodes.put(wrapper.entityID(originalNode), layoutNode);
            nc.next();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Before sort");
            this.logViewEntityList(graphID, entityIDToNodes.keySet());
        }
        List<EntityID> sorted = this.getSortedViewEntities(graphID, entityIDToNodes.keySet());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("After sort");
            this.logViewEntityList(graphID, sorted);
        }
        RA layoutGraph = this.getLayoutGraph();
        I nodeId = layoutGraph.\u00ba();
        layoutGraph.A((Object)NODE_ORDER_DPKEY, (K)nodeId);
        layoutGraph.A(NODE_ID_DPKEY, (K)nodeId);
        int num = 0;
        for (EntityID entityID : sorted) {
            Y node = (Y)entityIDToNodes.get(entityID);
            nodeId.set((Object)node, (Object)num++);
        }
    }

    private List<EntityID> getSortedViewEntities(GraphID graphID, Set<EntityID> viewEntityIDs) {
        ArrayList<EntityID> sortedViewEntityIDs = null;
        try {
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            GraphModelViewMappings mappings = view.getModelViewMappings();
            List<EntityID> collectionEntityIDs = new ArrayList<EntityID>();
            List<EntityID> nonCollectionEntityIDs = new ArrayList<EntityID>();
            for (EntityID viewEntityID : viewEntityIDs) {
                if (mappings.isOnlyViewEntity(viewEntityID)) {
                    collectionEntityIDs.add(viewEntityID);
                    continue;
                }
                nonCollectionEntityIDs.add(viewEntityID);
            }
            collectionEntityIDs = this.getSortedCollectionEntities(view, collectionEntityIDs);
            nonCollectionEntityIDs = this.getSortedNonCollectionEntities(graphID, nonCollectionEntityIDs);
            sortedViewEntityIDs = new ArrayList<EntityID>(nonCollectionEntityIDs);
            sortedViewEntityIDs.addAll(collectionEntityIDs);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sortedViewEntityIDs;
    }

    private List<EntityID> getSortedNonCollectionEntities(GraphID graphID, List<EntityID> modelEntities) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
        return dataReader.getSortedEntities(modelEntities, new SortField[]{new SortField(10, true), new SortField(9, false), new SortField(11, true)});
    }

    private List<EntityID> getSortedCollectionEntities(GraphStoreView view, List<EntityID> collectionEntities) throws GraphStoreException {
        final GraphModelViewMappings mappings = view.getModelViewMappings();
        Collections.sort(collectionEntities, new Comparator<EntityID>(){

            @Override
            public int compare(EntityID o1, EntityID o2) {
                int result = 0;
                try {
                    int o1Size = mappings.getModelEntities(o1).size();
                    int o2Size = mappings.getModelEntities(o2).size();
                    result = o1Size - o2Size;
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return result;
            }
        });
        return collectionEntities;
    }

    private void logViewEntityList(GraphID graphID, Collection<EntityID> entities) {
        try {
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            GraphModelViewMappings mappings = view.getModelViewMappings();
            StringBuilder sb = new StringBuilder();
            for (EntityID entityID : entities) {
                if (mappings.isOnlyViewEntity(entityID)) {
                    sb.append(mappings.getModelEntities(entityID).size()).append(" entities\n");
                    continue;
                }
                MaltegoEntity entity = GraphStoreHelper.getEntity((GraphID)graphID, (EntityID)entityID);
                sb.append(entity.getWeight()).append(" ");
                sb.append(entity.getTypeName()).append(" ");
                sb.append(entity.getDisplayString()).append("\n");
            }
            LOG.fine(sb.toString());
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

