/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.painter;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.Evaluator;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.ui.graph.EntityColorFactory;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeRenderInfo;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.painter.EntityOverlay;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class EntityPaintContext {
    private static final EntityColorFactory _colorFactory = EntityColorFactory.getDefault();
    private static final EmptyImgCallback _imgCallback = new EmptyImgCallback();
    private static final int IMAGE_SIZE = IconSize.LARGE.getSize();
    private static final int COLLECTIONS_IMAGE_SIZE = IconSize.MEDIUM.getSize();
    public static final float COLLECTIONS_IMAGE_INTER_GAP = 2.0f;
    private LightweightEntityRealizer _realizer;
    private String _entityTypeName;
    private MaltegoEntitySpec _spec;
    private boolean _specSet = false;
    private EntityRegistry _registry;
    private Object _imgObject;
    private boolean _imgObjectSet = false;
    private Rectangle _imgRect;
    private final Rectangle[] _imgCollectionsRectArray;
    private Image _img;
    private List<EntityOverlay> entityOverlays;
    private final Evaluator evaluator = new Evaluator.Replacement();
    private Image _typeImg;
    private Color _typeColor;
    private String _typeDisplayName;
    private EntityImageFactory _imgFactory;

    public EntityPaintContext() {
        this._imgCollectionsRectArray = new Rectangle[4];
    }

    public void setRealizer(LightweightEntityRealizer realizer) {
        this.clear();
        this._realizer = realizer;
    }

    public LightweightEntityRealizer getRealizer() {
        return this._realizer;
    }

    public void clear() {
        this._realizer = null;
        this._entityTypeName = null;
        this._spec = null;
        this._specSet = false;
        this._registry = null;
        this._imgObject = null;
        this._imgObjectSet = false;
        this._imgRect = null;
        Arrays.fill(this._imgCollectionsRectArray, null);
        this._img = null;
        this._typeImg = null;
        this._typeColor = null;
        this._typeDisplayName = null;
        this._imgFactory = null;
        this.entityOverlays = null;
    }

    public float getX() {
        return (float)this._realizer.getX();
    }

    public float getY() {
        return (float)this._realizer.getY();
    }

    public float getWidth() {
        return (float)this._realizer.getWidth();
    }

    public float getHeight() {
        return (float)this._realizer.getHeight();
    }

    public CollectionNodeRenderInfo getCollectionNodeInfo() {
        return this._realizer.getCollectionNodeInfo();
    }

    public MaltegoEntity getEntitySkeleton() {
        return this._realizer.getEntitySkeleton();
    }

    public boolean isCollectionNode() {
        return this.getCollectionNodeInfo() != null;
    }

    public String getEntityTypeName() {
        if (this._entityTypeName == null) {
            this._entityTypeName = this.isCollectionNode() ? this.getCollectionNodeInfo().getType() : this.getEntitySkeleton().getTypeName();
        }
        return this._entityTypeName;
    }

    public MaltegoEntitySpec getEntitySpec() {
        if (!this._specSet) {
            String entityTypeName = this.getEntityTypeName();
            EntityRegistry registry = this.getEntityRegistry();
            this._spec = (MaltegoEntitySpec)registry.get(entityTypeName);
            this._specSet = true;
        }
        return this._spec;
    }

    public EntityRegistry getEntityRegistry() {
        if (this._registry == null) {
            GraphID graphID = this._realizer.getGraphEntity().getGraphID();
            this._registry = EntityRegistry.forGraphID((GraphID)graphID);
        }
        return this._registry;
    }

    public Object getImageObject() {
        if (!this._imgObjectSet) {
            MaltegoEntity entitySkeleton = this.getEntitySkeleton();
            this._imgObject = entitySkeleton != null ? entitySkeleton.getCachedImageKey().orElse(null) : null;
            this._imgObjectSet = true;
        }
        return this._imgObject;
    }

    public Image getImage() {
        if (this._img == null) {
            EntityImageFactory factory = this.getImageFactory();
            String entityTypeName = this.getEntityTypeName();
            Object imageObject = this.getImageObject();
            this._img = factory.getImage(entityTypeName, imageObject, -1, -1, (ImageCallback)_imgCallback);
        }
        return this._img;
    }

    public Image getTypeImage() {
        if (this._typeImg == null) {
            EntityImageFactory factory = this.getImageFactory();
            String entityTypeName = this.getEntityTypeName();
            this._typeImg = factory.getTypeImage(entityTypeName, (ImageCallback)_imgCallback);
        }
        return this._typeImg;
    }

    public Color getTypeColor() {
        if (this._typeColor == null) {
            String entityTypeName = this.getEntityTypeName();
            this._typeColor = _colorFactory.getTypeColor(entityTypeName);
        }
        return this._typeColor;
    }

    public String getTypeDisplayName() {
        if (this._typeDisplayName == null) {
            MaltegoEntitySpec spec = this.getEntitySpec();
            this._typeDisplayName = spec == null ? this.getEntityTypeName() : spec.getDisplayName();
        }
        return this._typeDisplayName;
    }

    public boolean hasNonTypeImage() {
        Object imageObject = this.getImageObject();
        return imageObject != null && !imageObject.toString().isEmpty();
    }

    public Rectangle getCenteredImageRect() {
        if (this._imgRect == null) {
            Image image = this.getImage();
            Dimension d2 = ImageUtils.calcScaledSize((Image)image, (double)IMAGE_SIZE);
            float imgX = (this.getWidth() - (float)d2.getWidth()) / 2.0f + this.getX();
            float imgY = this.getY() + 12.0f + 18.7f;
            this._imgRect = new Rectangle();
            this._imgRect.setRect(imgX, imgY += (float)(IMAGE_SIZE - d2.height) / 2.0f, d2.width, d2.height);
        }
        return this._imgRect;
    }

    public Rectangle[] getCenteredImageCollectionsRectArray() {
        if (this._imgCollectionsRectArray[0] == null) {
            float width = (float)COLLECTIONS_IMAGE_SIZE * 2.0f + 2.0f;
            float height = (float)COLLECTIONS_IMAGE_SIZE * 2.0f + 2.0f;
            float imgX = (this.getWidth() - width) / 2.0f + this.getX();
            float imgY = (this.getHeight() - height) / 2.0f + this.getY();
            for (int row = 0; row < 2; ++row) {
                for (int col = 0; col < 2; ++col) {
                    int i = row * 2 + col;
                    double stepX = (float)(col % 2) * ((float)COLLECTIONS_IMAGE_SIZE + 2.0f);
                    double stepY = (float)(row % 2) * ((float)COLLECTIONS_IMAGE_SIZE + 2.0f);
                    this._imgCollectionsRectArray[i] = new Rectangle();
                    this._imgCollectionsRectArray[i].setRect((double)imgX + stepX, (double)imgY + stepY, COLLECTIONS_IMAGE_SIZE, COLLECTIONS_IMAGE_SIZE);
                }
            }
        }
        return this._imgCollectionsRectArray;
    }

    public List<EntityOverlay> getEntityOverlays() {
        if (this.entityOverlays != null) {
            return this.entityOverlays;
        }
        MaltegoEntity maltegoEntity = this.getEntitySkeleton();
        if (maltegoEntity == null) {
            return Collections.emptyList();
        }
        OverlayDescriptorSet overlays = maltegoEntity.getOverlaySet();
        if (overlays == null || overlays.isEmpty()) {
            return Collections.emptyList();
        }
        int size = IconSize.TINY.getSize();
        Rectangle centerRect = this.getCenteredImageRect();
        double centerX = (double)centerRect.x + (double)centerRect.width / 2.0;
        double centerY = (double)centerRect.y + (double)centerRect.height / 2.0 - 14.5;
        double xOffset = 34.5 - (double)size / 2.0;
        this.entityOverlays = new ArrayList<EntityOverlay>(overlays.size());
        PropertyDescriptorCollection properties = maltegoEntity.getProperties();
        for (OverlayDescriptor overlay : overlays) {
            OverlayDescriptor.Position position = overlay.getPosition();
            if (OverlayDescriptor.Position.EAST.column == position.column || OverlayDescriptor.Position.CENTER.equals((Object)position)) continue;
            OverlayDescriptor.Type type = overlay.getType();
            if (OverlayDescriptor.Position.SOUTH.equals((Object)position) && OverlayDescriptor.Type.TEXT.equals((Object)type)) continue;
            String propertyName = overlay.getPropertyName();
            Object value = propertyName;
            PropertyDescriptor property = properties.get(propertyName);
            if (property == null) {
                property = new PropertyDescriptor(String.class, "Evaluated Expression");
                if (propertyName.contains("$")) {
                    value = this.evaluator.evaluate(propertyName, (DataSource)maltegoEntity);
                }
            } else {
                value = maltegoEntity.getValue(property);
            }
            if (value == null) continue;
            boolean isCenterColumn = OverlayDescriptor.Position.CENTER.column == position.column;
            double yOffset = (double)size + (isCenterColumn ? 10.25 : 2.0);
            int x2 = (int)(centerX - xOffset - (double)size / 2.0 + (double)position.column * xOffset);
            int y2 = (int)(centerY - yOffset - (double)size / 2.0 + (double)position.row * yOffset);
            Rectangle rectangle = new Rectangle(x2, y2, size, size);
            EntityOverlay entityOverlay = new EntityOverlay(overlay, rectangle, property, value);
            this.entityOverlays.add(entityOverlay);
        }
        return this.entityOverlays;
    }

    public void setEntityOverlays(List<EntityOverlay> entityOverlays) {
        this.entityOverlays = entityOverlays;
    }

    private EntityImageFactory getImageFactory() {
        if (this._imgFactory == null) {
            GraphID graphID = this._realizer.getGraphEntity().getGraphID();
            this._imgFactory = EntityImageFactory.forGraph((GraphID)graphID);
        }
        return this._imgFactory;
    }

    static class EmptyImgCallback
    implements ImageCallback {
        EmptyImgCallback() {
        }

        public void imageReady(Image image) {
        }

        public void imageFailed(Exception ex) {
        }

        public boolean needAwtThread() {
            return false;
        }
    }
}

