/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tabular.transforms.run;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.graph.table.io.convert.TabularGraphPartFactory;
import com.paterva.maltego.graph.table.io.convert.TabularGraphTypes;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightEntity;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightLink;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLinkType;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.tabular.transforms.run.AbstractTabularTransformRunner;
import com.paterva.maltego.transform.runner.api.MatchingRuleUpdater;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transforms.tabular.data.TabularTransform;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.collections.MapUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TabularTransformRunner
extends AbstractTabularTransformRunner {
    private final TabularTransform tabularTransform;
    private final List<TabularGraphLink> tabularLinks;
    private final Map<MaltegoEntity, List<MaltegoEntity>> inputsToOutputs = new HashMap<MaltegoEntity, List<MaltegoEntity>>();
    private final Map<MaltegoLink, LinkEntityIDs> links = new HashMap<MaltegoLink, LinkEntityIDs>();

    public TabularTransformRunner(TransformRunContext ctx, MatchingRuleUpdater matchingRuleUpdater, TabularTransformSource source, TabularTransform tabularTransform) {
        super(ctx, matchingRuleUpdater, Collections.singletonList(source));
        Args.notNull((Object)source, (String)"source");
        Args.notNull((Object)tabularTransform, (String)"tabularTransform");
        this.tabularTransform = tabularTransform;
        TabularGraph mappings = MappingRegistry.getDefault().get(source.getTabularGraphName());
        if (mappings == null) {
            throw new IllegalArgumentException("Tabular graph not found for source: " + source.getDisplayName());
        }
        this.tabularLinks = tabularTransform.getLinks(mappings);
    }

    @Override
    protected TabularGraphPartFactory createPartFactory() {
        return new TabularTransformPartFactory(this.getTypes());
    }

    @Override
    protected void processRow(TabularGraphIterator rowIterator) throws Exception {
        Args.notNull((Object)rowIterator, (String)"rowIterator");
        List<TabularGraphLightweightEntity> lightEntities = this.getRowEntities(rowIterator);
        if (!lightEntities.isEmpty()) {
            this.getRowLinks(rowIterator, lightEntities);
            this.processEntitiesAndLinks();
        }
    }

    private void processEntitiesAndLinks() throws Exception {
        if (!this.inputsToOutputs.isEmpty() && !this.links.isEmpty()) {
            this.sendResults(this.inputsToOutputs, this.links);
            this.inputsToOutputs.clear();
            this.links.clear();
        }
    }

    private class TabularTransformPartFactory
    extends TabularGraphPartFactory {
        public TabularTransformPartFactory(TabularGraphTypes types) {
            super(types);
        }

        protected boolean shouldAdd(TabularGraphLinkType type, TabularGraphLightweightLink lightLink) throws Exception {
            Args.notNull((Object)type, (String)"type");
            Args.notNull((Object)lightLink, (String)"lightLink");
            int index = type.tabularLink.getIndex();
            for (TabularGraphLink tabularLink : TabularTransformRunner.this.tabularLinks) {
                if (index != tabularLink.getIndex()) continue;
                TabularGraphLightweightEntity lightEntity = this.getInput(lightLink);
                Optional inputEntityOpt = TabularTransformRunner.this.getOrCreateEntity(lightEntity).flatMap(this::getMatchingInputEntity);
                Optional<TabularGraphLightweightEntity> linkOpt = inputEntityOpt.flatMap(__ -> TabularTransformRunner.this.translate(lightLink));
                Optional outputEntityOpt = linkOpt.map(__ -> this.getOutput(lightLink)).flatMap(entity -> TabularTransformRunner.this.getOrCreateEntity((TabularGraphLightweightEntity)entity));
                if (!inputEntityOpt.isPresent() || !linkOpt.isPresent() || !outputEntityOpt.isPresent()) continue;
                MaltegoEntity inputEntity = (MaltegoEntity)inputEntityOpt.get();
                MaltegoEntity outputEntity = (MaltegoEntity)outputEntityOpt.get();
                MapUtils.addToList((Map)TabularTransformRunner.this.inputsToOutputs, (Object)inputEntity, (Object)outputEntity);
                TabularTransformRunner.this.links.put(linkOpt.get(), new LinkEntityIDs((EntityID)inputEntity.getID(), (EntityID)outputEntity.getID()));
                return true;
            }
            return false;
        }

        private TabularGraphLightweightEntity getInput(TabularGraphLightweightLink lightLink) {
            return this.getEntity(lightLink, true);
        }

        private TabularGraphLightweightEntity getOutput(TabularGraphLightweightLink lightLink) {
            return this.getEntity(lightLink, false);
        }

        private TabularGraphLightweightEntity getEntity(TabularGraphLightweightLink lightLink, boolean input) {
            boolean returnSource = input ^ TabularTransformRunner.this.tabularTransform.isReverse();
            return returnSource ? lightLink.sourceEntity : lightLink.targetEntity;
        }

        private Optional<MaltegoEntity> getMatchingInputEntity(MaltegoEntity entity) {
            TransformRunContext ctx = TabularTransformRunner.this.getContext();
            EntityRegistry registry = ctx.getEntityRegistry();
            Collection inputEntities = ctx.getInputEntities().values();
            return inputEntities.stream().filter(inputEntity -> this.isMatch(registry, entity, (MaltegoEntity)inputEntity)).findAny();
        }

        private boolean isMatch(EntityRegistry registry, MaltegoEntity entity1, MaltegoEntity entity2) {
            return MatchingRule.Default.getMatch((SpecRegistry)registry, (TypedPropertyBag)entity1, (TypedPropertyBag)entity2) == 1;
        }
    }
}

