/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.ui.imex.MappingConfig;
import com.paterva.maltego.graph.table.ui.imex.MappingEntry;
import com.paterva.maltego.graph.table.ui.imex.MappingWrapper;
import com.paterva.maltego.graph.table.ui.imex.SelectableMapping;
import com.paterva.maltego.graph.table.ui.imex.Util;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MappingExporter
extends ConfigExporter {
    public Config getCurrentConfig() {
        Set mappings = MappingRegistry.getDefault().getAll();
        if (!mappings.isEmpty()) {
            return new MappingConfig(Util.createSelectables(mappings));
        }
        return null;
    }

    public int saveConfig(MaltegoArchiveWriter writer, Config config) throws IOException {
        MappingConfig mappingConfig = (MappingConfig)config;
        ArrayList<String> names = new ArrayList<String>();
        for (SelectableMapping selectable : mappingConfig.getSelectedMappings()) {
            if (!selectable.isSelected()) continue;
            TabularGraph mapping = selectable.getMapping();
            String fileName = this.getFileName(mapping, names);
            writer.write((Entry)new MappingEntry(new MappingWrapper(fileName, mapping)));
        }
        return names.size();
    }

    private String getFileName(TabularGraph mapping, List<String> names) {
        String name = mapping.getName();
        String fileName = FileUtilities.replaceIllegalChars((String)name);
        fileName = StringUtilities.createUniqueString(names, (String)fileName);
        names.add(fileName);
        return fileName;
    }
}

