/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.imex;

import com.paterva.maltego.archive.mtz.EntryFactory;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.customicons.imex.CategorizedIcons;
import com.paterva.maltego.customicons.imex.IconMetadata;
import com.paterva.maltego.customicons.imex.IconMetadataEntryFactory;
import com.paterva.maltego.customicons.imex.IconRegistryIconFactory;
import com.paterva.maltego.customicons.imex.Util;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.VirtualIcon;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.IconSize;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class IconImporter {
    public synchronized CategorizedIcons readIcons(MaltegoArchiveReader reader) throws IOException {
        List iconRegistryIcons = reader.readAll((EntryFactory)new IconRegistryIconFactory(), "Graph1");
        List metadata = reader.readAll((EntryFactory)new IconMetadataEntryFactory(), "Graph1");
        return CategorizedIcons.fromList(iconRegistryIcons, metadata);
    }

    public synchronized void apply(IconRegistry registry, CategorizedIcons icons, String hubItem) throws IOException {
        Args.notNull((Object)registry, (String)"registry");
        Args.notNull((Object)icons, (String)"icons");
        List<IconMetadata> metadatas = icons.getMetadatas();
        for (Map.Entry categoryEntry : icons.entrySet()) {
            String category = (String)categoryEntry.getKey();
            for (Map.Entry iconEntry : ((Map)categoryEntry.getValue()).entrySet()) {
                String iconName = (String)iconEntry.getKey();
                Map iconImages = (Map)iconEntry.getValue();
                int iconSizes = iconImages.size();
                if (iconSizes == IconSize.values().length || iconSizes == IconSize.values().length - 1 && iconImages.get(IconSize.MASSIVE) == null) {
                    RegistryIcon icon;
                    LinkedHashSet<String> hubItems = new LinkedHashSet<String>();
                    Optional existingIcon = registry.findRegistryIcon(new VirtualIcon(category, iconName));
                    if (existingIcon.isPresent()) {
                        icon = (RegistryIcon)existingIcon.get();
                        registry.remove(icon);
                        hubItems.addAll(icon.getHubItems());
                    }
                    if (hubItem != null) {
                        hubItems.add(hubItem);
                    }
                    icon = registry.addFromImages(category, iconName, iconImages);
                    registry.setHubItems(icon, hubItems);
                    this.applyMetadata(registry, metadatas, icon);
                    continue;
                }
                Logger.getLogger(IconImporter.class.getName()).log(Level.WARNING, "Missing sizes for icon: {0}", iconEntry.getKey());
            }
        }
    }

    private void applyMetadata(IconRegistry registry, List<IconMetadata> metadatas, RegistryIcon icon) {
        Util.getIconMetadata(metadatas, icon).map(meta -> meta.getAliases()).ifPresent(aliases -> {
            try {
                registry.setAliases(icon, aliases);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }
}

