/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.error.reporting.ui;

import com.paterva.maltego.error.reporting.ui.ProblemDtoBuilder;
import com.paterva.maltego.error.reporting.ui.ProblemReportDialog;
import com.paterva.maltego.util.ui.components.MultiLineLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class ProblemNotificationPanel
extends JPanel {
    private final ProblemDtoBuilder problemBuilder;

    public ProblemNotificationPanel(String summary, final ProblemDtoBuilder problemBuilder) {
        super(new GridBagLayout());
        this.problemBuilder = problemBuilder;
        this.setOpaque(false);
        MultiLineLabel lblMessage = new MultiLineLabel();
        lblMessage.setMaxWidth(500);
        lblMessage.setMaxHeight(Integer.MAX_VALUE);
        lblMessage.setText(summary);
        Color foregroundColor = UIManager.getLookAndFeelDefaults().getColor("Label.darculaMod.label-desired-fg");
        if (foregroundColor != null) {
            lblMessage.setForeground(foregroundColor);
        }
        JButton reportLink = new JButton("<html><a href=\"_blank\">Show and Report Problem");
        reportLink.setFocusable(false);
        reportLink.setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        reportLink.setRolloverEnabled(false);
        reportLink.setBackground(this.getBackground());
        reportLink.setBorderPainted(false);
        reportLink.setFocusPainted(false);
        reportLink.setOpaque(false);
        reportLink.setContentAreaFilled(false);
        reportLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                problemBuilder.userIntervened();
                new ProblemReportDialog(problemBuilder).setVisible(true);
            }
        });
        reportLink.setCursor(Cursor.getPredefinedCursor(12));
        this.add((Component)reportLink, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 3, 0), 0, 0));
        this.add((Component)lblMessage, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 3, 0), 0, 0));
    }

    public ProblemDtoBuilder getProblemBuilder() {
        return this.problemBuilder;
    }
}

