/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.script;

import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import java.util.List;
import java.util.Objects;

public abstract class ReadonlyPart<PartID extends Guid, Part extends MaltegoPart<PartID>> {
    private final GraphID _graphID;
    private final PartID _id;
    private final GraphWrapper _wrapper;
    private final SpecRegistry _registry;

    ReadonlyPart(GraphID graphID, PartID id, GraphWrapper wrapper, SpecRegistry registry) {
        this._graphID = graphID;
        this._id = id;
        this._wrapper = wrapper;
        this._registry = registry;
    }

    public abstract boolean isCollection();

    protected abstract Part getPart();

    protected abstract String getCollectionType();

    protected GraphID getGraphID() {
        return this._graphID;
    }

    protected PartID getPartID() {
        return this._id;
    }

    protected GraphWrapper getWrapper() {
        return this._wrapper;
    }

    protected SpecRegistry getRegistry() {
        return this._registry;
    }

    public String getType() {
        return this.isCollection() ? this.getCollectionType() : this.getPart().getTypeName();
    }

    public String[] getTypes() {
        List types = InheritanceHelper.getInheritanceList((SpecRegistry)this.getRegistry(), (String)this.getType());
        return types.toArray(new String[types.size()]);
    }

    public Object getValue() {
        return this.isCollection() ? null : InheritanceHelper.getValue((SpecRegistry)this.getRegistry(), this.getPart());
    }

    public String[] getPropertyKeys() {
        if (this.isCollection()) {
            return new String[0];
        }
        PropertyDescriptorCollection properties = this.getPart().getProperties();
        String[] propertyKeys = new String[properties.size()];
        int i = 0;
        for (PropertyDescriptor pd : properties) {
            propertyKeys[i] = pd.getName();
            ++i;
        }
        return propertyKeys;
    }

    public Object[] getPropertyValues() {
        if (this.isCollection()) {
            return new Object[0];
        }
        PropertyDescriptorCollection properties = this.getPart().getProperties();
        Object[] propertyValues = new Object[properties.size()];
        int i = 0;
        for (PropertyDescriptor pd : properties) {
            propertyValues[i] = this.getPart().getValue(pd);
            ++i;
        }
        return propertyValues;
    }

    public Object getPropertyValue(String key) {
        if (this.isCollection()) {
            return null;
        }
        Part part = this.getPart();
        PropertyDescriptorCollection properties = part.getProperties();
        PropertyDescriptor property = properties.get(key);
        return property != null ? part.getValue(property) : null;
    }

    public String getNotes() {
        String notes = this.isCollection() ? null : this.getPart().getNotes();
        return this.makeNullEmpty(notes);
    }

    public String[] getDisplayInfoKeys() {
        if (this.isCollection()) {
            return new String[0];
        }
        DisplayInformationCollection displayInfos = this.getPart().getOrCreateDisplayInformation();
        String[] displayInfoKeys = new String[displayInfos.size()];
        int i = 0;
        for (DisplayInformation displayInfo : displayInfos) {
            displayInfoKeys[i] = this.makeNullEmpty(displayInfo.getName());
            ++i;
        }
        return displayInfoKeys;
    }

    public String[] getDisplayInfoValues() {
        if (this.isCollection()) {
            return new String[0];
        }
        DisplayInformationCollection displayInfos = this.getPart().getOrCreateDisplayInformation();
        String[] displayInfoValues = new String[displayInfos.size()];
        int i = 0;
        for (DisplayInformation displayInfo : displayInfos) {
            displayInfoValues[i] = this.makeNullEmpty(displayInfo.getValue());
            ++i;
        }
        return displayInfoValues;
    }

    public int getBookmark() {
        return this.isCollection() ? -1 : this.getPart().getBookmark();
    }

    public String toString() {
        return this.isCollection() ? "Collection" : this.getPart().toString();
    }

    private String makeNullEmpty(String text) {
        return text != null ? text : "";
    }

    public int hashCode() {
        int hash = 5;
        hash = 19 * hash + Objects.hashCode(this._graphID);
        hash = 19 * hash + Objects.hashCode(this._id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReadonlyPart other = (ReadonlyPart)obj;
        if (!Objects.equals(this._graphID, other._graphID)) {
            return false;
        }
        return Objects.equals(this._id, other._id);
    }
}

