/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.actions.AbstractAction;
import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import java.util.HashSet;

public class BookmarkAction
extends AbstractAction {
    public BookmarkAction() {
        this("bookmark");
    }

    protected BookmarkAction(String name) {
        super(name);
    }

    @Override
    public void start(AutomationContext ctx, Payload payload, Action.Callback cb) {
        int bookmark = this.getIndex();
        boolean overwrite = this.isOverwrite();
        HashSet<MaltegoEntity> entities = new HashSet<MaltegoEntity>();
        for (MaltegoEntity entity : payload.getEntities()) {
            if (this.hasBookmark(entity) && !overwrite) continue;
            entities.add(entity);
        }
        if (!entities.isEmpty()) {
            GraphTransactionHelper.doChangeBookmark((GraphID)ctx.getTargetGraphID(), entities, (int)bookmark);
        }
        cb.completed(payload);
    }

    protected int getIndex() {
        int index = (Integer)this.getValueOrProperty("index", 0);
        return BookmarkFactory.getDefault().getValid(Integer.valueOf(index));
    }

    protected boolean isOverwrite() {
        return (Boolean)this.getProperty("overwrite", true);
    }

    private boolean hasBookmark(MaltegoEntity entity) {
        return entity.getBookmark() >= 0;
    }
}

