/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tx.inputs.global.registry;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSettingsLogger;
import com.paterva.maltego.tx.inputs.global.registry.GlobalTransformInput;
import com.paterva.maltego.tx.inputs.global.registry.GlobalTransformInputsRepository;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlobalTransformSettingsLogger
extends TransformSettingsLogger {
    private static final Logger LOG = Logger.getLogger(GlobalTransformSettingsLogger.class.getName());

    protected void logGlobalTransformSettings(TransformDefinition transform, DisplayDescriptorCollection transformProperties) {
        try {
            GlobalTransformInputsRepository globalRepo = GlobalTransformInputsRepository.getDefault();
            DataSource globalSettings = globalRepo.getData();
            if (globalSettings != null) {
                ArrayList<GlobalTransformInput> globalInputs = new ArrayList<GlobalTransformInput>(globalRepo.getAll());
                DisplayDescriptorList descriptors = new DisplayDescriptorList();
                block2: for (DisplayDescriptor transformProperty : transformProperties) {
                    for (GlobalTransformInput globalInput : globalInputs) {
                        TransformPropertyDescriptor globalDescriptor = globalInput.getDescriptor();
                        if (!transformProperty.getName().equals(globalDescriptor.getName())) continue;
                        descriptors.add((DisplayDescriptor)globalDescriptor);
                        continue block2;
                    }
                }
                this.logDataSourceSettings(globalSettings, (DisplayDescriptorCollection)descriptors);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Error retrieving global transform settings: {0}", ex.getMessage());
        }
    }
}

