/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.parts;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.imgfactory.parts.LinkImageFactory;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.util.ImageUtilities;

public class PartImageHelper {
    private static final String COLLECTION_LINK_RESOURCE = "com/paterva/maltego/entity/api/collection_link";

    public static Icon getIcon(GraphID graphID, EntityID entityID, int size, ImageCallback cb) throws GraphStoreException {
        return PartImageHelper.getIcon(graphID, entityID, size, cb, false);
    }

    public static Icon getLargeIcon(GraphID graphID, EntityID entityID, ImageCallback cb) throws GraphStoreException {
        return PartImageHelper.getIcon(graphID, entityID, -1, cb, true);
    }

    private static Icon getIcon(GraphID graphID, EntityID entityID, int size, ImageCallback cb, boolean staticSize) throws GraphStoreException {
        Image image;
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        GraphModelViewMappings mappings = view.getModelViewMappings();
        EntityImageFactory imageFactory = EntityImageFactory.forGraph(graphID);
        if (mappings.isOnlyViewEntity(entityID)) {
            EntityID firstModelEntity = (EntityID)mappings.getModelEntities(entityID).iterator().next();
            String type = view.getModel().getGraphDataStore().getDataStoreReader().getEntityType(firstModelEntity);
            int large = IconSize.LARGE.getSize();
            image = staticSize ? imageFactory.getTypeImage(type, large, large, cb) : imageFactory.getTypeImage(type, size, size, cb);
        } else {
            MaltegoEntity entity = GraphStoreHelper.getEntity((GraphID)graphID, (EntityID)entityID);
            int massive = IconSize.MASSIVE.getSize();
            image = staticSize ? imageFactory.getImageMax(entity, massive, massive, cb) : imageFactory.getImage(entity, size, size, cb);
        }
        return ImageUtils.toIcon((Image)image);
    }

    public static Icon getIcon(GraphID graphID, LinkID linkID, int size) throws GraphStoreException {
        return new ImageIcon(PartImageHelper.getImage(graphID, linkID, size));
    }

    public static Image getImage(GraphID graphID, LinkID linkID, int size) throws GraphStoreException {
        Image image;
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        GraphModelViewMappings mappings = view.getModelViewMappings();
        if (mappings.isOnlyViewLink(linkID)) {
            image = PartImageHelper.getCollectionLinkImage(size);
        } else {
            MaltegoLink modelLink = GraphStoreHelper.getLink((GraphID)graphID, (LinkID)linkID);
            LinkRegistry registry = LinkRegistry.forGraphID((GraphID)graphID);
            MaltegoLinkSpec spec = (MaltegoLinkSpec)registry.get(modelLink.getTypeName());
            image = LinkImageFactory.getImage(spec, size);
        }
        return image;
    }

    public static Image getCollectionLinkImage(int size) {
        String iconResource = COLLECTION_LINK_RESOURCE;
        if (size > 48) {
            iconResource = iconResource + IconSize.MASSIVE.getSize();
        } else if (size > 32) {
            iconResource = iconResource + IconSize.LARGE.getSize();
        } else if (size > 24) {
            iconResource = iconResource + IconSize.MEDIUM.getSize();
        } else if (size > 16) {
            iconResource = iconResource + IconSize.SMALL.getSize();
        }
        iconResource = iconResource + ".png";
        return ImageUtilities.loadImage((String)iconResource);
    }
}

