/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativeimage.hosted;

import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class RuntimeClassInitialization {
    private static final String MESSAGE = "from feature ";

    public static void initializeAtRunTime(Class<?> ... classes) {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        for (Class<?> aClass : classes) {
            ImageSingletons.lookup(RuntimeClassInitializationSupport.class).initializeAtRunTime(aClass, MESSAGE + RuntimeClassInitialization.getCaller(stacktrace));
        }
    }

    public static void initializeAtBuildTime(Class<?> ... classes) {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        for (Class<?> aClass : classes) {
            ImageSingletons.lookup(RuntimeClassInitializationSupport.class).initializeAtBuildTime(aClass, MESSAGE + RuntimeClassInitialization.getCaller(stacktrace));
        }
    }

    public static void initializeAtRunTime(String ... packages) {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        for (String aPackage : packages) {
            ImageSingletons.lookup(RuntimeClassInitializationSupport.class).initializeAtRunTime(aPackage, MESSAGE + RuntimeClassInitialization.getCaller(stacktrace));
        }
    }

    public static void initializeAtBuildTime(String ... packages) {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        for (String aPackage : packages) {
            ImageSingletons.lookup(RuntimeClassInitializationSupport.class).initializeAtBuildTime(aPackage, MESSAGE + RuntimeClassInitialization.getCaller(stacktrace));
        }
    }

    private static String getCaller(StackTraceElement[] stackTrace) {
        StackTraceElement e = stackTrace[2];
        return e.getClassName() + "." + e.getMethodName();
    }

    private RuntimeClassInitialization() {
    }
}

