/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.guided.tour.ui;

import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class GuidedTourUtil {
    static final Color TRANSLUCENT_COLOR = new Color(0, 0, 0, 128);

    private GuidedTourUtil() {
    }

    static Supplier<Rectangle> createTopComponentFocusArea(TopComponent focussedTC) {
        return () -> {
            Point converted = WindowUtil.locationRelativeToGlassPane((Component)focussedTC);
            converted.y -= 25;
            Dimension size = focussedTC.getSize();
            size.height += 25;
            return new Rectangle(converted, size);
        };
    }

    static Consumer<Graphics2D> createTopComponentFocusAreaPainter(TopComponent focussedTC) {
        return g2d -> {
            Point converted = WindowUtil.locationRelativeToGlassPane((Component)focussedTC);
            converted.y -= 25;
            Dimension size = focussedTC.getSize();
            size.height += 25;
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.setColor(Color.WHITE);
            g2d.drawRect(converted.x, converted.y, size.width, size.height);
        };
    }

    static Consumer<Graphics2D> createChangeEntityValuePainter(TopComponent focussedTC) {
        return GuidedTourUtil.createPainter(focussedTC, GuidedTourUtil.class.getResource("/com/maltego/guided/tour/ui/img_change-entity-value.png"));
    }

    static Consumer<Graphics2D> createEntityPainter(TopComponent focussedTC) {
        return GuidedTourUtil.createPainter(focussedTC, GuidedTourUtil.class.getResource("/com/maltego/guided/tour/ui/img_entity.png"));
    }

    private static Consumer<Graphics2D> createPainter(TopComponent focussedTC, URL resource) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(resource);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        BufferedImage entityToDraw = bufferedImage;
        return g2d -> {
            if (entityToDraw != null) {
                Point converted = WindowUtil.locationRelativeToGlassPane((Component)focussedTC);
                int entityX = converted.x + 300;
                if (focussedTC.getWidth() < 500) {
                    entityX = converted.x + 120;
                }
                int entityY = converted.y + 100;
                if (focussedTC.getHeight() < 500) {
                    entityY = converted.y + 30;
                }
                g2d.drawImage(entityToDraw, entityX, entityY, null);
                converted.y -= 25;
                Dimension size = focussedTC.getSize();
                size.height += 25;
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.setColor(Color.WHITE);
                g2d.drawRect(converted.x, converted.y, size.width, size.height);
            }
        };
    }

    static Consumer<Graphics2D> createTransformsPainter(TopComponent focussedTC) {
        BufferedImage entityImage = null;
        BufferedImage transformsImage = null;
        try {
            entityImage = ImageIO.read(GuidedTourUtil.class.getResource("/com/maltego/guided/tour/ui/img_entity.png"));
            transformsImage = ImageIO.read(GuidedTourUtil.class.getResource("/com/maltego/guided/tour/ui/img_transforms.png"));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        BufferedImage entityToDraw = entityImage;
        BufferedImage transformsToDraw = transformsImage;
        return g2d -> {
            Point converted = WindowUtil.locationRelativeToGlassPane((Component)focussedTC);
            if (entityToDraw != null && transformsToDraw != null) {
                int entityX = converted.x + 300;
                if (focussedTC.getWidth() < 500) {
                    entityX = converted.x + 120;
                }
                int entityY = converted.y + 100;
                if (focussedTC.getHeight() < 500) {
                    entityY = converted.y + 30;
                }
                int transformsX = entityX + entityToDraw.getWidth() / 2;
                int transformsY = entityY + entityToDraw.getHeight() / 2;
                g2d.drawImage(entityToDraw, entityX, entityY, null);
                g2d.drawImage(transformsToDraw, transformsX, transformsY, null);
                g2d.setColor(TRANSLUCENT_COLOR);
                Area area = new Area(new Rectangle(entityX, entityY, entityToDraw.getWidth(), entityToDraw.getHeight()));
                area.subtract(new Area(new Rectangle(transformsX, transformsY, transformsToDraw.getWidth(), transformsToDraw.getHeight())));
                g2d.fill(area);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.setColor(Color.WHITE);
                g2d.drawRect(transformsX, transformsY, transformsToDraw.getWidth(), transformsToDraw.getHeight());
            }
        };
    }

    static Consumer<Graphics2D> createRunTransformPainter(TopComponent focussedTC) {
        BufferedImage entityImage = null;
        BufferedImage transformsImage = null;
        try {
            entityImage = ImageIO.read(GuidedTourUtil.class.getResource("/com/maltego/guided/tour/ui/img_entity.png"));
            transformsImage = ImageIO.read(GuidedTourUtil.class.getResource("/com/maltego/guided/tour/ui/img_transforms.png"));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        BufferedImage entityToDraw = entityImage;
        BufferedImage transformsToDraw = transformsImage;
        return g2d -> {
            Point converted = WindowUtil.locationRelativeToGlassPane((Component)focussedTC);
            if (entityToDraw != null && transformsToDraw != null) {
                int entityX = converted.x + 300;
                if (focussedTC.getWidth() < 500) {
                    entityX = converted.x + 120;
                }
                int entityY = converted.y + 100;
                if (focussedTC.getHeight() < 500) {
                    entityY = converted.y + 30;
                }
                int transformsX = entityX + entityToDraw.getWidth() / 2;
                int transformsY = entityY + entityToDraw.getHeight() / 2;
                int focusX = entityX + 72;
                int focusY = entityY + 342;
                g2d.drawImage(entityToDraw, entityX, entityY, null);
                g2d.drawImage(transformsToDraw, transformsX, transformsY, null);
                g2d.setColor(TRANSLUCENT_COLOR);
                Area area = new Area(new Rectangle(entityX, entityY, entityToDraw.getWidth(), entityToDraw.getHeight()));
                area.add(new Area(new Rectangle(transformsX, transformsY, transformsToDraw.getWidth(), transformsToDraw.getHeight())));
                area.subtract(new Area(new Rectangle(focusX, focusY, 297, 27)));
                g2d.fill(area);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.setColor(Color.WHITE);
                g2d.drawRect(focusX, focusY, 297, 27);
            }
        };
    }
}

