/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora.structure;

import com.paterva.graph.store.pandora.data.DataCache;
import com.paterva.graph.store.pandora.parts.PandoraPartsReader;
import com.paterva.graph.store.pandora.structure.StructureArtifactUtils;
import com.paterva.graph.store.pandora.structure.StructureCache;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.cache.CachedItems;
import com.paterva.maltego.graph.cache.FifoCache;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.pinkmatter.pandora.Artifact;
import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraQueryResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PandoraGraphStructureReader
extends PandoraPartsReader
implements GraphStructureReader {
    private final StructureCache _cache;
    private final DataCache _dataCache;

    PandoraGraphStructureReader(GraphID id, StructureCache cache, DataCache dataCache) {
        super(id);
        this._cache = cache;
        this._dataCache = dataCache;
    }

    public boolean exists(EntityID entityID) throws GraphStoreException {
        try {
            if (this._dataCache.getEntityCache().contains((Object)entityID)) {
                return true;
            }
            return this.getEntitySearch().query().keys(new long[]{entityID.getValue()}).count() == 1L;
        }
        catch (Exception ex) {
            throw new GraphStoreException("Entity: " + entityID, (Throwable)ex);
        }
    }

    public boolean exists(LinkID linkID) throws GraphStoreException {
        try {
            return this.getLinkSearch().query().keys(new long[]{linkID.getValue()}).count() == 1L;
        }
        catch (Exception ex) {
            throw new GraphStoreException("Link: " + linkID, (Throwable)ex);
        }
    }

    public int getEntityCount() throws GraphStoreException {
        Integer count = this._cache.getEntityCount();
        if (count == null) {
            try {
                count = (int)this.getEntitySearch().query().count();
                this._cache.setEntityCount(count);
            }
            catch (Exception ex) {
                throw new GraphStoreException((Throwable)ex);
            }
        }
        return count;
    }

    public int getLinkCount() throws GraphStoreException {
        try {
            return (int)this.getLinkSearch().query().count();
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Set<EntityID> getExistingEntities(Collection<EntityID> entityIDs) throws GraphStoreException {
        if (entityIDs.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        try {
            if (this._dataCache.getEntityCache().containsAll(entityIDs)) {
                return new HashSet<EntityID>(entityIDs);
            }
            long[] keys = this.getEntitySearch().query().keys(this.toLongIDs(entityIDs)).includeKeyOnly().list().getKeys();
            HashSet<EntityID> existingIDs = new HashSet<EntityID>(keys.length);
            for (long key : keys) {
                existingIDs.add(EntityID.create((long)key));
            }
            return existingIDs;
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Set<LinkID> getExistingLinks(Collection<LinkID> linkIDs) throws GraphStoreException {
        if (linkIDs.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        try {
            long[] keys = this.getLinkSearch().query().keys(this.toLongIDs(linkIDs)).includeKeyOnly().list().getKeys();
            HashSet<LinkID> existingIDs = new HashSet<LinkID>(keys.length);
            for (long key : keys) {
                existingIDs.add(LinkID.create((long)key));
            }
            return existingIDs;
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Set<EntityID> getEntities() throws GraphStoreException {
        try {
            long[] keys = this.getEntitySearch().query().includeKeyOnly().list().getKeys();
            HashSet<EntityID> entityIDs = new HashSet<EntityID>(keys.length);
            for (long key : keys) {
                entityIDs.add(EntityID.create((long)key));
            }
            return entityIDs;
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Set<LinkID> getLinks() throws GraphStoreException {
        try {
            long[] keys = this.getLinkSearch().query().includeKeyOnly().list().getKeys();
            HashSet<LinkID> linkIDs = new HashSet<LinkID>(keys.length);
            for (long key : keys) {
                linkIDs.add(LinkID.create((long)key));
            }
            return linkIDs;
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Map<LinkID, LinkEntityIDs> getEntities(Collection<LinkID> linkIDs) throws GraphStoreException {
        try {
            CachedItems cached = this._cache.getLinkEntities().get(linkIDs);
            Map entityIDs = cached.getItems();
            Set missedKeys = cached.getMissedKeys();
            if (!missedKeys.isEmpty()) {
                PandoraQueryResult result = this.getLinkSearch().query().keys(this.toLongIDs(missedKeys)).list();
                for (Artifact artifact : result) {
                    LinkID linkID = LinkID.create((long)artifact.getKey());
                    EntityID sourceID = StructureArtifactUtils.getSource(artifact);
                    EntityID targetID = StructureArtifactUtils.getTarget(artifact);
                    LinkEntityIDs linkEntityIDs = new LinkEntityIDs(sourceID, targetID);
                    this._cache.getLinkEntities().put((Object)linkID, (Object)linkEntityIDs);
                    entityIDs.put(linkID, linkEntityIDs);
                }
            }
            return entityIDs;
        }
        catch (PandoraException ex) {
            throw new GraphStoreException("Error getting entities for: " + linkIDs, (Throwable)ex);
        }
    }

    public LinkEntityIDs getEntities(LinkID linkID) throws GraphStoreException {
        LinkEntityIDs entityIDs = (LinkEntityIDs)this._cache.getLinkEntities().get((Object)linkID);
        if (entityIDs == null) {
            try {
                Artifact artifact = this.getLinkSearch().getArtifact(linkID.getValue());
                EntityID sourceID = StructureArtifactUtils.getSource(artifact);
                EntityID targetID = StructureArtifactUtils.getTarget(artifact);
                entityIDs = new LinkEntityIDs(sourceID, targetID);
                this._cache.getLinkEntities().put((Object)linkID, (Object)entityIDs);
            }
            catch (Exception ex) {
                throw new GraphStoreException("Link: " + linkID, (Throwable)ex);
            }
        }
        return entityIDs;
    }

    public Map<LinkID, EntityID> getSources(Collection<LinkID> linkIDs) throws GraphStoreException {
        Map<LinkID, LinkEntityIDs> entities = this.getEntities(linkIDs);
        HashMap<LinkID, EntityID> sourceIDs = new HashMap<LinkID, EntityID>(linkIDs.size());
        for (Map.Entry<LinkID, LinkEntityIDs> entry : entities.entrySet()) {
            LinkID linkID = entry.getKey();
            LinkEntityIDs linkEntityIDs = entry.getValue();
            sourceIDs.put(linkID, linkEntityIDs.getSourceID());
        }
        return sourceIDs;
    }

    public EntityID getSource(LinkID linkID) throws GraphStoreException {
        return this.getEntities(linkID).getSourceID();
    }

    public Map<LinkID, EntityID> getTargets(Collection<LinkID> linkIDs) throws GraphStoreException {
        Map<LinkID, LinkEntityIDs> entities = this.getEntities(linkIDs);
        HashMap<LinkID, EntityID> targetIDs = new HashMap<LinkID, EntityID>(linkIDs.size());
        for (Map.Entry<LinkID, LinkEntityIDs> entry : entities.entrySet()) {
            LinkID linkID = entry.getKey();
            LinkEntityIDs linkEntityIDs = entry.getValue();
            targetIDs.put(linkID, linkEntityIDs.getTargetID());
        }
        return targetIDs;
    }

    public EntityID getTarget(LinkID linkID) throws GraphStoreException {
        return this.getEntities(linkID).getTargetID();
    }

    public Set<LinkID> getLinksBetween(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashSet<LinkID> links = new HashSet<LinkID>();
        Map<EntityID, Set<LinkID>> incoming = this.getIncoming(entityIDs);
        HashSet<LinkID> allIncomingLinks = new HashSet<LinkID>();
        for (Map.Entry<EntityID, Set<LinkID>> entry : incoming.entrySet()) {
            allIncomingLinks.addAll((Collection<LinkID>)entry.getValue());
        }
        Map<LinkID, EntityID> sourceEntities = this.getSources(allIncomingLinks);
        for (Map.Entry<LinkID, EntityID> entry : sourceEntities.entrySet()) {
            LinkID incomingLink = entry.getKey();
            EntityID sourceEntity = entry.getValue();
            if (!entityIDs.contains(sourceEntity)) continue;
            links.add(incomingLink);
        }
        return links;
    }

    public Set<LinkID> getLinks(Collection<EntityID> entityIDs) throws GraphStoreException {
        Map<EntityID, Set<LinkID>> linksMap = this.getLinksMap(entityIDs, "in", "out");
        HashSet<LinkID> linkIDs = new HashSet<LinkID>();
        for (Map.Entry<EntityID, Set<LinkID>> entry : linksMap.entrySet()) {
            linkIDs.addAll((Collection<LinkID>)entry.getValue());
        }
        return linkIDs;
    }

    public Map<EntityID, Set<LinkID>> getLinksMap(Collection<EntityID> entityIDs) throws GraphStoreException {
        return this.getLinksMap(entityIDs, "in", "out");
    }

    public Set<LinkID> getLinks(EntityID entityID) throws GraphStoreException {
        Set<LinkID> links = this.getLinksMap(Collections.singleton(entityID), "in", "out").get(entityID);
        return links == null ? Collections.EMPTY_SET : links;
    }

    public Map<EntityID, Set<LinkID>> getOutgoing(Collection<EntityID> entityIDs) throws GraphStoreException {
        return this.getLinksMap(entityIDs, "out");
    }

    public Set<LinkID> getOutgoing(EntityID entityID) throws GraphStoreException {
        return this.getLinks(entityID, false);
    }

    public Map<EntityID, Set<LinkID>> getIncoming(Collection<EntityID> entityIDs) throws GraphStoreException {
        return this.getLinksMap(entityIDs, "in");
    }

    public Set<LinkID> getIncoming(EntityID entityID) throws GraphStoreException {
        return this.getLinks(entityID, true);
    }

    public int getLinkCount(EntityID entity) throws GraphStoreException {
        return this.getLinkCount(entity, "in", "out");
    }

    public int getIncomingLinkCount(EntityID entity) throws GraphStoreException {
        return this.getLinkCount(entity, "in");
    }

    public int getOutgoingLinkCount(EntityID entity) throws GraphStoreException {
        return this.getLinkCount(entity, "out");
    }

    public boolean hasLinks(EntityID entity) throws GraphStoreException {
        return this.getLinkCount(entity) != 0;
    }

    private int getLinkCount(EntityID entityID, String ... directions) throws GraphStoreException {
        try {
            int linkCount = 0;
            for (String direction : directions) {
                String entityLocation = "in".equals(direction) ? "target" : "source";
                linkCount = (int)((long)linkCount + this.getLinkSearch().query().includeKeyOnly().filterContains(entityLocation, (Object[])new Long[]{entityID.getValue()}).count());
            }
            return linkCount;
        }
        catch (Exception ex) {
            throw new GraphStoreException("Entity: " + entityID, (Throwable)ex);
        }
    }

    private Map<EntityID, Set<LinkID>> createLinkMap(Collection<EntityID> entityIDs) {
        HashMap<EntityID, Set<LinkID>> links = new HashMap<EntityID, Set<LinkID>>(entityIDs.size());
        for (EntityID entityID : entityIDs) {
            links.put(entityID, new HashSet());
        }
        return links;
    }

    private Set<LinkID> getLinks(EntityID entityID, boolean incoming) throws GraphStoreException {
        FifoCache<EntityID, Set<LinkID>> linkCache = incoming ? this._cache.getIncomingLinks() : this._cache.getOutgoingLinks();
        String entityLocation = incoming ? "target" : "source";
        HashSet<LinkID> links = (HashSet<LinkID>)linkCache.get((Object)entityID);
        if (links == null) {
            try {
                links = new HashSet<LinkID>();
                PandoraQueryResult result = this.getLinkSearch().query().filterContainsAny(entityLocation, (Object[])new Long[]{entityID.getValue()}).list();
                if (!result.isEmpty()) {
                    for (Artifact artifact : result) {
                        LinkID link = LinkID.create((long)artifact.getKey());
                        links.add(link);
                    }
                }
                linkCache.put((Object)entityID, links);
            }
            catch (PandoraException ex) {
                throw new GraphStoreException("Entity: " + entityID, (Throwable)ex);
            }
        }
        return links;
    }

    private Map<EntityID, Set<LinkID>> getLinksMap(Collection<EntityID> entityIDs, String ... directions) throws GraphStoreException {
        if (entityIDs.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        try {
            Map<EntityID, Set<LinkID>> links = null;
            links = this.createLinkMap(entityIDs);
            for (String direction : directions) {
                boolean incoming = "in".equals(direction);
                FifoCache<EntityID, Set<LinkID>> cache = incoming ? this._cache.getIncomingLinks() : this._cache.getOutgoingLinks();
                CachedItems cached = cache.get(entityIDs);
                Map items = cached.getItems();
                for (Map.Entry entry : items.entrySet()) {
                    EntityID id = (EntityID)entry.getKey();
                    Set cachedLinks = (Set)entry.getValue();
                    links.get(id).addAll(cachedLinks);
                }
                Set missedKeys = cached.getMissedKeys();
                if (missedKeys.isEmpty()) continue;
                Object[] keyTargets = this.toLongObjIDs(missedKeys);
                String entityLocation = incoming ? "target" : "source";
                PandoraQueryResult result = this.getLinkSearch().query().filterContainsAny(entityLocation, keyTargets).list();
                Map<EntityID, Set<LinkID>> resultLinks = this.createLinkMap(missedKeys);
                for (Artifact artifact : result) {
                    EntityID ent = EntityID.create((long)((Long)artifact.get(entityLocation)));
                    LinkID link = LinkID.create((long)artifact.getKey());
                    links.get(ent).add(link);
                    resultLinks.get(ent).add(link);
                }
                for (EntityID id : missedKeys) {
                    cache.put((Object)id, resultLinks.get(id));
                }
            }
            return links == null ? Collections.EMPTY_MAP : links;
        }
        catch (Exception ex) {
            throw new GraphStoreException("Entities: " + entityIDs, (Throwable)ex);
        }
    }

    public Map<EntityID, Set<EntityID>> getParents(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashMap<EntityID, Set<EntityID>> parents = new HashMap<EntityID, Set<EntityID>>(entityIDs.size());
        for (EntityID entityID : entityIDs) {
            parents.put(entityID, this.getParents(entityID));
        }
        return parents;
    }

    public Set<EntityID> getParents(EntityID entityID) throws GraphStoreException {
        HashSet<EntityID> parents = new HashSet<EntityID>();
        Set<LinkID> incoming = this.getIncoming(entityID);
        for (LinkID linkID : incoming) {
            LinkEntityIDs entityIDs = this.getEntities(linkID);
            if (!entityIDs.getTargetID().equals((Object)entityID)) continue;
            parents.add(entityIDs.getSourceID());
        }
        return parents;
    }

    public Map<EntityID, Set<EntityID>> getChildren(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashMap<EntityID, Set<EntityID>> children = new HashMap<EntityID, Set<EntityID>>(entityIDs.size());
        for (EntityID entityID : entityIDs) {
            children.put(entityID, this.getChildren(entityID));
        }
        return children;
    }

    public Set<EntityID> getChildren(EntityID entityID) throws GraphStoreException {
        HashSet<EntityID> children = new HashSet<EntityID>();
        Set<LinkID> outgoing = this.getOutgoing(entityID);
        for (LinkID linkID : outgoing) {
            LinkEntityIDs entityIDs = this.getEntities(linkID);
            if (!entityIDs.getSourceID().equals((Object)entityID)) continue;
            children.add(entityIDs.getTargetID());
        }
        return children;
    }

    public Map<EntityID, Boolean> getPinned(Collection<EntityID> entityIDs) throws GraphStoreException {
        if (entityIDs.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        try {
            CachedItems cached = this.getPinCache().get(entityIDs);
            Map pinnedMap = cached.getItems();
            Set missedKeys = cached.getMissedKeys();
            if (!missedKeys.isEmpty()) {
                long[] keySubSet = this.toLongIDs(missedKeys);
                PandoraQueryResult result = this.getEntitySearch().query().keys(keySubSet).list();
                for (Artifact artifact : result) {
                    EntityID entityID = EntityID.create((long)artifact.getKey());
                    Boolean pinned = (Boolean)artifact.get("pinned");
                    if (pinned == null) {
                        pinned = false;
                    }
                    this.getPinCache().put((Object)entityID, (Object)pinned);
                    pinnedMap.put(entityID, pinned);
                }
            }
            return pinnedMap;
        }
        catch (Exception ex) {
            throw new GraphStoreException("Entities: " + entityIDs, (Throwable)ex);
        }
    }

    public boolean getPinned(EntityID entityID) throws GraphStoreException {
        return this.getPinned(Collections.singleton(entityID)).get(entityID);
    }

    public Set<EntityID> getAllEntitiesWithoutLinks() throws GraphStoreException {
        HashSet<EntityID> noLinkEntities = new HashSet<EntityID>();
        Map<EntityID, Set<LinkID>> linksMap = this.getLinksMap(this.getEntities());
        for (Map.Entry<EntityID, Set<LinkID>> entry : linksMap.entrySet()) {
            Set<LinkID> links = entry.getValue();
            if (links != null && !links.isEmpty()) continue;
            noLinkEntities.add(entry.getKey());
        }
        return noLinkEntities;
    }

    public Set<EntityID> getAllSingleLinkChildren(EntityID entityID) throws GraphStoreException {
        HashSet<EntityID> singleLinkChildren = new HashSet<EntityID>();
        for (EntityID childID : this.getChildren(entityID)) {
            Set<LinkID> links = this.getLinks(childID);
            if (links == null || links.size() != 1) continue;
            singleLinkChildren.add(childID);
        }
        return singleLinkChildren;
    }

    private FifoCache<EntityID, Boolean> getPinCache() {
        return this._cache.getPinCache();
    }
}

