/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard.offline;

import com.paterva.maltego.util.ui.dialog.ChangeEventPropagator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class FileBrowsePanel
extends JPanel {
    private final ChangeEventPropagator _changeSupport = new ChangeEventPropagator((Object)this);
    private JButton _browseButton;
    private JTextField _fileTextField;

    public FileBrowsePanel() {
        this.initComponents();
        this._fileTextField.getDocument().addDocumentListener((DocumentListener)this._changeSupport);
    }

    public String getFile() {
        return this._fileTextField.getText();
    }

    public void setFile(String licenseFile) {
        this._fileTextField.setText(licenseFile);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._fileTextField.setEnabled(enabled);
        this._browseButton.setEnabled(enabled);
    }

    public void addChangeListener(ChangeListener cl) {
        this._changeSupport.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this._changeSupport.removeChangeListener(cl);
    }

    private void initComponents() {
        this._fileTextField = new JTextField();
        this._browseButton = new JButton();
        this.setLayout(new BorderLayout(6, 0));
        this._fileTextField.setText(NbBundle.getMessage(FileBrowsePanel.class, (String)"FileBrowsePanel._fileTextField.text"));
        this.add((Component)this._fileTextField, "Center");
        Mnemonics.setLocalizedText((AbstractButton)this._browseButton, (String)NbBundle.getMessage(FileBrowsePanel.class, (String)"FileBrowsePanel._browseButton.text"));
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileBrowsePanel.this._browseButtonActionPerformed(evt);
            }
        });
        this.add((Component)this._browseButton, "After");
    }

    private void _browseButtonActionPerformed(ActionEvent evt) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new FileNameExtensionFilter("License File", "lic"));
            fileChooser.setCurrentDirectory(new File(NbPreferences.root().get("browseDir", "")));
            if (0 == fileChooser.showOpenDialog(this)) {
                File selectedFile = fileChooser.getSelectedFile();
                this._fileTextField.setText(selectedFile.getAbsolutePath());
                NbPreferences.root().put("browseDir", fileChooser.getCurrentDirectory().getAbsolutePath());
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

