/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard.offline;

import com.paterva.maltego.licensing.json.rest.JsonLicenseRestRequests;
import com.paterva.maltego.licensing.json.serialize.JsonLicenseResponse;
import com.paterva.maltego.licensing.rest.A;
import com.paterva.maltego.licensing.serialize.H;
import com.paterva.maltego.licensing.ui.wizard.offline.OfflineActivationControl;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OfflineActivationController
extends ValidatingController<OfflineActivationControl> {
    private Boolean isMaltegoIdActivation;
    private H blobAndEula;
    private JsonLicenseResponse maltegoIdActivationResponse;

    public OfflineActivationController() {
        this.setName(NbBundle.getMessage(OfflineActivationControl.class, (String)"OfflineActivationControler.name.licenseKey"));
        this.setDescription(NbBundle.getMessage(OfflineActivationControl.class, (String)"OfflineActivationControler.description.licenseKey"));
    }

    protected OfflineActivationControl createComponent() {
        OfflineActivationControl c = new OfflineActivationControl();
        c.addChangeListener(this.changeListener());
        return c;
    }

    protected String getFirstError(OfflineActivationControl component) {
        String error = null;
        String licensePath = component.getLicenseFile();
        if (StringUtilities.isNullOrEmpty((String)licensePath)) {
            error = "Please specify a license file.";
        } else {
            File licenseFile = new File(licensePath);
            if (!licenseFile.isFile()) {
                error = " The specified license file is not a file.";
            } else {
                try {
                    String response = new String(Files.readAllBytes(licenseFile.toPath()), StandardCharsets.UTF_8);
                    if (Boolean.TRUE.equals(this.isMaltegoIdActivation)) {
                        this.maltegoIdActivationResponse = JsonLicenseRestRequests.activateMaltegoIDOffline((String)response);
                    } else {
                        this.blobAndEula = A.D((String)response);
                    }
                }
                catch (Exception ex) {
                    NormalException.logStackTrace((Throwable)ex);
                    error = "Cannot read license file";
                }
            }
        }
        return error;
    }

    protected void readSettings(WizardDescriptor settings) {
        String requestBlob;
        this.isMaltegoIdActivation = (Boolean)settings.getProperty("licensing.gateway-maltego-id");
        String licenseKey = (String)settings.getProperty("licensing.key");
        String licenseFile = (String)settings.getProperty("licensing.file");
        if (Boolean.TRUE.equals(this.isMaltegoIdActivation)) {
            this.setName(NbBundle.getMessage(OfflineActivationControl.class, (String)"OfflineActivationControler.name.maltegoId"));
            this.setDescription(NbBundle.getMessage(OfflineActivationControl.class, (String)"OfflineActivationControler.description.maltegoId"));
            ((OfflineActivationControl)this.component()).setActivationForMaltegoID(true);
            try {
                requestBlob = JsonLicenseRestRequests.getMaltegoIDOfflineActivateBlob();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                requestBlob = "An error occurred: " + ex.getMessage();
            }
        } else {
            try {
                requestBlob = A.C((String)licenseKey);
            }
            catch (GeneralSecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                requestBlob = "An error occurred: " + ex.getMessage();
            }
        }
        ((OfflineActivationControl)this.component()).setLicenseRequest(requestBlob);
        ((OfflineActivationControl)this.component()).setLicenseFile(licenseFile != null ? licenseFile : "");
    }

    protected void storeSettings(WizardDescriptor settings) {
        settings.putProperty("licensing.file", (Object)((OfflineActivationControl)this.component()).getLicenseFile());
        if (this.blobAndEula != null) {
            settings.putProperty("licensing.blob", (Object)this.blobAndEula.B());
            settings.putProperty("licensing.eula", this.blobAndEula.A().orElse(null));
        }
        if (this.isMaltegoIdActivation.booleanValue()) {
            settings.putProperty("licensing.activation.maltegoId", (Object)this.maltegoIdActivationResponse);
        }
    }
}

