/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.tregex.parser.RegexParser;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import java.util.function.Function;

public final class RegexParserGlobals {
    final Group wordBoundarySubstituion;
    final Group nonWordBoundarySubstitution;
    final Group unicodeIgnoreCaseWordBoundarySubstitution;
    final Group unicodeIgnoreCaseNonWordBoundarySubsitution;
    final Group multiLineCaretSubstitution;
    final Group multiLineDollarSubsitution;
    final Group noLeadSurrogateBehind;
    final Group noTrailSurrogateAhead;

    public RegexParserGlobals(RegexLanguage language) {
        String wordBoundarySrc = "(?:^|(?<=\\W))(?=\\w)|(?<=\\w)(?:(?=\\W)|$)";
        String nonWordBoundarySrc = "(?:^|(?<=\\W))(?:(?=\\W)|$)|(?<=\\w)(?=\\w)";
        this.wordBoundarySubstituion = RegexParser.parseRootLess(language, "(?:^|(?<=\\W))(?=\\w)|(?<=\\w)(?:(?=\\W)|$)");
        this.nonWordBoundarySubstitution = RegexParser.parseRootLess(language, "(?:^|(?<=\\W))(?:(?=\\W)|$)|(?<=\\w)(?=\\w)");
        Function<String, String> includeExtraCases = s -> s.replace("\\w", "[\\w\\u017F\\u212A]").replace("\\W", "[^\\w\\u017F\\u212A]");
        this.unicodeIgnoreCaseWordBoundarySubstitution = RegexParser.parseRootLess(language, includeExtraCases.apply("(?:^|(?<=\\W))(?=\\w)|(?<=\\w)(?:(?=\\W)|$)"));
        this.unicodeIgnoreCaseNonWordBoundarySubsitution = RegexParser.parseRootLess(language, includeExtraCases.apply("(?:^|(?<=\\W))(?:(?=\\W)|$)|(?<=\\w)(?=\\w)"));
        this.multiLineCaretSubstitution = RegexParser.parseRootLess(language, "(?:^|(?<=[\\r\\n\\u2028\\u2029]))");
        this.multiLineDollarSubsitution = RegexParser.parseRootLess(language, "(?:$|(?=[\\r\\n\\u2028\\u2029]))");
        this.noLeadSurrogateBehind = RegexParser.parseRootLess(language, "(?:^|(?<=[^\\uD800-\\uDBFF]))");
        this.noTrailSurrogateAhead = RegexParser.parseRootLess(language, "(?:$|(?=[^\\uDC00-\\uDFFF]))");
    }
}

