/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.tregex.parser.flavors.RubyCaseFoldingData;
import com.oracle.truffle.regex.tregex.parser.flavors.RubyCaseUnfoldingTrie;
import com.oracle.truffle.regex.tregex.parser.flavors.RubyFlavorProcessor;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RubyCaseFolding {
    public static String caseFoldUnfoldString(int[] codepoints, CodePointSet encodingRange) {
        return RubyCaseFolding.caseFoldUnfoldString(codepoints, encodingRange, false);
    }

    public static String caseFoldUnfoldString(int[] codepoints, CodePointSet encodingRange, boolean dropAsciiOnStart) {
        List<Integer> caseFolded = RubyCaseFolding.caseFold(codepoints);
        List<RubyCaseUnfoldingTrie.Unfolding> unfoldings = RubyCaseUnfoldingTrie.findUnfoldings(caseFolded);
        unfoldings = unfoldings.stream().filter(u -> encodingRange.contains(u.getCodepoint())).collect(Collectors.toList());
        StringBuilder out = new StringBuilder();
        out.append("(?:");
        int start = 0;
        int end = 0;
        int unfoldingsStartIndex = 0;
        int unfoldingsEndIndex = 0;
        for (int i = 0; i < unfoldings.size(); ++i) {
            RubyCaseUnfoldingTrie.Unfolding unfolding = unfoldings.get(i);
            if (unfolding.getStart() >= end) {
                RubyCaseFolding.unfoldSegment(out, caseFolded, unfoldings.subList(unfoldingsStartIndex, unfoldingsEndIndex), start, end, 0, dropAsciiOnStart);
                if (unfolding.getStart() > end) {
                    if (dropAsciiOnStart && end == 0 && RubyFlavorProcessor.isAscii(caseFolded.get(end))) {
                        return "[]";
                    }
                    RubyCaseFolding.emitString(out, caseFolded.subList(end, unfolding.getStart()));
                }
                start = unfolding.getStart();
                unfoldingsStartIndex = i;
            }
            end = Math.max(end, unfolding.getEnd());
            unfoldingsEndIndex = i + 1;
        }
        RubyCaseFolding.unfoldSegment(out, caseFolded, unfoldings.subList(unfoldingsStartIndex, unfoldingsEndIndex), start, end, 0, dropAsciiOnStart);
        if (end < caseFolded.size()) {
            if (dropAsciiOnStart && end == 0 && RubyFlavorProcessor.isAscii(caseFolded.get(end))) {
                return "[]";
            }
            RubyCaseFolding.emitString(out, caseFolded.subList(end, caseFolded.size()));
        }
        out.append(')');
        return out.toString();
    }

    private static List<Integer> caseFold(int[] codepoints) {
        ArrayList<Integer> caseFolded = new ArrayList<Integer>();
        for (int codepoint : codepoints) {
            if (RubyCaseFoldingData.CASE_FOLD.containsKey(codepoint)) {
                for (int caseFoldedCodepoint : (int[])RubyCaseFoldingData.CASE_FOLD.get(codepoint)) {
                    caseFolded.add(caseFoldedCodepoint);
                }
                continue;
            }
            caseFolded.add(codepoint);
        }
        return caseFolded;
    }

    private static void emitChar(StringBuilder out, int codepoint, boolean inCharClass) {
        TBitSet syntaxChars;
        TBitSet tBitSet = syntaxChars = inCharClass ? RubyFlavorProcessor.CHAR_CLASS_SYNTAX_CHARACTERS : RubyFlavorProcessor.SYNTAX_CHARACTERS;
        if (syntaxChars.get(codepoint)) {
            out.append('\\');
        }
        out.appendCodePoint(codepoint);
    }

    private static void emitString(StringBuilder out, List<Integer> codepoints) {
        for (int codepoint : codepoints) {
            if (RubyFlavorProcessor.SYNTAX_CHARACTERS.get(codepoint)) {
                out.append('\\');
            }
            out.appendCodePoint(codepoint);
        }
    }

    private static void unfoldSegment(StringBuilder out, List<Integer> caseFolded, List<RubyCaseUnfoldingTrie.Unfolding> unfoldings, int start, int end, int backtrackingDepth, boolean dropAsciiOnStart) {
        int unfoldingsNextIndex;
        if (backtrackingDepth > 8) {
            throw new UnsupportedRegexException("case-unfolding of case-insensitive string is too complex");
        }
        if (start == end) {
            return;
        }
        if (unfoldings.isEmpty()) {
            RubyCaseFolding.emitString(out, caseFolded.subList(start, end));
            return;
        }
        RubyCaseUnfoldingTrie.Unfolding unfolding = unfoldings.get(0);
        if (unfolding.getStart() > start) {
            RubyCaseFolding.emitString(out, caseFolded.subList(start, unfolding.getStart()));
            RubyCaseFolding.unfoldSegment(out, caseFolded, unfoldings, unfolding.getStart(), end, backtrackingDepth, dropAsciiOnStart);
            return;
        }
        if (unfolding.getLength() > 1) {
            int unfoldingsNextIndex2;
            for (unfoldingsNextIndex2 = 1; unfoldingsNextIndex2 < unfoldings.size() && unfoldings.get(unfoldingsNextIndex2).getStart() < unfolding.getEnd(); ++unfoldingsNextIndex2) {
            }
            out.append("(?:");
            RubyCaseFolding.emitChar(out, unfolding.getCodepoint(), false);
            RubyCaseFolding.unfoldSegment(out, caseFolded, unfoldings.subList(unfoldingsNextIndex2, unfoldings.size()), unfolding.getEnd(), end, backtrackingDepth + 1, dropAsciiOnStart);
            out.append('|');
            RubyCaseFolding.unfoldSegment(out, caseFolded, unfoldings.subList(1, unfoldings.size()), start, end, backtrackingDepth + 1, dropAsciiOnStart);
            out.append(')');
            return;
        }
        out.append("[");
        if (!dropAsciiOnStart || start != 0 || !RubyFlavorProcessor.isAscii(caseFolded.get(start))) {
            RubyCaseFolding.emitChar(out, caseFolded.get(start), true);
        }
        for (unfoldingsNextIndex = 0; unfoldingsNextIndex < unfoldings.size() && unfoldings.get(unfoldingsNextIndex).getStart() == start; ++unfoldingsNextIndex) {
            assert (unfoldings.get(unfoldingsNextIndex).getLength() == 1);
            int codepoint = unfoldings.get(unfoldingsNextIndex).getCodepoint();
            if (dropAsciiOnStart && start == 0 && RubyFlavorProcessor.isAscii(codepoint)) continue;
            RubyCaseFolding.emitChar(out, codepoint, true);
        }
        out.append("]");
        RubyCaseFolding.unfoldSegment(out, caseFolded, unfoldings.subList(unfoldingsNextIndex, unfoldings.size()), start + 1, end, backtrackingDepth, dropAsciiOnStart);
    }
}

