/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui;

import com.bulenkov.darcula.ui.DarculaButtonUI;
import com.paterva.maltego.seeds.ui.hub.HubSeedManager;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DisplayFilterToolbar
extends JToolBar {
    private final HubSeedManager _manager;
    private JLabel displayLabel;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JToggleButton toggleAll;
    private ButtonGroup toggleGroup;
    private JToggleButton toggleInstalled;
    private JToggleButton toggleNotInstalled;

    public DisplayFilterToolbar(HubSeedManager manager) {
        this._manager = manager;
        this.initComponents();
        this.setFloatable(false);
        this.setOpaque(false);
        this.displayLabel.setFont(this.displayLabel.getFont().deriveFont(1));
        this.toggleAll.putClientProperty("inHubPanel", Boolean.TRUE);
        this.toggleInstalled.putClientProperty("inHubPanel", Boolean.TRUE);
        this.toggleNotInstalled.putClientProperty("inHubPanel", Boolean.TRUE);
        Color buttonFg = DarculaButtonUI.getButtonColorHub();
        this.toggleAll.setForeground(buttonFg);
        this.toggleInstalled.setForeground(buttonFg);
        this.toggleNotInstalled.setForeground(buttonFg);
        Color partnersBg = MaltegoLAF.getLookAndFeelDefaults().getColor("hub-partners-bg");
        this.toggleAll.setBackground(partnersBg);
        this.toggleInstalled.setBackground(partnersBg);
        this.toggleNotInstalled.setBackground(partnersBg);
        String selectBg = "hub-toggle-select-bg";
        this.toggleAll.putClientProperty("toggleButtonSelectBg", selectBg);
        this.toggleInstalled.putClientProperty("toggleButtonSelectBg", selectBg);
        this.toggleNotInstalled.putClientProperty("toggleButtonSelectBg", selectBg);
        this.toggleAll.setFont(this.toggleAll.getFont().deriveFont(1));
        this.toggleInstalled.setFont(this.toggleInstalled.getFont().deriveFont(1));
        this.toggleNotInstalled.setFont(this.toggleNotInstalled.getFont().deriveFont(1));
        this.resetState();
    }

    public void resetState() {
        if (this.toggleGroup != null && this.toggleAll != null) {
            this.toggleGroup.setSelected(this.toggleAll.getModel(), true);
            this.toggleAllActionPerformed(null);
        }
    }

    private void refreshLater() {
        SwingUtilities.invokeLater(() -> this._manager.refresh(false));
    }

    private void initComponents() {
        this.toggleGroup = new ButtonGroup();
        this.displayLabel = new JLabel();
        this.toggleAll = new JToggleButton();
        this.jSeparator1 = new JSeparator();
        this.toggleNotInstalled = new JToggleButton();
        this.jSeparator3 = new JSeparator();
        this.toggleInstalled = new JToggleButton();
        Mnemonics.setLocalizedText((JLabel)this.displayLabel, (String)NbBundle.getMessage(DisplayFilterToolbar.class, (String)"DisplayFilterToolbar.displayLabel.text"));
        this.add(this.displayLabel);
        this.toggleGroup.add(this.toggleAll);
        Mnemonics.setLocalizedText((AbstractButton)this.toggleAll, (String)NbBundle.getMessage(DisplayFilterToolbar.class, (String)"DisplayFilterToolbar.toggleAll.text"));
        this.toggleAll.setFocusPainted(false);
        this.toggleAll.setFocusable(false);
        this.toggleAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayFilterToolbar.this.toggleAllActionPerformed(evt);
            }
        });
        this.add(this.toggleAll);
        this.jSeparator1.setBackground(new Color(0, 0, 0));
        this.jSeparator1.setForeground(new Color(0, 0, 0));
        this.jSeparator1.setMaximumSize(new Dimension(1, 13));
        this.jSeparator1.setMinimumSize(new Dimension(1, 13));
        this.jSeparator1.setOpaque(true);
        this.jSeparator1.setPreferredSize(new Dimension(1, 13));
        this.jSeparator1.setRequestFocusEnabled(false);
        this.jSeparator1.setVerifyInputWhenFocusTarget(false);
        this.add(this.jSeparator1);
        this.toggleGroup.add(this.toggleNotInstalled);
        Mnemonics.setLocalizedText((AbstractButton)this.toggleNotInstalled, (String)NbBundle.getMessage(DisplayFilterToolbar.class, (String)"DisplayFilterToolbar.toggleNotInstalled.text"));
        this.toggleNotInstalled.setFocusPainted(false);
        this.toggleNotInstalled.setFocusable(false);
        this.toggleNotInstalled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayFilterToolbar.this.toggleNotInstalledActionPerformed(evt);
            }
        });
        this.add(this.toggleNotInstalled);
        this.jSeparator3.setBackground(new Color(0, 0, 0));
        this.jSeparator3.setForeground(new Color(0, 0, 0));
        this.jSeparator3.setMaximumSize(new Dimension(1, 13));
        this.jSeparator3.setMinimumSize(new Dimension(1, 13));
        this.jSeparator3.setOpaque(true);
        this.jSeparator3.setPreferredSize(new Dimension(1, 13));
        this.jSeparator3.setRequestFocusEnabled(false);
        this.jSeparator3.setVerifyInputWhenFocusTarget(false);
        this.add(this.jSeparator3);
        this.toggleGroup.add(this.toggleInstalled);
        Mnemonics.setLocalizedText((AbstractButton)this.toggleInstalled, (String)NbBundle.getMessage(DisplayFilterToolbar.class, (String)"DisplayFilterToolbar.toggleInstalled.text"));
        this.toggleInstalled.setFocusPainted(false);
        this.toggleInstalled.setFocusable(false);
        this.toggleInstalled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayFilterToolbar.this.toggleInstalledActionPerformed(evt);
            }
        });
        this.add(this.toggleInstalled);
    }

    private void toggleAllActionPerformed(ActionEvent evt) {
        this._manager.setDipslayFilter(DisplayFilter.ALL);
        this.refreshLater();
    }

    private void toggleNotInstalledActionPerformed(ActionEvent evt) {
        this._manager.setDipslayFilter(DisplayFilter.NOT_INSTALLED);
        this.refreshLater();
    }

    private void toggleInstalledActionPerformed(ActionEvent evt) {
        this._manager.setDipslayFilter(DisplayFilter.INSTALLED);
        this.refreshLater();
    }

    public static enum DisplayFilter {
        ALL,
        NOT_INSTALLED,
        INSTALLED;

    }
}

