// oid.cc
//
// this file autogenerated by ./oidc at May  8 2025 20:12:09
// you should edit the source file(s) instead of this file
//

#include "oid.h"

#include "../bytestring.h"
#include <unordered_map>
#include <string>

std::unordered_map<std::basic_string<uint8_t>, std::string> &oid::get_oid_dict() {
	static std::unordered_map<std::basic_string<uint8_t>, std::string> oid_dict = {
		{ {0x04,0x00,0x8f,0x7a,0x01,0x04}, "ETSI_EV_CPS" },
		{ {0x04,0x00,0x8f,0x7a,0x01,0x05}, "ETSI_EV_CPS[1]" },
		{ {0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x01}, "user_id" },
		{ {0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x19}, "domain_component" },
		{ {0x2a}, "ISO" },
		{ {0x2a,0x28,0x00,0x11,0x01,0x16}, "A-Trust_EV_CPS" },
		{ {0x2a,0x81,0x1c}, "China" },
		{ {0x2a,0x81,0x1c,0x81,0x45}, "OSCCA" },
		{ {0x2a,0x81,0x1c,0xcf,0x55}, "GM_Standard_Committee" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01}, "Cryptographic_Algorithm" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x64}, "Block_Cipher" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x66}, "SM1_Block_Cipher" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x67}, "SSF33_Block_Cipher" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x68}, "SM4_Block_Cipher" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x81,0x48}, "Stream_Cipher" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x81,0x49}, "ZUC_Stream_Cipher" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2c}, "Public_Key_Cryptography" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2d}, "SM2_Elliptic_Curve_Cryptography" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2d,0x01}, "SM2-1_Digital_Siganture_Algorithm" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2d,0x02}, "SM2-2_Key_Exchange_Protocol" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2d,0x03}, "SM2-3_Public_Key_Encryption" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2e}, "SM9_Identity-Based_Cryptography" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2e,0x01}, "SM9-1_Digital_Signature_Algorithm" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2e,0x02}, "SM9-2_Key_Exchange_Protocol" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2e,0x03}, "SM9-3_Public_Key_Encryptio" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x10}, "Hash_Algorithm" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x11}, "SM3_Hash_Algorithm" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x11,0x01}, "SM3_Hash_Without_Key" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x11,0x02}, "SM3_Hash_With_Key" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x74}, "Digest_Signing" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x75}, "SM2_Signing_with_SM3" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x78}, "RSA_Signing_with_SM3" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x04,0x03}, "Certificate_Authority" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06}, "Standard_Class" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01}, "Fundatation_Class" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x01}, "Algorithm_Class" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x01,0x01}, "ZUC_Standard" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x01,0x02}, "SM4_Standard" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x01,0x03}, "SM2_Standard" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x01,0x04}, "SM3_Standard" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x02}, "ID_Class" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x02,0x01}, "Crypto_ID" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x03}, "Operation_Modes" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x04}, "Security_Mechanism" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x04,0x01}, "SM2_Specificate" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x04,0x02}, "SM2_Cryptographic_Message_Syntax" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x02}, "Device_Class" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x03}, "Service_Class" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x04}, "Infrastructure" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x05}, "Testing_Class" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x05,0x01}, "Random_Testing_Class" },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x06}, "Management_Class" },
		{ {0x2a,0x81,0x1c,0x86,0xef,0x3a,0x01,0x01,0x03}, "SHECA_EV_CPS" },
		{ {0x2a,0x83,0x08,0x8c,0x9b,0x1b,0x64,0x85,0x51,0x01}, "SECOM_Trust_Systems_EV_CPS" },
		{ {0x2a,0x85,0x03,0x07,0x01,0x01,0x01,0x01}, "id-tc26-gost3410-12-256" },
		{ {0x2a,0x85,0x03,0x07,0x01,0x01,0x01,0x02}, "id-tc26-gost3410-12-512" },
		{ {0x2a,0x85,0x03,0x07,0x01,0x01,0x02,0x02}, "id-tc26-digest-gost3411-12-256" },
		{ {0x2a,0x85,0x03,0x07,0x01,0x01,0x02,0x03}, "id-tc26-digest-gost3411-12-512" },
		{ {0x2a,0x85,0x03,0x07,0x01,0x01,0x03,0x02}, "id-tc26-signwithdigest-gost3410-12-256" },
		{ {0x2a,0x85,0x03,0x07,0x01,0x01,0x03,0x03}, "id-tc26-signwithdigest-gost3410-12-512" },
		{ {0x2a,0x86,0x48,0x04,0x03,0x02}, "ecdsa-with-SHA256[1]" },
		{ {0x2a,0x86,0x48,0xce,0x38,0x04,0x01}, "id-dsa" },
		{ {0x2a,0x86,0x48,0xce,0x38,0x04,0x03}, "id-dsa-with-sha1" },
		{ {0x2a,0x86,0x48,0xce,0x3d}, "ansi-X9-62" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01}, "id-fieldType" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01,0x01}, "prime-field" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01,0x02}, "characteristic-two-field" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01,0x02,0x03}, "id-characteristic-two-basis" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01,0x02,0x03,0x01}, "gnBasis" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01,0x02,0x03,0x02}, "tpBasis" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01,0x02,0x03,0x03}, "ppBasis" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x02}, "id-publicKeyType" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x02,0x01}, "id-ecPublicKey" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03}, "ellipticCurve" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00}, "c-TwoCurve" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x01}, "c2pnb163v1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x02}, "c2pnb163v2" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x03}, "c2pnb163v3" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x04}, "c2pnb176w1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x05}, "c2tnb191v1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x06}, "c2tnb191v2" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x07}, "c2tnb191v3" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x08}, "c2onb191v4" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x09}, "c2onb191v5" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x0a}, "c2pnb208w1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x0b}, "c2tnb239v1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x0c}, "c2tnb239v2" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x0d}, "c2tnb239v3" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x0e}, "c2onb239v4" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x0f}, "c2onb239v5" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x10}, "c2pnb272w1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x11}, "c2pnb304w1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x12}, "c2tnb359v1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x13}, "c2pnb368w1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x14}, "c2tnb431r1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01}, "primeCurve" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x01}, "prime192v1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x02}, "prime192v2" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x03}, "prime192v3" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x04}, "prime239v1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x05}, "prime239v2" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x06}, "prime239v3" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x07}, "prime256v1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x08}, "brainpoolP256t1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x09}, "brainpoolP320r1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x0a}, "brainpoolP320t1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x0b}, "brainpoolP384r1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x0c}, "brainpoolP384t1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x0d}, "brainpoolP512r1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x0e}, "brainpoolP512t1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x02}, "sect163r1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x03}, "sect239k1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x0a}, "secp256k1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x0f}, "sect163r2[1]" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x10}, "sect283k1[1]" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x11}, "sect283r1[1]" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x1a}, "sect233k1[1]" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x1b}, "sect233r1[1]" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x1f}, "secp192k1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x20}, "secp224k1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x21}, "secp224r1[1]" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x22}, "secp384r1[1]" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x23}, "secp521r1[1]" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x24}, "sect409k1[1]" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x25}, "sect409r1[1]" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x26}, "sect571k1[1]" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x27}, "sect571r1[1]" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x04}, "id-ecSigType" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x04,0x01}, "ecdsa-with-SHA1" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x01}, "ecdsa-with-SHA224" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x02}, "ecdsa-with-SHA256" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x03}, "ecdsa-with-SHA384" },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x04}, "ecdsa-with-SHA512" },
		{ {0x2a,0x86,0x48,0xce,0x3e,0x02,0x01}, "dhpublicnumber" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01}, "email_address" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01}, "rsaEncryption" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x02}, "md2WithRSAEncryption" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x04}, "md5WithRSAEncryption" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05}, "sha1WithRSAEncryption" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x07}, "id-RSAES-OAEP" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x08}, "id-mgf1" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x09}, "id-pSpecified" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0a}, "id-RSASSA-PSS" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0b}, "sha256WithRSAEncryption" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0c}, "sha384WithRSAEncryption" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0d}, "sha512WithRSAEncryption" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0e}, "sha224WithRSAEncryption" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0f}, "sha512-224WithRSAEncryption" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x10}, "sha512-256WithRSAEncryption" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09}, "pkcs-9" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x00}, "pkcs-9-mo" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x01}, "emailAddress" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x02}, "pkcs-9-at-unstructuredName" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x03}, "pkcs-9-at-contentType" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x04}, "pkcs-9-at-messageDigest" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x05}, "pkcs-9-at-signingTime" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x06}, "pkcs-9-at-counterSignature" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x07}, "pkcs-9-at-challengePassword" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x08}, "pkcs-9-at-unstructuredAddress" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x09}, "pkcs-9-at-extendedCertificateAttributes" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x0d}, "pkcs-9-at-signingDescription" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x0e}, "pkcs-9-at-extensionRequest" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x0f}, "pkcs-9-at-smimeCapabilities" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10}, "smime" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x02}, "id-aa" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x02,0x22}, "id-aa-cmc-unsignedData" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x14}, "pkcs-9-at-friendlyName" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x15}, "pkcs-9-at-localKeyId" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x16}, "certTypes" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x17}, "crlTypes" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x18}, "pkcs-9-oc" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x18,0x01}, "pkcs-9-oc-pkcsEntity" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x18,0x02}, "pkcs-9-oc-naturalPerson" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x19}, "pkcs-9-at" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x19,0x01}, "pkcs-9-at-pkcs15Token" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x19,0x02}, "pkcs-9-at-encryptedPrivateKeyInfo" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x19,0x03}, "pkcs-9-at-randomNonce" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x19,0x04}, "pkcs-9-at-sequenceNumber" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x19,0x05}, "pkcs-9-at-pkcs7PDU" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x1a}, "pkcs-9-sx" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x1a,0x01}, "pkcs-9-sx-pkcs9String" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x1a,0x02}, "pkcs-9-sx-signingTime" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x1b}, "pkcs-9-mr" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x1b,0x01}, "pkcs-9-mr-caseIgnoreMatch" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x1b,0x02}, "pkcs-9-mr-signingTimeMatch" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x02}, "md2" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x05}, "md5" },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x05}, "id-md5" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x09,0x15,0x02,0x03}, "Cisco_ACT2_SUDI" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x04}, "SPC_INDIRECT_DATA_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x0a}, "SPC_SP_AGENCY_INFO_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x0b}, "SPC_STATEMENT_TYPE_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x0c}, "SPC_SP_OPUS_INFO_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x0e}, "SPC_CERT_EXTENSIONS_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x0f}, "SPC_PE_IMAGE_DATA_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x12}, "SPC_RAW_FILE_DATA_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x13}, "SPC_STRUCTURED_STORAGE_DATA_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x14}, "SPC_JAVA_CLASS_DATA_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x15}, "SPC_INDIVIDUAL_SP_KEY_PURPOSE_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x16}, "SPC_COMMERCIAL_SP_KEY_PURPOSE_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x19}, "SPC_CAB_DATA_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x1a}, "SPC_MINIMAL_CRITERIA_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x1b}, "SPC_FINANCIAL_CRITERIA_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x1c}, "SPC_LINK_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x1d}, "SPC_HASH_INFO_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x1e}, "SPC_SIPINFO_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x02,0x01}, "szOID_TRUSTED_CODESIGNING_CA_LIST" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x02,0x02}, "szOID_TRUSTED_CLIENT_AUTH_CA_LIST" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x02,0x03}, "szOID_TRUSTED_SERVER_AUTH_CA_LIST" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x03,0x02,0x01}, "SPC_TIME_STAMP_REQUEST_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x01}, "OID_CTL" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x01,0x01}, "szOID_SORTED_CTL" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x02}, "szOID_NEXT_UPDATE_LOCATION" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x01}, "szOID_KP_CTL_USAGE_SIGNING" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x02}, "szOID_KP_TIME_STAMP_SIGNING" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x03}, "szOID_SERVER_GATED_CRYPTO" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x03,0x01}, "szOID_SERIALIZED" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x04}, "szOID_EFS_CRYPTO" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x04,0x01}, "szOID_EFS_RECOVERY" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x05}, "szOID_WHQL_CRYPTO" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x06}, "szOID_NT5_CRYPTO" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x07}, "szOID_OEM_WHQL_CRYPTO" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x08}, "szOID_EMBEDDED_NT_CRYPTO" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x09}, "OID_ROOT_LIST_SIGNER" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x0a}, "szOID_KP_QUALIFIED_SUBORDINATION" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x0b}, "szOID_KP_KEY_RECOVERY" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x0c}, "szOID_KP_DOCUMENT_SIGNING" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x0d}, "szOID_KP_LIFETIME_SIGNING" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x0e}, "szOID_KP_MOBILE_DEVICE_SOFTWARE" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x04,0x01}, "szOID_YESNO_TRUST_ATTR" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x05,0x01}, "szOID_DRM" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x05,0x02}, "szOID_DRM_INDIVIDUALIZATION" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x06,0x01}, "szOID_LICENSES" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x06,0x02}, "szOID_LICENSE_SERVER" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x07}, "szOID_MICROSOFT_RDN_PREFIX" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x07,0x01}, "szOID_KEYID_RDN" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x08,0x01}, "szOID_REMOVE_CERTIFICATE" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x09,0x01}, "szOID_CROSS_CERT_DIST_POINTS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0a,0x01}, "szOID_CMC_ADD_ATTRIBUTES" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b}, "szOID_CERT_PROP_ID_PREFIX" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x09}, "OID_CERT_PROP_ID_METAEKUS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x0b}, "CERT_FRIENDLY_NAME_PROP_ID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x14}, "OID_CERT_KEY_IDENTIFIER_PROP_ID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x1d}, "OID_CERT_SUBJECT_NAME_MD5_HASH_PROP_ID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x53}, "CERT_ROOT_PROGRAM_CERT_POLICIES_PROP_ID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x62}, "OID_CERT_PROP_ID_PREFIX_98" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x69}, "OID_CERT_PROP_ID_PREFIX_105" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0c,0x01}, "szOID_ANY_APPLICATION_POLICY" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0c,0x01,0x01}, "szOID_CATALOG_LIST" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0c,0x01,0x02}, "szOID_CATALOG_LIST_MEMBER" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0c,0x02,0x01}, "CAT_NAMEVALUE_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0c,0x02,0x02}, "CAT_MEMBERINFO_OBJID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0d,0x01}, "szOID_RENEWAL_CERTIFICATE" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0d,0x02,0x01}, "szOID_ENROLLMENT_NAME_VALUE_PAIR" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0d,0x02,0x02}, "szOID_ENROLLMENT_CSP_PROVIDER" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0d,0x02,0x03}, "szOID_OS_VERSION" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x10,0x04}, "szOID_MICROSOFT_Encryption_Key_Preference" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x11,0x01}, "szOID_LOCAL_MACHINE_KEYSET" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x01}, "szOID_PKIX_LICENSE_INFO" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x02}, "szOID_PKIX_MANUFACTURER" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x03}, "szOID_PKIX_MANUFACTURER_MS_SPECIFIC" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x04}, "szOID_PKIX_HYDRA_CERT_VERSION" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x05}, "szOID_PKIX_LICENSED_PRODUCT_INFO" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x06}, "szOID_PKIX_MS_LICENSE_SERVER_INFO" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x07}, "szOID_PKIS_PRODUCT_SPECIFIC_OID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x08}, "szOID_PKIS_TLSERVER_SPK_OID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x01}, "szOID_AUTO_ENROLL_CTL_USAGE" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x02}, "szOID_ENROLL_CERTTYPE_EXTENSION" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x02,0x01}, "szOID_ENROLLMENT_AGENT" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x02,0x02}, "szOID_KP_SMARTCARD_LOGON" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x02,0x03}, "szOID_NT_PRINCIPAL_NAME" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x03}, "szOID_CERT_MANIFOLD" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x01}, "szOID_CERTSRV_CA_VERSION" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x02}, "szOID_CERTSRV_PREVIOUS_CERT_HASH" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x03}, "szOID_CRL_VIRTUAL_BASE" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x04}, "szOID_CRL_NEXT_PUBLISH" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x05}, "szOID_KP_CA_EXCHANGE" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x06}, "szOID_KP_KEY_RECOVERY_AGENT" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x07}, "szOID_CERTIFICATE_TEMPLATE" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x08}, "szOID_ENTERPRISE_OID_ROOT" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x09}, "szOID_RDN_DUMMY_SIGNER" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x0a}, "szOID_APPLICATION_CERT_POLICIES" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x0b}, "szOID_APPLICATION_POLICY_MAPPINGS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x0c}, "szOID_APPLICATION_POLICY_CONSTRAINTS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x0d}, "szOID_ARCHIVED_KEY_ATTR" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x0e}, "szOID_CRL_SELF_CDP" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x0f}, "szOID_REQUIRE_CERT_CHAIN_POLICY" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x10}, "szOID_ARCHIVED_KEY_CERT_HASH" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x11}, "szOID_ISSUED_CERT_HASH" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x13}, "szOID_DS_EMAIL_REPLICATION" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x14}, "szOID_REQUEST_CLIENT_INFO" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x15}, "szOID_ENCRYPTED_KEY_HASH" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x16}, "szOID_CERTSRV_CROSSCA_VERSION" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x19,0x01}, "szOID_NTDS_REPLICATION" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x1e,0x01}, "szOID_IIS_VIRTUAL_SERVER" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x1f,0x01}, "szOID_PRODUCT_UPDATE" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x00,0x01}, "szOID_PEERNET_CERT_TYPE" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x00,0x02}, "szOID_PEERNET_PEERNAME" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x00,0x03}, "szOID_PEERNET_CLASSIFIER" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x00,0x04}, "szOID_PEERNET_CERT_VERSION" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x01}, "szOID_PEERNET_PNRP" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x01,0x01}, "szOID_PEERNET_PNRP_ADDRESS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x01,0x02}, "szOID_PEERNET_PNRP_FLAGS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x01,0x03}, "szOID_PEERNET_PNRP_PAYLOAD" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x01,0x04}, "szOID_PEERNET_PNRP_ID" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x02}, "szOID_PEERNET_IDENTITY" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x02,0x02}, "szOID_PEERNET_IDENTITY_FLAGS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x03}, "szOID_PEERNET_GROUPING" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x03,0x01}, "szOID_PEERNET_GROUPING_PEERNAME" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x03,0x02}, "szOID_PEERNET_GROUPING_FLAGS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x03,0x03}, "szOID_PEERNET_GROUPING_ROLES" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x03,0x05}, "szOID_PEERNET_GROUPING_CLASSIFIERS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x3c,0x01,0x01}, "OID_ROOT_PROGRAM_FLAGS_BITSTRING" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x3c,0x02,0x01,0x01}, "jurisdiction_of_incorporation_locality_name" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x3c,0x02,0x01,0x02}, "jurisdiction_of_incorporation_state_or_province_name" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x3c,0x02,0x01,0x03}, "jurisdiction_of_incorporation_country_name" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x54,0x01,0x01}, "driveEncryption" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58}, "szOID_CAPICOM" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58,0x01}, "szOID_CAPICOM_VERSION" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58,0x02}, "szOID_CAPICOM_ATTRIBUTE" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58,0x02,0x01}, "szOID_CAPICOM_DOCUMENT_NAME" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58,0x02,0x02}, "szOID_CAPICOM_DOCUMENT_DESCRIPTION" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58,0x03}, "szOID_CAPICOM_ENCRYPTED_DATA" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58,0x03,0x01}, "szOID_CAPICOM_ENCRYPTED_CONTENT" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x86,0x0e,0x01,0x02,0x01,0x08,0x01}, "Network_Solutions__EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0xa0,0x32,0x01,0x01}, "GlobalSign_EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0xa5,0x34,0x02,0x81,0x4a,0x01}, "D-TRUST_EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0xb1,0x3e,0x01,0x64,0x01}, "Verizon_Business_EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0xb2,0x31,0x01,0x02,0x01,0x05,0x01}, "Comodo_Group_EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0xbd,0x47,0x0d,0x18,0x01}, "T-Systems_EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0xbe,0x58,0x00,0x02,0x64,0x01,0x02}, "QuoVadis_EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0xd6,0x79,0x02,0x04,0x02}, "id-ce-SignedCertificateTimestampList" },
		{ {0x2b,0x06,0x01,0x04,0x01,0xd6,0x79,0x02,0x04,0x05}, "id-ad-ocsp-SignedCertificateTimestampList" },
		{ {0x2b,0x06,0x01,0x04,0x01,0xe6,0x79,0x0a,0x01,0x03,0x0a}, "Firmaprofesional_EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0xf0,0x22,0x01,0x06}, "GeoTrust_EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0xf3,0x39,0x06,0x01,0x01}, "Izenpe_EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x81,0x87,0x2e,0x0a,0x08,0x0c,0x01,0x02}, "Camerfirma_EV_CPS[1]" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x81,0x87,0x2e,0x0a,0x0e,0x02,0x01,0x02}, "Camerfirma_EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x81,0xad,0x5a,0x02,0x05,0x02,0x03,0x01}, "OpenTrust_DocuSign_France_EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x81,0xb5,0x37,0x01,0x01,0x01}, "StartCom_Certification_Authority_EV_CPS[1]" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x81,0xb5,0x37,0x02}, "StartCom_Certification_Authority_EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x8f,0x09,0x02,0x01}, "AffirmTrust_EV_CPS" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x8f,0x09,0x02,0x02}, "AffirmTrust_EV_CPS[1]" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x8f,0x09,0x02,0x03}, "AffirmTrust_EV_CPS[2]" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x8f,0x09,0x02,0x04}, "AffirmTrust_EV_CPS[3]" },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x9b,0x51,0x02}, "WoSign_EV_CPS" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07}, "id-pkix" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x01}, "id-pe" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x01}, "id-pe-authorityInfoAccess" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x02}, "id-pe-biometricInfo" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x03}, "id-pe-qcStatements" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x0b}, "id-pe-subjectInfoAccess" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x0c}, "id-pe-logotype" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x02}, "id-qt" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01}, "id-qt-cps" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x02}, "id-qt-unotice" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03}, "id-kp" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x01}, "id-kp-serverAuth" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x02}, "id-kp-clientAuth" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x03}, "id-kp-codeSigning" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x04}, "id-kp-emailProtection" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x05}, "id-kp-ipsecEndSystem" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x06}, "id-kp-ipsecTunnel" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x07}, "id-kp-ipsecUser" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x08}, "id-kp-timeStamping" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x09}, "id-kp-OCSPSigning" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x1b}, "id-kp-cmcCA" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x1c}, "id-kp-cmcRA" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x06,0x02}, "id-alg-noSignature" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x06,0x1e}, "id-RSASSA-PSS-SHAKE128" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x06,0x1f}, "id-RSASSA-PSS-SHAKE256" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x06,0x20}, "id-ecdsa-with-shake128" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x06,0x21}, "id-ecdsa-with-shake256" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07}, "id-cmc" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x01}, "id-cmc-statusInfo" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x02}, "id-cmc-identification" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x03}, "id-cmc-identityProof" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x04}, "id-cmc-dataReturn" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x05}, "id-cmc-transactionId" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x06}, "id-cmc-senderNonce" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x07}, "id-cmc-recipientNonce" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x08}, "id-cmc-addExtensions" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x09}, "id-cmc-encryptedPOP" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x0a}, "id-cmc-decryptedPOP" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x0b}, "id-cmc-lraPOPWitness" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x0f}, "id-cmc-getCert" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x10}, "id-cmc-getCRL" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x11}, "id-cmc-revokeRequest" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x12}, "id-cmc-regInfo" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x13}, "id-cmc-responseInfo" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x15}, "id-cmc-queryPending" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x16}, "id-cmc-popLinkRandom" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x17}, "id-cmc-popLinkWitness" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x18}, "id-cmc-confirmCertAcceptance" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x19}, "id-cmc-statusInfoV2" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x1a}, "id-cmc-trustedAnchors" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x1b}, "id-cmc-authData" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x1c}, "id-cmc-batchRequests" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x1d}, "id-cmc-batchResponses" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x1e}, "id-cmc-publishCert" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x1f}, "id-cmc-modCertTemplate" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x20}, "id-cmc-controlProcessed" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x21}, "id-cmc-popLinkWitnessV2" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x22}, "id-cmc-identityProofV2" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x23}, "id-cmc-raIdentityWitness" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x24}, "id-cmc-changeSubjectName" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x25}, "id-cmc-responseBody" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x08}, "id-on" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x08,0x09}, "id-on-SmtpUTF8Mailbox" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x09}, "ietf-at" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x01}, "pkcs-9-at-dateOfBirth" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x02}, "pkcs-9-at-placeOfBirth" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x03}, "pkcs-9-at-gender" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x04}, "pkcs-9-at-countryOfCitizenship" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x05}, "pkcs-9-at-countryOfResidence" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x0b}, "id-qcs" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x0b,0x01}, "id-qcs-pkixQCSyntax-v1" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x0b,0x02}, "id-qcs-pkixQCSyntax-v2" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x0c}, "id-cct" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x0c,0x02}, "id-cct-PKIData" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x0c,0x03}, "id-cct-PKIResponse" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x14}, "id-logo" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x14,0x01}, "id-logo-loyalty" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x14,0x02}, "id-logo-background" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30}, "id-ad" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01}, "id-ad-ocsp" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x01}, "id-pkix-ocsp-basic" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x02}, "id-pkix-ocsp-nonce" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x03}, "id-pkix-ocsp-crl" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x04}, "id-pkix-ocsp-response" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x05}, "id-pkix-ocsp-nocheck" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x06}, "id-pkix-ocsp-archive-cutoff" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x07}, "id-pkix-ocsp-service-locator" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x08}, "id-pkix-ocsp-pref-sig-algs" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x09}, "id-pkix-ocsp-extended-revoke" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x02}, "id-ad-caIssuers" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x03}, "id-ad-timeStamping" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x05}, "id-ad-caRepository" },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x0c}, "id-ad-cmc" },
		{ {0x2b,0x0e,0x03,0x02,0x0f}, "id-sha-with-rsa-signature" },
		{ {0x2b,0x0e,0x03,0x02,0x1a}, "id-sha1" },
		{ {0x2b,0x0e,0x03,0x02,0x1d}, "sha-1WithRSAEncryption" },
		{ {0x2b,0x24,0x03,0x03,0x02,0x08}, "ecStdCurvesAndGeneration" },
		{ {0x2b,0x24,0x03,0x03,0x02,0x08,0x01}, "ellipticCurve[1]" },
		{ {0x2b,0x65}, "id-edwards-curve-algs" },
		{ {0x2b,0x65,0x6e}, "id-X25519" },
		{ {0x2b,0x65,0x6f}, "id-X448" },
		{ {0x2b,0x65,0x70}, "id-Ed25519" },
		{ {0x2b,0x65,0x71}, "id-Ed448" },
		{ {0x2b,0x81,0x04}, "certicom-arc" },
		{ {0x2b,0x81,0x04,0x00}, "ellipticCurve[2]" },
		{ {0x2b,0x81,0x04,0x00,0x01}, "sect163k1" },
		{ {0x2b,0x81,0x04,0x00,0x0f}, "sect163r2" },
		{ {0x2b,0x81,0x04,0x00,0x10}, "sect283k1" },
		{ {0x2b,0x81,0x04,0x00,0x11}, "sect283r1" },
		{ {0x2b,0x81,0x04,0x00,0x1a}, "sect233k1" },
		{ {0x2b,0x81,0x04,0x00,0x1b}, "sect233r1" },
		{ {0x2b,0x81,0x04,0x00,0x21}, "secp224r1" },
		{ {0x2b,0x81,0x04,0x00,0x22}, "secp384r1" },
		{ {0x2b,0x81,0x04,0x00,0x23}, "secp521r1" },
		{ {0x2b,0x81,0x04,0x00,0x24}, "sect409k1" },
		{ {0x2b,0x81,0x04,0x00,0x25}, "sect409r1" },
		{ {0x2b,0x81,0x04,0x00,0x26}, "sect571k1" },
		{ {0x2b,0x81,0x04,0x00,0x27}, "sect571r1" },
		{ {0x2b,0x81,0x04,0x01,0x0c}, "id-ecDH" },
		{ {0x2b,0x81,0x04,0x01,0x0d}, "id-ecMQV" },
		{ {0x2b,0x81,0x1f,0x01,0x11,0x01}, "Actalis_EV_CPS" },
		{ {0x52,0x86,0x48,0xce,0x38,0x02}, "holdInstruction" },
		{ {0x52,0x86,0x48,0xce,0x38,0x02,0x01}, "id-holdinstruction-none" },
		{ {0x52,0x86,0x48,0xce,0x38,0x02,0x02}, "id-holdinstruction-callissuer" },
		{ {0x52,0x86,0x48,0xce,0x38,0x02,0x03}, "id-holdinstruction-reject" },
		{ {0x55,0x04}, "id-at" },
		{ {0x55,0x04,0x03}, "common_name" },
		{ {0x55,0x04,0x04}, "surname" },
		{ {0x55,0x04,0x05}, "serial_number" },
		{ {0x55,0x04,0x06}, "country_name" },
		{ {0x55,0x04,0x07}, "locality_name" },
		{ {0x55,0x04,0x08}, "state_or_province_name" },
		{ {0x55,0x04,0x09}, "street" },
		{ {0x55,0x04,0x0a}, "organization_name" },
		{ {0x55,0x04,0x0b}, "organizational_unit_name" },
		{ {0x55,0x04,0x0c}, "title" },
		{ {0x55,0x04,0x0d}, "description" },
		{ {0x55,0x04,0x0e}, "search_guide" },
		{ {0x55,0x04,0x0f}, "business_category" },
		{ {0x55,0x04,0x10}, "postal_address" },
		{ {0x55,0x04,0x11}, "postal_code" },
		{ {0x55,0x04,0x12}, "post_office_box" },
		{ {0x55,0x04,0x13}, "physical_delivery_office_name" },
		{ {0x55,0x04,0x14}, "telephone_number" },
		{ {0x55,0x04,0x15}, "telex_number" },
		{ {0x55,0x04,0x16}, "teletex_terminal_identifier" },
		{ {0x55,0x04,0x17}, "facsimile_telephone_number" },
		{ {0x55,0x04,0x18}, "x121_address" },
		{ {0x55,0x04,0x19}, "international_isdn_number" },
		{ {0x55,0x04,0x1a}, "registered_address" },
		{ {0x55,0x04,0x1b}, "destination_indicator" },
		{ {0x55,0x04,0x1c}, "preferred_delivery_method" },
		{ {0x55,0x04,0x1f}, "member" },
		{ {0x55,0x04,0x20}, "owner" },
		{ {0x55,0x04,0x21}, "role_occupant" },
		{ {0x55,0x04,0x22}, "see_also" },
		{ {0x55,0x04,0x23}, "user_password" },
		{ {0x55,0x04,0x29}, "name" },
		{ {0x55,0x04,0x2a}, "given_name" },
		{ {0x55,0x04,0x2b}, "initials" },
		{ {0x55,0x04,0x2c}, "generation_qualifier" },
		{ {0x55,0x04,0x2d}, "x500_unique_identifier" },
		{ {0x55,0x04,0x2e}, "dn_qualifier" },
		{ {0x55,0x04,0x2f}, "enhanced_search_guide" },
		{ {0x55,0x04,0x31}, "distinguished_name" },
		{ {0x55,0x04,0x32}, "unique_member" },
		{ {0x55,0x04,0x33}, "house_identifier" },
		{ {0x55,0x04,0x41}, "pseudonym" },
		{ {0x55,0x1d}, "id-ce" },
		{ {0x55,0x1d,0x01}, "DeprecatedAuthorityKeyIdentifier" },
		{ {0x55,0x1d,0x07}, "DeprecatedSubjectAltName" },
		{ {0x55,0x1d,0x09}, "id-ce-subjectDirectoryAttributes" },
		{ {0x55,0x1d,0x0e}, "id-ce-subjectKeyIdentifier" },
		{ {0x55,0x1d,0x0f}, "key_usage" },
		{ {0x55,0x1d,0x10}, "id-ce-privateKeyUsagePeriod" },
		{ {0x55,0x1d,0x11}, "subject_alt_name" },
		{ {0x55,0x1d,0x12}, "id-ce-issuerAltName" },
		{ {0x55,0x1d,0x13}, "id-ce-basicConstraints" },
		{ {0x55,0x1d,0x14}, "id-ce-cRLNumber" },
		{ {0x55,0x1d,0x15}, "id-ce-reasonCode" },
		{ {0x55,0x1d,0x17}, "id-ce-instructionCode" },
		{ {0x55,0x1d,0x18}, "id-ce-invalidityDate" },
		{ {0x55,0x1d,0x1b}, "id-ce-deltaCRLIndicator" },
		{ {0x55,0x1d,0x1c}, "id-ce-issuingDistributionPoint" },
		{ {0x55,0x1d,0x1d}, "id-ce-certificateIssuer" },
		{ {0x55,0x1d,0x1e}, "id-ce-nameConstraints" },
		{ {0x55,0x1d,0x1f}, "id-ce-cRLDistributionPoints" },
		{ {0x55,0x1d,0x20}, "id-ce-certificatePolicies" },
		{ {0x55,0x1d,0x20,0x00}, "anyPolicy" },
		{ {0x55,0x1d,0x21}, "id-ce-policyMappings" },
		{ {0x55,0x1d,0x22}, "DeprecatedpolicyConstraints" },
		{ {0x55,0x1d,0x23}, "id-ce-authorityKeyIdentifier" },
		{ {0x55,0x1d,0x24}, "id-ce-policyConstraints" },
		{ {0x55,0x1d,0x25}, "ext_key_usage" },
		{ {0x55,0x1d,0x25,0x00}, "anyExtendedKeyUsage" },
		{ {0x55,0x1d,0x2e}, "id-ce-freshestCRL" },
		{ {0x55,0x1d,0x36}, "id-ce-inhibitAnyPolicy" },
		{ {0x60,0x84,0x10,0x01,0x87,0x69,0x01,0x01,0x01,0x0c,0x06,0x01,0x01,0x01}, "DigiNotar_EV_CPS" },
		{ {0x60,0x84,0x10,0x01,0x87,0x6b,0x01,0x02,0x07}, "Logius_PKIoverheid_EV_CPS" },
		{ {0x60,0x84,0x42,0x01,0x1a,0x01,0x03,0x03}, "Buypass_EV_CPS" },
		{ {0x60,0x85,0x74,0x01,0x53,0x15,0x00}, "Swisscom_EV_CPS" },
		{ {0x60,0x85,0x74,0x01,0x59,0x01,0x02,0x01,0x01}, "SwissSign_EV_CPS" },
		{ {0x60,0x86,0x18,0x01,0x02,0x01,0x01,0x05,0x07,0x01,0x09}, "Kamu_Sertifikasyon_Merkezi_EV_CPS" },
		{ {0x60,0x86,0x18,0x03,0x00,0x04,0x01,0x01,0x04}, "E-Tugra_EV_CPS" },
		{ {0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x01,0x16}, "id-keyExchangeAlgorithm" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02}, "hashAlgs" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x01}, "id-sha256" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x02}, "id-sha384" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x03}, "id-sha512" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x04}, "id-sha224" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0b}, "id-shake128" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0c}, "id-shake256" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0d}, "id-hmacWithSHA3-224" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0e}, "id-hmacWithSHA3-256" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0f}, "id-hmacWithSHA3-384" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x10}, "id-hmacWithSHA3-512" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x13}, "id-KmacWithSHAKE128" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x14}, "id-KmacWithSHAKE256" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03}, "sigAlgs" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x01}, "id-dsa-with-sha224" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x02}, "id-dsa-with-sha256" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x09}, "id-ecdsa-with-sha3-224" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0a}, "id-ecdsa-with-sha3-256" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0b}, "id-ecdsa-with-sha3-384" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0c}, "id-ecdsa-with-sha3-512" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0d}, "id-rsassa-pkcs1-v1_5-with-sha3-224" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0e}, "id-rsassa-pkcs1-v1_5-with-sha3-256" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0f}, "id-rsassa-pkcs1-v1_5-with-sha3-384" },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x10}, "id-rsassa-pkcs1-v1_5-with-sha3-512" },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01}, "NetscapeCertificateExtension" },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01}, "NetscapeCertType" },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x03}, "RevocationURL" },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x04}, "CaRevocationURL" },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x0c}, "SSLServerName" },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x0d}, "NetscapeCertificateComment" },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x03,0x01,0x81,0x58}, "pkcs-9-at-userPKCS12" },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x17,0x06}, "Symantec_EV_CPS" },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x30,0x01}, "Thawte_EV_CPS" },
		{ {0x60,0x86,0x48,0x01,0x86,0xfa,0x6c,0x0a,0x01,0x02}, "Entrust_EV_CPS" },
		{ {0x60,0x86,0x48,0x01,0x86,0xfb,0x7b,0x83,0x74,0x09}, "Wells_Fargo_EV_CPS" },
		{ {0x60,0x86,0x48,0x01,0x86,0xfd,0x64,0x01,0x01,0x02,0x04,0x01}, "Trustwave_EV_CPS" },
		{ {0x60,0x86,0x48,0x01,0x86,0xfd,0x6c,0x01,0x03,0x00,0x02}, "DigiCert_EV_CPS[1]" },
		{ {0x60,0x86,0x48,0x01,0x86,0xfd,0x6c,0x02,0x01}, "DigiCert_EV_CPS" },
		{ {0x60,0x86,0x48,0x01,0x86,0xfd,0x6d,0x01,0x07,0x17,0x03}, "Go_Daddy_EV_CPS" },
		{ {0x60,0x86,0x48,0x01,0x86,0xfd,0x6e,0x01,0x07,0x17,0x03}, "Starfield_Technologies_EV_CPS" },
	};
	return oid_dict;
}


std::unordered_map<std::basic_string<uint8_t>, uint32_t> &oid::get_oid_to_enum() {
	static std::unordered_map<std::basic_string<uint8_t>, uint32_t> oid_to_enum = {
		{ {0x04,0x00,0x8f,0x7a,0x01,0x04}, oid::type::ETSI_EV_CPS },
		{ {0x04,0x00,0x8f,0x7a,0x01,0x05}, oid::type::ETSI_EV_CPS_1_ },
		{ {0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x01}, oid::type::user_id },
		{ {0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x19}, oid::type::domain_component },
		{ {0x2a}, oid::type::ISO },
		{ {0x2a,0x28,0x00,0x11,0x01,0x16}, oid::type::A_Trust_EV_CPS },
		{ {0x2a,0x81,0x1c}, oid::type::China },
		{ {0x2a,0x81,0x1c,0x81,0x45}, oid::type::OSCCA },
		{ {0x2a,0x81,0x1c,0xcf,0x55}, oid::type::GM_Standard_Committee },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01}, oid::type::Cryptographic_Algorithm },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x64}, oid::type::Block_Cipher },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x66}, oid::type::SM1_Block_Cipher },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x67}, oid::type::SSF33_Block_Cipher },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x68}, oid::type::SM4_Block_Cipher },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x81,0x48}, oid::type::Stream_Cipher },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x81,0x49}, oid::type::ZUC_Stream_Cipher },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2c}, oid::type::Public_Key_Cryptography },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2d}, oid::type::SM2_Elliptic_Curve_Cryptography },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2d,0x01}, oid::type::SM2_1_Digital_Siganture_Algorithm },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2d,0x02}, oid::type::SM2_2_Key_Exchange_Protocol },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2d,0x03}, oid::type::SM2_3_Public_Key_Encryption },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2e}, oid::type::SM9_Identity_Based_Cryptography },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2e,0x01}, oid::type::SM9_1_Digital_Signature_Algorithm },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2e,0x02}, oid::type::SM9_2_Key_Exchange_Protocol },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2e,0x03}, oid::type::SM9_3_Public_Key_Encryptio },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x10}, oid::type::Hash_Algorithm },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x11}, oid::type::SM3_Hash_Algorithm },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x11,0x01}, oid::type::SM3_Hash_Without_Key },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x11,0x02}, oid::type::SM3_Hash_With_Key },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x74}, oid::type::Digest_Signing },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x75}, oid::type::SM2_Signing_with_SM3 },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x78}, oid::type::RSA_Signing_with_SM3 },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x04,0x03}, oid::type::Certificate_Authority },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06}, oid::type::Standard_Class },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01}, oid::type::Fundatation_Class },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x01}, oid::type::Algorithm_Class },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x01,0x01}, oid::type::ZUC_Standard },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x01,0x02}, oid::type::SM4_Standard },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x01,0x03}, oid::type::SM2_Standard },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x01,0x04}, oid::type::SM3_Standard },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x02}, oid::type::ID_Class },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x02,0x01}, oid::type::Crypto_ID },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x03}, oid::type::Operation_Modes },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x04}, oid::type::Security_Mechanism },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x04,0x01}, oid::type::SM2_Specificate },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x01,0x04,0x02}, oid::type::SM2_Cryptographic_Message_Syntax },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x02}, oid::type::Device_Class },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x03}, oid::type::Service_Class },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x04}, oid::type::Infrastructure },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x05}, oid::type::Testing_Class },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x05,0x01}, oid::type::Random_Testing_Class },
		{ {0x2a,0x81,0x1c,0xcf,0x55,0x06,0x06}, oid::type::Management_Class },
		{ {0x2a,0x81,0x1c,0x86,0xef,0x3a,0x01,0x01,0x03}, oid::type::SHECA_EV_CPS },
		{ {0x2a,0x83,0x08,0x8c,0x9b,0x1b,0x64,0x85,0x51,0x01}, oid::type::SECOM_Trust_Systems_EV_CPS },
		{ {0x2a,0x85,0x03,0x07,0x01,0x01,0x01,0x01}, oid::type::id_tc26_gost3410_12_256 },
		{ {0x2a,0x85,0x03,0x07,0x01,0x01,0x01,0x02}, oid::type::id_tc26_gost3410_12_512 },
		{ {0x2a,0x85,0x03,0x07,0x01,0x01,0x02,0x02}, oid::type::id_tc26_digest_gost3411_12_256 },
		{ {0x2a,0x85,0x03,0x07,0x01,0x01,0x02,0x03}, oid::type::id_tc26_digest_gost3411_12_512 },
		{ {0x2a,0x85,0x03,0x07,0x01,0x01,0x03,0x02}, oid::type::id_tc26_signwithdigest_gost3410_12_256 },
		{ {0x2a,0x85,0x03,0x07,0x01,0x01,0x03,0x03}, oid::type::id_tc26_signwithdigest_gost3410_12_512 },
		{ {0x2a,0x86,0x48,0x04,0x03,0x02}, oid::type::ecdsa_with_SHA256_1_ },
		{ {0x2a,0x86,0x48,0xce,0x38,0x04,0x01}, oid::type::id_dsa },
		{ {0x2a,0x86,0x48,0xce,0x38,0x04,0x03}, oid::type::id_dsa_with_sha1 },
		{ {0x2a,0x86,0x48,0xce,0x3d}, oid::type::ansi_X9_62 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01}, oid::type::id_fieldType },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01,0x01}, oid::type::prime_field },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01,0x02}, oid::type::characteristic_two_field },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01,0x02,0x03}, oid::type::id_characteristic_two_basis },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01,0x02,0x03,0x01}, oid::type::gnBasis },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01,0x02,0x03,0x02}, oid::type::tpBasis },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x01,0x02,0x03,0x03}, oid::type::ppBasis },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x02}, oid::type::id_publicKeyType },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x02,0x01}, oid::type::id_ecPublicKey },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03}, oid::type::ellipticCurve },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00}, oid::type::c_TwoCurve },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x01}, oid::type::c2pnb163v1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x02}, oid::type::c2pnb163v2 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x03}, oid::type::c2pnb163v3 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x04}, oid::type::c2pnb176w1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x05}, oid::type::c2tnb191v1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x06}, oid::type::c2tnb191v2 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x07}, oid::type::c2tnb191v3 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x08}, oid::type::c2onb191v4 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x09}, oid::type::c2onb191v5 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x0a}, oid::type::c2pnb208w1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x0b}, oid::type::c2tnb239v1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x0c}, oid::type::c2tnb239v2 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x0d}, oid::type::c2tnb239v3 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x0e}, oid::type::c2onb239v4 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x0f}, oid::type::c2onb239v5 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x10}, oid::type::c2pnb272w1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x11}, oid::type::c2pnb304w1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x12}, oid::type::c2tnb359v1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x13}, oid::type::c2pnb368w1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x00,0x14}, oid::type::c2tnb431r1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01}, oid::type::primeCurve },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x01}, oid::type::prime192v1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x02}, oid::type::prime192v2 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x03}, oid::type::prime192v3 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x04}, oid::type::prime239v1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x05}, oid::type::prime239v2 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x06}, oid::type::prime239v3 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x07}, oid::type::prime256v1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x08}, oid::type::brainpoolP256t1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x09}, oid::type::brainpoolP320r1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x0a}, oid::type::brainpoolP320t1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x0b}, oid::type::brainpoolP384r1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x0c}, oid::type::brainpoolP384t1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x0d}, oid::type::brainpoolP512r1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x0e}, oid::type::brainpoolP512t1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x02}, oid::type::sect163r1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x03}, oid::type::sect239k1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x0a}, oid::type::secp256k1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x0f}, oid::type::sect163r2_1_ },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x10}, oid::type::sect283k1_1_ },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x11}, oid::type::sect283r1_1_ },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x1a}, oid::type::sect233k1_1_ },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x1b}, oid::type::sect233r1_1_ },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x1f}, oid::type::secp192k1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x20}, oid::type::secp224k1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x21}, oid::type::secp224r1_1_ },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x22}, oid::type::secp384r1_1_ },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x23}, oid::type::secp521r1_1_ },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x24}, oid::type::sect409k1_1_ },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x25}, oid::type::sect409r1_1_ },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x26}, oid::type::sect571k1_1_ },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x03,0x27}, oid::type::sect571r1_1_ },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x04}, oid::type::id_ecSigType },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x04,0x01}, oid::type::ecdsa_with_SHA1 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x01}, oid::type::ecdsa_with_SHA224 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x02}, oid::type::ecdsa_with_SHA256 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x03}, oid::type::ecdsa_with_SHA384 },
		{ {0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x04}, oid::type::ecdsa_with_SHA512 },
		{ {0x2a,0x86,0x48,0xce,0x3e,0x02,0x01}, oid::type::dhpublicnumber },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01}, oid::type::email_address },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01}, oid::type::rsaEncryption },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x02}, oid::type::md2WithRSAEncryption },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x04}, oid::type::md5WithRSAEncryption },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05}, oid::type::sha1WithRSAEncryption },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x07}, oid::type::id_RSAES_OAEP },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x08}, oid::type::id_mgf1 },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x09}, oid::type::id_pSpecified },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0a}, oid::type::id_RSASSA_PSS },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0b}, oid::type::sha256WithRSAEncryption },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0c}, oid::type::sha384WithRSAEncryption },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0d}, oid::type::sha512WithRSAEncryption },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0e}, oid::type::sha224WithRSAEncryption },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0f}, oid::type::sha512_224WithRSAEncryption },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x10}, oid::type::sha512_256WithRSAEncryption },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09}, oid::type::pkcs_9 },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x00}, oid::type::pkcs_9_mo },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x01}, oid::type::emailAddress },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x02}, oid::type::pkcs_9_at_unstructuredName },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x03}, oid::type::pkcs_9_at_contentType },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x04}, oid::type::pkcs_9_at_messageDigest },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x05}, oid::type::pkcs_9_at_signingTime },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x06}, oid::type::pkcs_9_at_counterSignature },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x07}, oid::type::pkcs_9_at_challengePassword },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x08}, oid::type::pkcs_9_at_unstructuredAddress },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x09}, oid::type::pkcs_9_at_extendedCertificateAttributes },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x0d}, oid::type::pkcs_9_at_signingDescription },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x0e}, oid::type::pkcs_9_at_extensionRequest },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x0f}, oid::type::pkcs_9_at_smimeCapabilities },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10}, oid::type::smime },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x02}, oid::type::id_aa },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x02,0x22}, oid::type::id_aa_cmc_unsignedData },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x14}, oid::type::pkcs_9_at_friendlyName },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x15}, oid::type::pkcs_9_at_localKeyId },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x16}, oid::type::certTypes },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x17}, oid::type::crlTypes },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x18}, oid::type::pkcs_9_oc },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x18,0x01}, oid::type::pkcs_9_oc_pkcsEntity },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x18,0x02}, oid::type::pkcs_9_oc_naturalPerson },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x19}, oid::type::pkcs_9_at },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x19,0x01}, oid::type::pkcs_9_at_pkcs15Token },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x19,0x02}, oid::type::pkcs_9_at_encryptedPrivateKeyInfo },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x19,0x03}, oid::type::pkcs_9_at_randomNonce },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x19,0x04}, oid::type::pkcs_9_at_sequenceNumber },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x19,0x05}, oid::type::pkcs_9_at_pkcs7PDU },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x1a}, oid::type::pkcs_9_sx },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x1a,0x01}, oid::type::pkcs_9_sx_pkcs9String },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x1a,0x02}, oid::type::pkcs_9_sx_signingTime },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x1b}, oid::type::pkcs_9_mr },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x1b,0x01}, oid::type::pkcs_9_mr_caseIgnoreMatch },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x1b,0x02}, oid::type::pkcs_9_mr_signingTimeMatch },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x02}, oid::type::md2 },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x05}, oid::type::md5 },
		{ {0x2a,0x86,0x48,0x86,0xf7,0x0d,0x05}, oid::type::id_md5 },
		{ {0x2b,0x06,0x01,0x04,0x01,0x09,0x15,0x02,0x03}, oid::type::Cisco_ACT2_SUDI },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x04}, oid::type::SPC_INDIRECT_DATA_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x0a}, oid::type::SPC_SP_AGENCY_INFO_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x0b}, oid::type::SPC_STATEMENT_TYPE_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x0c}, oid::type::SPC_SP_OPUS_INFO_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x0e}, oid::type::SPC_CERT_EXTENSIONS_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x0f}, oid::type::SPC_PE_IMAGE_DATA_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x12}, oid::type::SPC_RAW_FILE_DATA_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x13}, oid::type::SPC_STRUCTURED_STORAGE_DATA_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x14}, oid::type::SPC_JAVA_CLASS_DATA_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x15}, oid::type::SPC_INDIVIDUAL_SP_KEY_PURPOSE_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x16}, oid::type::SPC_COMMERCIAL_SP_KEY_PURPOSE_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x19}, oid::type::SPC_CAB_DATA_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x1a}, oid::type::SPC_MINIMAL_CRITERIA_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x1b}, oid::type::SPC_FINANCIAL_CRITERIA_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x1c}, oid::type::SPC_LINK_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x1d}, oid::type::SPC_HASH_INFO_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x01,0x1e}, oid::type::SPC_SIPINFO_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x02,0x01}, oid::type::szOID_TRUSTED_CODESIGNING_CA_LIST },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x02,0x02}, oid::type::szOID_TRUSTED_CLIENT_AUTH_CA_LIST },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x02,0x02,0x03}, oid::type::szOID_TRUSTED_SERVER_AUTH_CA_LIST },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x03,0x02,0x01}, oid::type::SPC_TIME_STAMP_REQUEST_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x01}, oid::type::OID_CTL },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x01,0x01}, oid::type::szOID_SORTED_CTL },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x02}, oid::type::szOID_NEXT_UPDATE_LOCATION },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x01}, oid::type::szOID_KP_CTL_USAGE_SIGNING },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x02}, oid::type::szOID_KP_TIME_STAMP_SIGNING },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x03}, oid::type::szOID_SERVER_GATED_CRYPTO },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x03,0x01}, oid::type::szOID_SERIALIZED },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x04}, oid::type::szOID_EFS_CRYPTO },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x04,0x01}, oid::type::szOID_EFS_RECOVERY },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x05}, oid::type::szOID_WHQL_CRYPTO },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x06}, oid::type::szOID_NT5_CRYPTO },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x07}, oid::type::szOID_OEM_WHQL_CRYPTO },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x08}, oid::type::szOID_EMBEDDED_NT_CRYPTO },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x09}, oid::type::OID_ROOT_LIST_SIGNER },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x0a}, oid::type::szOID_KP_QUALIFIED_SUBORDINATION },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x0b}, oid::type::szOID_KP_KEY_RECOVERY },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x0c}, oid::type::szOID_KP_DOCUMENT_SIGNING },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x0d}, oid::type::szOID_KP_LIFETIME_SIGNING },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x03,0x0e}, oid::type::szOID_KP_MOBILE_DEVICE_SOFTWARE },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x04,0x01}, oid::type::szOID_YESNO_TRUST_ATTR },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x05,0x01}, oid::type::szOID_DRM },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x05,0x02}, oid::type::szOID_DRM_INDIVIDUALIZATION },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x06,0x01}, oid::type::szOID_LICENSES },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x06,0x02}, oid::type::szOID_LICENSE_SERVER },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x07}, oid::type::szOID_MICROSOFT_RDN_PREFIX },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x07,0x01}, oid::type::szOID_KEYID_RDN },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x08,0x01}, oid::type::szOID_REMOVE_CERTIFICATE },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x09,0x01}, oid::type::szOID_CROSS_CERT_DIST_POINTS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0a,0x01}, oid::type::szOID_CMC_ADD_ATTRIBUTES },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b}, oid::type::szOID_CERT_PROP_ID_PREFIX },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x09}, oid::type::OID_CERT_PROP_ID_METAEKUS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x0b}, oid::type::CERT_FRIENDLY_NAME_PROP_ID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x14}, oid::type::OID_CERT_KEY_IDENTIFIER_PROP_ID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x1d}, oid::type::OID_CERT_SUBJECT_NAME_MD5_HASH_PROP_ID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x53}, oid::type::CERT_ROOT_PROGRAM_CERT_POLICIES_PROP_ID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x62}, oid::type::OID_CERT_PROP_ID_PREFIX_98 },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0b,0x69}, oid::type::OID_CERT_PROP_ID_PREFIX_105 },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0a,0x0c,0x01}, oid::type::szOID_ANY_APPLICATION_POLICY },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0c,0x01,0x01}, oid::type::szOID_CATALOG_LIST },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0c,0x01,0x02}, oid::type::szOID_CATALOG_LIST_MEMBER },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0c,0x02,0x01}, oid::type::CAT_NAMEVALUE_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0c,0x02,0x02}, oid::type::CAT_MEMBERINFO_OBJID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0d,0x01}, oid::type::szOID_RENEWAL_CERTIFICATE },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0d,0x02,0x01}, oid::type::szOID_ENROLLMENT_NAME_VALUE_PAIR },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0d,0x02,0x02}, oid::type::szOID_ENROLLMENT_CSP_PROVIDER },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x0d,0x02,0x03}, oid::type::szOID_OS_VERSION },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x10,0x04}, oid::type::szOID_MICROSOFT_Encryption_Key_Preference },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x11,0x01}, oid::type::szOID_LOCAL_MACHINE_KEYSET },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x01}, oid::type::szOID_PKIX_LICENSE_INFO },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x02}, oid::type::szOID_PKIX_MANUFACTURER },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x03}, oid::type::szOID_PKIX_MANUFACTURER_MS_SPECIFIC },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x04}, oid::type::szOID_PKIX_HYDRA_CERT_VERSION },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x05}, oid::type::szOID_PKIX_LICENSED_PRODUCT_INFO },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x06}, oid::type::szOID_PKIX_MS_LICENSE_SERVER_INFO },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x07}, oid::type::szOID_PKIS_PRODUCT_SPECIFIC_OID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x12,0x08}, oid::type::szOID_PKIS_TLSERVER_SPK_OID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x01}, oid::type::szOID_AUTO_ENROLL_CTL_USAGE },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x02}, oid::type::szOID_ENROLL_CERTTYPE_EXTENSION },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x02,0x01}, oid::type::szOID_ENROLLMENT_AGENT },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x02,0x02}, oid::type::szOID_KP_SMARTCARD_LOGON },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x02,0x03}, oid::type::szOID_NT_PRINCIPAL_NAME },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x03}, oid::type::szOID_CERT_MANIFOLD },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x01}, oid::type::szOID_CERTSRV_CA_VERSION },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x02}, oid::type::szOID_CERTSRV_PREVIOUS_CERT_HASH },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x03}, oid::type::szOID_CRL_VIRTUAL_BASE },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x04}, oid::type::szOID_CRL_NEXT_PUBLISH },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x05}, oid::type::szOID_KP_CA_EXCHANGE },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x06}, oid::type::szOID_KP_KEY_RECOVERY_AGENT },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x07}, oid::type::szOID_CERTIFICATE_TEMPLATE },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x08}, oid::type::szOID_ENTERPRISE_OID_ROOT },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x09}, oid::type::szOID_RDN_DUMMY_SIGNER },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x0a}, oid::type::szOID_APPLICATION_CERT_POLICIES },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x0b}, oid::type::szOID_APPLICATION_POLICY_MAPPINGS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x0c}, oid::type::szOID_APPLICATION_POLICY_CONSTRAINTS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x0d}, oid::type::szOID_ARCHIVED_KEY_ATTR },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x0e}, oid::type::szOID_CRL_SELF_CDP },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x0f}, oid::type::szOID_REQUIRE_CERT_CHAIN_POLICY },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x10}, oid::type::szOID_ARCHIVED_KEY_CERT_HASH },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x11}, oid::type::szOID_ISSUED_CERT_HASH },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x13}, oid::type::szOID_DS_EMAIL_REPLICATION },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x14}, oid::type::szOID_REQUEST_CLIENT_INFO },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x15}, oid::type::szOID_ENCRYPTED_KEY_HASH },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x15,0x16}, oid::type::szOID_CERTSRV_CROSSCA_VERSION },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x19,0x01}, oid::type::szOID_NTDS_REPLICATION },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x1e,0x01}, oid::type::szOID_IIS_VIRTUAL_SERVER },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x1f,0x01}, oid::type::szOID_PRODUCT_UPDATE },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x00,0x01}, oid::type::szOID_PEERNET_CERT_TYPE },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x00,0x02}, oid::type::szOID_PEERNET_PEERNAME },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x00,0x03}, oid::type::szOID_PEERNET_CLASSIFIER },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x00,0x04}, oid::type::szOID_PEERNET_CERT_VERSION },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x01}, oid::type::szOID_PEERNET_PNRP },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x01,0x01}, oid::type::szOID_PEERNET_PNRP_ADDRESS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x01,0x02}, oid::type::szOID_PEERNET_PNRP_FLAGS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x01,0x03}, oid::type::szOID_PEERNET_PNRP_PAYLOAD },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x01,0x04}, oid::type::szOID_PEERNET_PNRP_ID },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x02}, oid::type::szOID_PEERNET_IDENTITY },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x02,0x02}, oid::type::szOID_PEERNET_IDENTITY_FLAGS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x03}, oid::type::szOID_PEERNET_GROUPING },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x03,0x01}, oid::type::szOID_PEERNET_GROUPING_PEERNAME },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x03,0x02}, oid::type::szOID_PEERNET_GROUPING_FLAGS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x03,0x03}, oid::type::szOID_PEERNET_GROUPING_ROLES },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x2c,0x03,0x05}, oid::type::szOID_PEERNET_GROUPING_CLASSIFIERS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x3c,0x01,0x01}, oid::type::OID_ROOT_PROGRAM_FLAGS_BITSTRING },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x3c,0x02,0x01,0x01}, oid::type::jurisdiction_of_incorporation_locality_name },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x3c,0x02,0x01,0x02}, oid::type::jurisdiction_of_incorporation_state_or_province_name },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x3c,0x02,0x01,0x03}, oid::type::jurisdiction_of_incorporation_country_name },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x54,0x01,0x01}, oid::type::driveEncryption },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58}, oid::type::szOID_CAPICOM },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58,0x01}, oid::type::szOID_CAPICOM_VERSION },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58,0x02}, oid::type::szOID_CAPICOM_ATTRIBUTE },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58,0x02,0x01}, oid::type::szOID_CAPICOM_DOCUMENT_NAME },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58,0x02,0x02}, oid::type::szOID_CAPICOM_DOCUMENT_DESCRIPTION },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58,0x03}, oid::type::szOID_CAPICOM_ENCRYPTED_DATA },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x58,0x03,0x01}, oid::type::szOID_CAPICOM_ENCRYPTED_CONTENT },
		{ {0x2b,0x06,0x01,0x04,0x01,0x86,0x0e,0x01,0x02,0x01,0x08,0x01}, oid::type::Network_Solutions__EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0xa0,0x32,0x01,0x01}, oid::type::GlobalSign_EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0xa5,0x34,0x02,0x81,0x4a,0x01}, oid::type::D_TRUST_EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0xb1,0x3e,0x01,0x64,0x01}, oid::type::Verizon_Business_EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0xb2,0x31,0x01,0x02,0x01,0x05,0x01}, oid::type::Comodo_Group_EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0xbd,0x47,0x0d,0x18,0x01}, oid::type::T_Systems_EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0xbe,0x58,0x00,0x02,0x64,0x01,0x02}, oid::type::QuoVadis_EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0xd6,0x79,0x02,0x04,0x02}, oid::type::id_ce_SignedCertificateTimestampList },
		{ {0x2b,0x06,0x01,0x04,0x01,0xd6,0x79,0x02,0x04,0x05}, oid::type::id_ad_ocsp_SignedCertificateTimestampList },
		{ {0x2b,0x06,0x01,0x04,0x01,0xe6,0x79,0x0a,0x01,0x03,0x0a}, oid::type::Firmaprofesional_EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0xf0,0x22,0x01,0x06}, oid::type::GeoTrust_EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0xf3,0x39,0x06,0x01,0x01}, oid::type::Izenpe_EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x81,0x87,0x2e,0x0a,0x08,0x0c,0x01,0x02}, oid::type::Camerfirma_EV_CPS_1_ },
		{ {0x2b,0x06,0x01,0x04,0x01,0x81,0x87,0x2e,0x0a,0x0e,0x02,0x01,0x02}, oid::type::Camerfirma_EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x81,0xad,0x5a,0x02,0x05,0x02,0x03,0x01}, oid::type::OpenTrust_DocuSign_France_EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x81,0xb5,0x37,0x01,0x01,0x01}, oid::type::StartCom_Certification_Authority_EV_CPS_1_ },
		{ {0x2b,0x06,0x01,0x04,0x01,0x81,0xb5,0x37,0x02}, oid::type::StartCom_Certification_Authority_EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x8f,0x09,0x02,0x01}, oid::type::AffirmTrust_EV_CPS },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x8f,0x09,0x02,0x02}, oid::type::AffirmTrust_EV_CPS_1_ },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x8f,0x09,0x02,0x03}, oid::type::AffirmTrust_EV_CPS_2_ },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x8f,0x09,0x02,0x04}, oid::type::AffirmTrust_EV_CPS_3_ },
		{ {0x2b,0x06,0x01,0x04,0x01,0x82,0x9b,0x51,0x02}, oid::type::WoSign_EV_CPS },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07}, oid::type::id_pkix },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x01}, oid::type::id_pe },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x01}, oid::type::id_pe_authorityInfoAccess },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x02}, oid::type::id_pe_biometricInfo },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x03}, oid::type::id_pe_qcStatements },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x0b}, oid::type::id_pe_subjectInfoAccess },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x0c}, oid::type::id_pe_logotype },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x02}, oid::type::id_qt },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01}, oid::type::id_qt_cps },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x02}, oid::type::id_qt_unotice },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03}, oid::type::id_kp },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x01}, oid::type::id_kp_serverAuth },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x02}, oid::type::id_kp_clientAuth },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x03}, oid::type::id_kp_codeSigning },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x04}, oid::type::id_kp_emailProtection },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x05}, oid::type::id_kp_ipsecEndSystem },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x06}, oid::type::id_kp_ipsecTunnel },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x07}, oid::type::id_kp_ipsecUser },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x08}, oid::type::id_kp_timeStamping },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x09}, oid::type::id_kp_OCSPSigning },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x1b}, oid::type::id_kp_cmcCA },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x1c}, oid::type::id_kp_cmcRA },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x06,0x02}, oid::type::id_alg_noSignature },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x06,0x1e}, oid::type::id_RSASSA_PSS_SHAKE128 },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x06,0x1f}, oid::type::id_RSASSA_PSS_SHAKE256 },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x06,0x20}, oid::type::id_ecdsa_with_shake128 },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x06,0x21}, oid::type::id_ecdsa_with_shake256 },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07}, oid::type::id_cmc },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x01}, oid::type::id_cmc_statusInfo },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x02}, oid::type::id_cmc_identification },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x03}, oid::type::id_cmc_identityProof },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x04}, oid::type::id_cmc_dataReturn },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x05}, oid::type::id_cmc_transactionId },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x06}, oid::type::id_cmc_senderNonce },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x07}, oid::type::id_cmc_recipientNonce },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x08}, oid::type::id_cmc_addExtensions },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x09}, oid::type::id_cmc_encryptedPOP },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x0a}, oid::type::id_cmc_decryptedPOP },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x0b}, oid::type::id_cmc_lraPOPWitness },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x0f}, oid::type::id_cmc_getCert },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x10}, oid::type::id_cmc_getCRL },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x11}, oid::type::id_cmc_revokeRequest },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x12}, oid::type::id_cmc_regInfo },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x13}, oid::type::id_cmc_responseInfo },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x15}, oid::type::id_cmc_queryPending },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x16}, oid::type::id_cmc_popLinkRandom },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x17}, oid::type::id_cmc_popLinkWitness },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x18}, oid::type::id_cmc_confirmCertAcceptance },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x19}, oid::type::id_cmc_statusInfoV2 },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x1a}, oid::type::id_cmc_trustedAnchors },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x1b}, oid::type::id_cmc_authData },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x1c}, oid::type::id_cmc_batchRequests },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x1d}, oid::type::id_cmc_batchResponses },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x1e}, oid::type::id_cmc_publishCert },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x1f}, oid::type::id_cmc_modCertTemplate },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x20}, oid::type::id_cmc_controlProcessed },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x21}, oid::type::id_cmc_popLinkWitnessV2 },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x22}, oid::type::id_cmc_identityProofV2 },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x23}, oid::type::id_cmc_raIdentityWitness },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x24}, oid::type::id_cmc_changeSubjectName },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x07,0x25}, oid::type::id_cmc_responseBody },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x08}, oid::type::id_on },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x08,0x09}, oid::type::id_on_SmtpUTF8Mailbox },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x09}, oid::type::ietf_at },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x01}, oid::type::pkcs_9_at_dateOfBirth },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x02}, oid::type::pkcs_9_at_placeOfBirth },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x03}, oid::type::pkcs_9_at_gender },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x04}, oid::type::pkcs_9_at_countryOfCitizenship },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x05}, oid::type::pkcs_9_at_countryOfResidence },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x0b}, oid::type::id_qcs },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x0b,0x01}, oid::type::id_qcs_pkixQCSyntax_v1 },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x0b,0x02}, oid::type::id_qcs_pkixQCSyntax_v2 },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x0c}, oid::type::id_cct },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x0c,0x02}, oid::type::id_cct_PKIData },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x0c,0x03}, oid::type::id_cct_PKIResponse },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x14}, oid::type::id_logo },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x14,0x01}, oid::type::id_logo_loyalty },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x14,0x02}, oid::type::id_logo_background },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30}, oid::type::id_ad },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01}, oid::type::id_ad_ocsp },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x01}, oid::type::id_pkix_ocsp_basic },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x02}, oid::type::id_pkix_ocsp_nonce },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x03}, oid::type::id_pkix_ocsp_crl },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x04}, oid::type::id_pkix_ocsp_response },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x05}, oid::type::id_pkix_ocsp_nocheck },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x06}, oid::type::id_pkix_ocsp_archive_cutoff },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x07}, oid::type::id_pkix_ocsp_service_locator },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x08}, oid::type::id_pkix_ocsp_pref_sig_algs },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x09}, oid::type::id_pkix_ocsp_extended_revoke },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x02}, oid::type::id_ad_caIssuers },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x03}, oid::type::id_ad_timeStamping },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x05}, oid::type::id_ad_caRepository },
		{ {0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x0c}, oid::type::id_ad_cmc },
		{ {0x2b,0x0e,0x03,0x02,0x0f}, oid::type::id_sha_with_rsa_signature },
		{ {0x2b,0x0e,0x03,0x02,0x1a}, oid::type::id_sha1 },
		{ {0x2b,0x0e,0x03,0x02,0x1d}, oid::type::sha_1WithRSAEncryption },
		{ {0x2b,0x24,0x03,0x03,0x02,0x08}, oid::type::ecStdCurvesAndGeneration },
		{ {0x2b,0x24,0x03,0x03,0x02,0x08,0x01}, oid::type::ellipticCurve_1_ },
		{ {0x2b,0x65}, oid::type::id_edwards_curve_algs },
		{ {0x2b,0x65,0x6e}, oid::type::id_X25519 },
		{ {0x2b,0x65,0x6f}, oid::type::id_X448 },
		{ {0x2b,0x65,0x70}, oid::type::id_Ed25519 },
		{ {0x2b,0x65,0x71}, oid::type::id_Ed448 },
		{ {0x2b,0x81,0x04}, oid::type::certicom_arc },
		{ {0x2b,0x81,0x04,0x00}, oid::type::ellipticCurve_2_ },
		{ {0x2b,0x81,0x04,0x00,0x01}, oid::type::sect163k1 },
		{ {0x2b,0x81,0x04,0x00,0x0f}, oid::type::sect163r2 },
		{ {0x2b,0x81,0x04,0x00,0x10}, oid::type::sect283k1 },
		{ {0x2b,0x81,0x04,0x00,0x11}, oid::type::sect283r1 },
		{ {0x2b,0x81,0x04,0x00,0x1a}, oid::type::sect233k1 },
		{ {0x2b,0x81,0x04,0x00,0x1b}, oid::type::sect233r1 },
		{ {0x2b,0x81,0x04,0x00,0x21}, oid::type::secp224r1 },
		{ {0x2b,0x81,0x04,0x00,0x22}, oid::type::secp384r1 },
		{ {0x2b,0x81,0x04,0x00,0x23}, oid::type::secp521r1 },
		{ {0x2b,0x81,0x04,0x00,0x24}, oid::type::sect409k1 },
		{ {0x2b,0x81,0x04,0x00,0x25}, oid::type::sect409r1 },
		{ {0x2b,0x81,0x04,0x00,0x26}, oid::type::sect571k1 },
		{ {0x2b,0x81,0x04,0x00,0x27}, oid::type::sect571r1 },
		{ {0x2b,0x81,0x04,0x01,0x0c}, oid::type::id_ecDH },
		{ {0x2b,0x81,0x04,0x01,0x0d}, oid::type::id_ecMQV },
		{ {0x2b,0x81,0x1f,0x01,0x11,0x01}, oid::type::Actalis_EV_CPS },
		{ {0x52,0x86,0x48,0xce,0x38,0x02}, oid::type::holdInstruction },
		{ {0x52,0x86,0x48,0xce,0x38,0x02,0x01}, oid::type::id_holdinstruction_none },
		{ {0x52,0x86,0x48,0xce,0x38,0x02,0x02}, oid::type::id_holdinstruction_callissuer },
		{ {0x52,0x86,0x48,0xce,0x38,0x02,0x03}, oid::type::id_holdinstruction_reject },
		{ {0x55,0x04}, oid::type::id_at },
		{ {0x55,0x04,0x03}, oid::type::common_name },
		{ {0x55,0x04,0x04}, oid::type::surname },
		{ {0x55,0x04,0x05}, oid::type::serial_number },
		{ {0x55,0x04,0x06}, oid::type::country_name },
		{ {0x55,0x04,0x07}, oid::type::locality_name },
		{ {0x55,0x04,0x08}, oid::type::state_or_province_name },
		{ {0x55,0x04,0x09}, oid::type::street },
		{ {0x55,0x04,0x0a}, oid::type::organization_name },
		{ {0x55,0x04,0x0b}, oid::type::organizational_unit_name },
		{ {0x55,0x04,0x0c}, oid::type::title },
		{ {0x55,0x04,0x0d}, oid::type::description },
		{ {0x55,0x04,0x0e}, oid::type::search_guide },
		{ {0x55,0x04,0x0f}, oid::type::business_category },
		{ {0x55,0x04,0x10}, oid::type::postal_address },
		{ {0x55,0x04,0x11}, oid::type::postal_code },
		{ {0x55,0x04,0x12}, oid::type::post_office_box },
		{ {0x55,0x04,0x13}, oid::type::physical_delivery_office_name },
		{ {0x55,0x04,0x14}, oid::type::telephone_number },
		{ {0x55,0x04,0x15}, oid::type::telex_number },
		{ {0x55,0x04,0x16}, oid::type::teletex_terminal_identifier },
		{ {0x55,0x04,0x17}, oid::type::facsimile_telephone_number },
		{ {0x55,0x04,0x18}, oid::type::x121_address },
		{ {0x55,0x04,0x19}, oid::type::international_isdn_number },
		{ {0x55,0x04,0x1a}, oid::type::registered_address },
		{ {0x55,0x04,0x1b}, oid::type::destination_indicator },
		{ {0x55,0x04,0x1c}, oid::type::preferred_delivery_method },
		{ {0x55,0x04,0x1f}, oid::type::member },
		{ {0x55,0x04,0x20}, oid::type::owner },
		{ {0x55,0x04,0x21}, oid::type::role_occupant },
		{ {0x55,0x04,0x22}, oid::type::see_also },
		{ {0x55,0x04,0x23}, oid::type::user_password },
		{ {0x55,0x04,0x29}, oid::type::name },
		{ {0x55,0x04,0x2a}, oid::type::given_name },
		{ {0x55,0x04,0x2b}, oid::type::initials },
		{ {0x55,0x04,0x2c}, oid::type::generation_qualifier },
		{ {0x55,0x04,0x2d}, oid::type::x500_unique_identifier },
		{ {0x55,0x04,0x2e}, oid::type::dn_qualifier },
		{ {0x55,0x04,0x2f}, oid::type::enhanced_search_guide },
		{ {0x55,0x04,0x31}, oid::type::distinguished_name },
		{ {0x55,0x04,0x32}, oid::type::unique_member },
		{ {0x55,0x04,0x33}, oid::type::house_identifier },
		{ {0x55,0x04,0x41}, oid::type::pseudonym },
		{ {0x55,0x1d}, oid::type::id_ce },
		{ {0x55,0x1d,0x01}, oid::type::DeprecatedAuthorityKeyIdentifier },
		{ {0x55,0x1d,0x07}, oid::type::DeprecatedSubjectAltName },
		{ {0x55,0x1d,0x09}, oid::type::id_ce_subjectDirectoryAttributes },
		{ {0x55,0x1d,0x0e}, oid::type::id_ce_subjectKeyIdentifier },
		{ {0x55,0x1d,0x0f}, oid::type::key_usage },
		{ {0x55,0x1d,0x10}, oid::type::id_ce_privateKeyUsagePeriod },
		{ {0x55,0x1d,0x11}, oid::type::subject_alt_name },
		{ {0x55,0x1d,0x12}, oid::type::id_ce_issuerAltName },
		{ {0x55,0x1d,0x13}, oid::type::id_ce_basicConstraints },
		{ {0x55,0x1d,0x14}, oid::type::id_ce_cRLNumber },
		{ {0x55,0x1d,0x15}, oid::type::id_ce_reasonCode },
		{ {0x55,0x1d,0x17}, oid::type::id_ce_instructionCode },
		{ {0x55,0x1d,0x18}, oid::type::id_ce_invalidityDate },
		{ {0x55,0x1d,0x1b}, oid::type::id_ce_deltaCRLIndicator },
		{ {0x55,0x1d,0x1c}, oid::type::id_ce_issuingDistributionPoint },
		{ {0x55,0x1d,0x1d}, oid::type::id_ce_certificateIssuer },
		{ {0x55,0x1d,0x1e}, oid::type::id_ce_nameConstraints },
		{ {0x55,0x1d,0x1f}, oid::type::id_ce_cRLDistributionPoints },
		{ {0x55,0x1d,0x20}, oid::type::id_ce_certificatePolicies },
		{ {0x55,0x1d,0x20,0x00}, oid::type::anyPolicy },
		{ {0x55,0x1d,0x21}, oid::type::id_ce_policyMappings },
		{ {0x55,0x1d,0x22}, oid::type::DeprecatedpolicyConstraints },
		{ {0x55,0x1d,0x23}, oid::type::id_ce_authorityKeyIdentifier },
		{ {0x55,0x1d,0x24}, oid::type::id_ce_policyConstraints },
		{ {0x55,0x1d,0x25}, oid::type::ext_key_usage },
		{ {0x55,0x1d,0x25,0x00}, oid::type::anyExtendedKeyUsage },
		{ {0x55,0x1d,0x2e}, oid::type::id_ce_freshestCRL },
		{ {0x55,0x1d,0x36}, oid::type::id_ce_inhibitAnyPolicy },
		{ {0x60,0x84,0x10,0x01,0x87,0x69,0x01,0x01,0x01,0x0c,0x06,0x01,0x01,0x01}, oid::type::DigiNotar_EV_CPS },
		{ {0x60,0x84,0x10,0x01,0x87,0x6b,0x01,0x02,0x07}, oid::type::Logius_PKIoverheid_EV_CPS },
		{ {0x60,0x84,0x42,0x01,0x1a,0x01,0x03,0x03}, oid::type::Buypass_EV_CPS },
		{ {0x60,0x85,0x74,0x01,0x53,0x15,0x00}, oid::type::Swisscom_EV_CPS },
		{ {0x60,0x85,0x74,0x01,0x59,0x01,0x02,0x01,0x01}, oid::type::SwissSign_EV_CPS },
		{ {0x60,0x86,0x18,0x01,0x02,0x01,0x01,0x05,0x07,0x01,0x09}, oid::type::Kamu_Sertifikasyon_Merkezi_EV_CPS },
		{ {0x60,0x86,0x18,0x03,0x00,0x04,0x01,0x01,0x04}, oid::type::E_Tugra_EV_CPS },
		{ {0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x01,0x16}, oid::type::id_keyExchangeAlgorithm },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02}, oid::type::hashAlgs },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x01}, oid::type::id_sha256 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x02}, oid::type::id_sha384 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x03}, oid::type::id_sha512 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x04}, oid::type::id_sha224 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0b}, oid::type::id_shake128 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0c}, oid::type::id_shake256 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0d}, oid::type::id_hmacWithSHA3_224 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0e}, oid::type::id_hmacWithSHA3_256 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0f}, oid::type::id_hmacWithSHA3_384 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x10}, oid::type::id_hmacWithSHA3_512 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x13}, oid::type::id_KmacWithSHAKE128 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x14}, oid::type::id_KmacWithSHAKE256 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03}, oid::type::sigAlgs },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x01}, oid::type::id_dsa_with_sha224 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x02}, oid::type::id_dsa_with_sha256 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x09}, oid::type::id_ecdsa_with_sha3_224 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0a}, oid::type::id_ecdsa_with_sha3_256 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0b}, oid::type::id_ecdsa_with_sha3_384 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0c}, oid::type::id_ecdsa_with_sha3_512 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0d}, oid::type::id_rsassa_pkcs1_v1_5_with_sha3_224 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0e}, oid::type::id_rsassa_pkcs1_v1_5_with_sha3_256 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0f}, oid::type::id_rsassa_pkcs1_v1_5_with_sha3_384 },
		{ {0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x10}, oid::type::id_rsassa_pkcs1_v1_5_with_sha3_512 },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01}, oid::type::NetscapeCertificateExtension },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01}, oid::type::NetscapeCertType },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x03}, oid::type::RevocationURL },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x04}, oid::type::CaRevocationURL },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x0c}, oid::type::SSLServerName },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x0d}, oid::type::NetscapeCertificateComment },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x03,0x01,0x81,0x58}, oid::type::pkcs_9_at_userPKCS12 },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x17,0x06}, oid::type::Symantec_EV_CPS },
		{ {0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x30,0x01}, oid::type::Thawte_EV_CPS },
		{ {0x60,0x86,0x48,0x01,0x86,0xfa,0x6c,0x0a,0x01,0x02}, oid::type::Entrust_EV_CPS },
		{ {0x60,0x86,0x48,0x01,0x86,0xfb,0x7b,0x83,0x74,0x09}, oid::type::Wells_Fargo_EV_CPS },
		{ {0x60,0x86,0x48,0x01,0x86,0xfd,0x64,0x01,0x01,0x02,0x04,0x01}, oid::type::Trustwave_EV_CPS },
		{ {0x60,0x86,0x48,0x01,0x86,0xfd,0x6c,0x01,0x03,0x00,0x02}, oid::type::DigiCert_EV_CPS_1_ },
		{ {0x60,0x86,0x48,0x01,0x86,0xfd,0x6c,0x02,0x01}, oid::type::DigiCert_EV_CPS },
		{ {0x60,0x86,0x48,0x01,0x86,0xfd,0x6d,0x01,0x07,0x17,0x03}, oid::type::Go_Daddy_EV_CPS },
		{ {0x60,0x86,0x48,0x01,0x86,0xfd,0x6e,0x01,0x07,0x17,0x03}, oid::type::Starfield_Technologies_EV_CPS },
	};
	return oid_to_enum;
}
