// tacacs_plus_params.hpp
//
// this file was autogenerated at 2025-04-04T14:45:34Z
// you should edit the source file(s) instead of this one
//
// source files:
//     tac_plus_authen_action.csv
//     tac_plus_authen_type.csv
//     tac_plus_authen_service.csv
//     tac_plus_authen_status.csv
//     tac_plus_authen_meth.csv
//     tac_plus_author_status.csv
//     tac_plus_acct_status.csv
//     tac_plus_priv_lvl.csv
//

#ifndef TACACS_PLUS_PARAMS_HPP
#define TACACS_PLUS_PARAMS_HPP

template <typename T>
class authen_action : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("authen_action", encoded<T>::value());
        } else {
            o.print_key_string("authen_action", name);
        }
    }
    enum code {
        LOGIN    = 0x01,
        CHPASS   = 0x02,
        SENDAUTH = 0x04,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case LOGIN:    return "LOGIN";
        case CHPASS:   return "CHPASS";
        case SENDAUTH: return "SENDAUTH";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class authen_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("authen_type", encoded<T>::value());
        } else {
            o.print_key_string("authen_type", name);
        }
    }
    enum code {
        ASCII    = 0x01,
        PAP      = 0x02,
        CHAP     = 0x03,
        MSCHAP   = 0x05,
        MSCHAPV2 = 0x06,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case ASCII:    return "ASCII";
        case PAP:      return "PAP";
        case CHAP:     return "CHAP";
        case MSCHAP:   return "MSCHAP";
        case MSCHAPV2: return "MSCHAPV2";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class authen_service : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("authen_service", encoded<T>::value());
        } else {
            o.print_key_string("authen_service", name);
        }
    }
    enum code {
        NONE    = 0x00,
        LOGIN   = 0x01,
        ENABLE  = 0x02,
        PPP     = 0x03,
        PT      = 0x05,
        RCMD    = 0x06,
        X25     = 0x07,
        NASI    = 0x08,
        FWPROXY = 0x09,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case NONE:    return "NONE";
        case LOGIN:   return "LOGIN";
        case ENABLE:  return "ENABLE";
        case PPP:     return "PPP";
        case PT:      return "PT";
        case RCMD:    return "RCMD";
        case X25:     return "X25";
        case NASI:    return "NASI";
        case FWPROXY: return "FWPROXY";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class authen_status : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("authen_status", encoded<T>::value());
        } else {
            o.print_key_string("authen_status", name);
        }
    }
    enum code {
        PASS    = 0x01,
        FAIL    = 0x02,
        GETDATA = 0x03,
        GETUSER = 0x04,
        GETPASS = 0x05,
        RESTART = 0x06,
        ERROR   = 0x07,
        FOLLOW  = 0x21,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case PASS:    return "PASS";
        case FAIL:    return "FAIL";
        case GETDATA: return "GETDATA";
        case GETUSER: return "GETUSER";
        case GETPASS: return "GETPASS";
        case RESTART: return "RESTART";
        case ERROR:   return "ERROR";
        case FOLLOW:  return "FOLLOW";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class authen_meth : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("authen_meth", encoded<T>::value());
        } else {
            o.print_key_string("authen_meth", name);
        }
    }
    enum code {
        NOT_SET    = 0x00,
        NONE       = 0x01,
        KRB5       = 0x02,
        LINE       = 0x03,
        ENABLE     = 0x04,
        LOCAL      = 0x05,
        TACACSPLUS = 0x06,
        GUEST      = 0x08,
        RADIUS     = 0x10,
        KRB4       = 0x11,
        RCMD       = 0x20,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case NOT_SET:    return "NOT_SET";
        case NONE:       return "NONE";
        case KRB5:       return "KRB5";
        case LINE:       return "LINE";
        case ENABLE:     return "ENABLE";
        case LOCAL:      return "LOCAL";
        case TACACSPLUS: return "TACACSPLUS";
        case GUEST:      return "GUEST";
        case RADIUS:     return "RADIUS";
        case KRB4:       return "KRB4";
        case RCMD:       return "RCMD";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class author_status : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("author_status", encoded<T>::value());
        } else {
            o.print_key_string("author_status", name);
        }
    }
    enum code {
        PASS_ADD  = 0x01,
        PASS_REPL = 0x02,
        FAIL      = 0x10,
        ERROR     = 0x11,
        FOLLOW    = 0x21,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case PASS_ADD:  return "PASS_ADD";
        case PASS_REPL: return "PASS_REPL";
        case FAIL:      return "FAIL";
        case ERROR:     return "ERROR";
        case FOLLOW:    return "FOLLOW";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class acct_status : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("acct_status", encoded<T>::value());
        } else {
            o.print_key_string("acct_status", name);
        }
    }
    enum code {
        SUCCESS = 0x01,
        ERROR   = 0x02,
        FOLLOW  = 0x21,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case SUCCESS: return "SUCCESS";
        case ERROR:   return "ERROR";
        case FOLLOW:  return "FOLLOW";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class privilege_level : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("privilege_level", encoded<T>::value());
        } else {
            o.print_key_string("privilege_level", name);
        }
    }
    enum code {
        MIN  = 0x00,
        USER = 0x01,
        ROOT = 0x0f,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case MIN:  return "MIN";
        case USER: return "USER";
        case ROOT: return "ROOT";
        default:
            ;
        }
        return nullptr;
    }
};


#endif // TACACS_PLUS_PARAMS_HPP

