#! /usr/bin/env python2

import requests
import lxml.html
import sys

r = requests.get(sys.argv[1])
tree = lxml.html.fromstring(r.text)

try:
	
	vulntable = tree.xpath('//table[@id="vulnprodstable"]/*')
	list_len  = len(vulntable)

	tuple_list = []
	
	for i in vulntable[2:list_len]:
		java_v = (i.getchildren()[4].text.strip(), i.getchildren()[5].text.strip()[6:].strip())
		tuple_list.append(java_v)

except IndexError:
	pass

string_list = []
for v in sorted(set(tuple_list)):
	version, update = v
	if update:
		string_list.append("{}.{}".format(version, update))
	else:
		string_list.append(version)

print ', '.join(string_list)