/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableBiMapFauxverideShim;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableBiMap;
import com.google.common.collect.SingletonImmutableBiMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableBiMap<K, V>
extends ImmutableBiMapFauxverideShim<K, V>
implements BiMap<K, V> {
    public static <T, K, V> Collector<T, ?, ImmutableBiMap<K, V>> toImmutableBiMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return CollectCollectors.toImmutableBiMap(keyFunction, valueFunction);
    }

    public static <K, V> ImmutableBiMap<K, V> of() {
        return RegularImmutableBiMap.EMPTY;
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12) {
        return new SingletonImmutableBiMap<K, V>(k12, v12);
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12, K k22, V v22) {
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k12, v12), ImmutableBiMap.entryOf(k22, v22));
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12, K k22, V v22, K k32, V v32) {
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k12, v12), ImmutableBiMap.entryOf(k22, v22), ImmutableBiMap.entryOf(k32, v32));
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12, K k22, V v22, K k32, V v32, K k42, V v42) {
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k12, v12), ImmutableBiMap.entryOf(k22, v22), ImmutableBiMap.entryOf(k32, v32), ImmutableBiMap.entryOf(k42, v42));
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12, K k22, V v22, K k32, V v32, K k42, V v42, K k52, V v52) {
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k12, v12), ImmutableBiMap.entryOf(k22, v22), ImmutableBiMap.entryOf(k32, v32), ImmutableBiMap.entryOf(k42, v42), ImmutableBiMap.entryOf(k52, v52));
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12, K k22, V v22, K k32, V v32, K k42, V v42, K k52, V v52, K k62, V v62) {
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k12, v12), ImmutableBiMap.entryOf(k22, v22), ImmutableBiMap.entryOf(k32, v32), ImmutableBiMap.entryOf(k42, v42), ImmutableBiMap.entryOf(k52, v52), ImmutableBiMap.entryOf(k62, v62));
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12, K k22, V v22, K k32, V v32, K k42, V v42, K k52, V v52, K k62, V v62, K k72, V v72) {
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k12, v12), ImmutableBiMap.entryOf(k22, v22), ImmutableBiMap.entryOf(k32, v32), ImmutableBiMap.entryOf(k42, v42), ImmutableBiMap.entryOf(k52, v52), ImmutableBiMap.entryOf(k62, v62), ImmutableBiMap.entryOf(k72, v72));
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12, K k22, V v22, K k32, V v32, K k42, V v42, K k52, V v52, K k62, V v62, K k72, V v72, K k82, V v82) {
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k12, v12), ImmutableBiMap.entryOf(k22, v22), ImmutableBiMap.entryOf(k32, v32), ImmutableBiMap.entryOf(k42, v42), ImmutableBiMap.entryOf(k52, v52), ImmutableBiMap.entryOf(k62, v62), ImmutableBiMap.entryOf(k72, v72), ImmutableBiMap.entryOf(k82, v82));
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12, K k22, V v22, K k32, V v32, K k42, V v42, K k52, V v52, K k62, V v62, K k72, V v72, K k82, V v82, K k92, V v92) {
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k12, v12), ImmutableBiMap.entryOf(k22, v22), ImmutableBiMap.entryOf(k32, v32), ImmutableBiMap.entryOf(k42, v42), ImmutableBiMap.entryOf(k52, v52), ImmutableBiMap.entryOf(k62, v62), ImmutableBiMap.entryOf(k72, v72), ImmutableBiMap.entryOf(k82, v82), ImmutableBiMap.entryOf(k92, v92));
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12, K k22, V v22, K k32, V v32, K k42, V v42, K k52, V v52, K k62, V v62, K k72, V v72, K k82, V v82, K k92, V v92, K k102, V v102) {
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k12, v12), ImmutableBiMap.entryOf(k22, v22), ImmutableBiMap.entryOf(k32, v32), ImmutableBiMap.entryOf(k42, v42), ImmutableBiMap.entryOf(k52, v52), ImmutableBiMap.entryOf(k62, v62), ImmutableBiMap.entryOf(k72, v72), ImmutableBiMap.entryOf(k82, v82), ImmutableBiMap.entryOf(k92, v92), ImmutableBiMap.entryOf(k102, v102));
    }

    @SafeVarargs
    public static <K, V> ImmutableBiMap<K, V> ofEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        Map.Entry<? extends K, ? extends V>[] entries2 = entries;
        return RegularImmutableBiMap.fromEntries(entries2);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> Builder<K, V> builderWithExpectedSize(int expectedSize) {
        CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
        return new Builder(expectedSize);
    }

    public static <K, V> ImmutableBiMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        ImmutableBiMap bimap;
        if (map instanceof ImmutableBiMap && !(bimap = (ImmutableBiMap)map).isPartialView()) {
            return bimap;
        }
        return ImmutableBiMap.copyOf(map.entrySet());
    }

    public static <K, V> ImmutableBiMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        Map.Entry[] entryArray = Iterables.toArray(entries, EMPTY_ENTRY_ARRAY);
        switch (entryArray.length) {
            case 0: {
                return ImmutableBiMap.of();
            }
            case 1: {
                Map.Entry entry = entryArray[0];
                return ImmutableBiMap.of(entry.getKey(), entry.getValue());
            }
        }
        return RegularImmutableBiMap.fromEntries(entryArray);
    }

    ImmutableBiMap() {
    }

    @Override
    public abstract ImmutableBiMap<V, K> inverse();

    @Override
    public ImmutableSet<V> values() {
        return ((ImmutableMap)((Object)this.inverse())).keySet();
    }

    @Override
    final ImmutableSet<V> createValues() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final V forcePut(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @J2ktIncompatible
    Object writeReplace() {
        return new SerializedForm(this);
    }

    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @J2ktIncompatible
    private static class SerializedForm<K, V>
    extends ImmutableMap.SerializedForm<K, V> {
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableBiMap<K, V> bimap) {
            super(bimap);
        }

        @Override
        Builder<K, V> makeBuilder(int size) {
            return new Builder(size);
        }
    }

    public static final class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        public Builder() {
        }

        Builder(int size) {
            super(size);
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> put(K key, V value) {
            super.put(key, value);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            super.put(entry);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            super.putAll(map);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            super.putAll(entries);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> orderEntriesByValue(Comparator<? super V> valueComparator) {
            super.orderEntriesByValue(valueComparator);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        Builder<K, V> combine(ImmutableMap.Builder<K, V> builder) {
            super.combine(builder);
            return this;
        }

        @Override
        public ImmutableBiMap<K, V> build() {
            return this.buildOrThrow();
        }

        @Override
        public ImmutableBiMap<K, V> buildOrThrow() {
            switch (this.size) {
                case 0: {
                    return ImmutableBiMap.of();
                }
                case 1: {
                    Map.Entry onlyEntry = Objects.requireNonNull(this.entries[0]);
                    return ImmutableBiMap.of(onlyEntry.getKey(), onlyEntry.getValue());
                }
            }
            if (this.valueComparator != null) {
                if (this.entriesUsed) {
                    this.entries = Arrays.copyOf(this.entries, this.size);
                }
                Arrays.sort(this.entries, 0, this.size, Ordering.from(this.valueComparator).onResultOf(Maps.valueFunction()));
            }
            this.entriesUsed = true;
            return RegularImmutableBiMap.fromEntryArray(this.size, this.entries);
        }

        @Override
        @Deprecated
        @DoNotCall
        public ImmutableBiMap<K, V> buildKeepingLast() {
            throw new UnsupportedOperationException("Not supported for bimaps");
        }

        @Override
        @VisibleForTesting
        ImmutableBiMap<K, V> buildJdkBacked() {
            Preconditions.checkState(this.valueComparator == null, "buildJdkBacked is for tests only, doesn't support orderEntriesByValue");
            switch (this.size) {
                case 0: {
                    return ImmutableBiMap.of();
                }
                case 1: {
                    Map.Entry onlyEntry = Objects.requireNonNull(this.entries[0]);
                    return ImmutableBiMap.of(onlyEntry.getKey(), onlyEntry.getValue());
                }
            }
            this.entriesUsed = true;
            return RegularImmutableBiMap.fromEntryArray(this.size, this.entries);
        }
    }
}

