/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleUtils;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.concurrent.LazyInit;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public abstract class LinearTransformation {
    public static LinearTransformationBuilder mapping(double x12, double y12) {
        Preconditions.checkArgument(DoubleUtils.isFinite(x12) && DoubleUtils.isFinite(y12));
        return new LinearTransformationBuilder(x12, y12);
    }

    public static LinearTransformation vertical(double x11) {
        Preconditions.checkArgument(DoubleUtils.isFinite(x11));
        return new VerticalLinearTransformation(x11);
    }

    public static LinearTransformation horizontal(double y11) {
        Preconditions.checkArgument(DoubleUtils.isFinite(y11));
        double slope = 0.0;
        return new RegularLinearTransformation(slope, y11);
    }

    public static LinearTransformation forNaN() {
        return NaNLinearTransformation.INSTANCE;
    }

    public abstract boolean isVertical();

    public abstract boolean isHorizontal();

    public abstract double slope();

    public abstract double transform(double var1);

    public abstract LinearTransformation inverse();

    private static final class NaNLinearTransformation
    extends LinearTransformation {
        static final NaNLinearTransformation INSTANCE = new NaNLinearTransformation();

        private NaNLinearTransformation() {
        }

        @Override
        public boolean isVertical() {
            return false;
        }

        @Override
        public boolean isHorizontal() {
            return false;
        }

        @Override
        public double slope() {
            return Double.NaN;
        }

        @Override
        public double transform(double x11) {
            return Double.NaN;
        }

        @Override
        public LinearTransformation inverse() {
            return this;
        }

        public String toString() {
            return "NaN";
        }
    }

    private static final class VerticalLinearTransformation
    extends LinearTransformation {
        final double x;
        @CheckForNull
        @LazyInit
        LinearTransformation inverse;

        VerticalLinearTransformation(double x11) {
            this.x = x11;
            this.inverse = null;
        }

        VerticalLinearTransformation(double x11, LinearTransformation inverse) {
            this.x = x11;
            this.inverse = inverse;
        }

        @Override
        public boolean isVertical() {
            return true;
        }

        @Override
        public boolean isHorizontal() {
            return false;
        }

        @Override
        public double slope() {
            throw new IllegalStateException();
        }

        @Override
        public double transform(double x11) {
            throw new IllegalStateException();
        }

        @Override
        public LinearTransformation inverse() {
            LinearTransformation result = this.inverse;
            return result == null ? (this.inverse = this.createInverse()) : result;
        }

        public String toString() {
            return String.format("x = %g", this.x);
        }

        private LinearTransformation createInverse() {
            return new RegularLinearTransformation(0.0, this.x, this);
        }
    }

    private static final class RegularLinearTransformation
    extends LinearTransformation {
        final double slope;
        final double yIntercept;
        @CheckForNull
        @LazyInit
        LinearTransformation inverse;

        RegularLinearTransformation(double slope, double yIntercept) {
            this.slope = slope;
            this.yIntercept = yIntercept;
            this.inverse = null;
        }

        RegularLinearTransformation(double slope, double yIntercept, LinearTransformation inverse) {
            this.slope = slope;
            this.yIntercept = yIntercept;
            this.inverse = inverse;
        }

        @Override
        public boolean isVertical() {
            return false;
        }

        @Override
        public boolean isHorizontal() {
            return this.slope == 0.0;
        }

        @Override
        public double slope() {
            return this.slope;
        }

        @Override
        public double transform(double x11) {
            return x11 * this.slope + this.yIntercept;
        }

        @Override
        public LinearTransformation inverse() {
            LinearTransformation result = this.inverse;
            return result == null ? (this.inverse = this.createInverse()) : result;
        }

        public String toString() {
            return String.format("y = %g * x + %g", this.slope, this.yIntercept);
        }

        private LinearTransformation createInverse() {
            if (this.slope != 0.0) {
                return new RegularLinearTransformation(1.0 / this.slope, -1.0 * this.yIntercept / this.slope, this);
            }
            return new VerticalLinearTransformation(this.yIntercept, this);
        }
    }

    public static final class LinearTransformationBuilder {
        private final double x1;
        private final double y1;

        private LinearTransformationBuilder(double x12, double y12) {
            this.x1 = x12;
            this.y1 = y12;
        }

        public LinearTransformation and(double x22, double y22) {
            Preconditions.checkArgument(DoubleUtils.isFinite(x22) && DoubleUtils.isFinite(y22));
            if (x22 == this.x1) {
                Preconditions.checkArgument(y22 != this.y1);
                return new VerticalLinearTransformation(this.x1);
            }
            return this.withSlope((y22 - this.y1) / (x22 - this.x1));
        }

        public LinearTransformation withSlope(double slope) {
            Preconditions.checkArgument(!Double.isNaN(slope));
            if (DoubleUtils.isFinite(slope)) {
                double yIntercept = this.y1 - this.x1 * slope;
                return new RegularLinearTransformation(slope, yIntercept);
            }
            return new VerticalLinearTransformation(this.x1);
        }
    }
}

