/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.keys.resolvers;

import java.security.Key;
import java.util.List;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.DecryptionJwkSelector;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.DecryptionKeyResolver;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.UnresolvableKeyException;

public class JwksDecryptionKeyResolver
implements DecryptionKeyResolver {
    private final List<JsonWebKey> jsonWebKeys;
    private final DecryptionJwkSelector selector = new DecryptionJwkSelector();
    boolean disambiguateWithAttemptDecrypt;

    public JwksDecryptionKeyResolver(List<JsonWebKey> jsonWebKeys) {
        this.jsonWebKeys = jsonWebKeys;
    }

    @Override
    public Key resolveKey(JsonWebEncryption jwe, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        JsonWebKey selected;
        try {
            List<JsonWebKey> selectedList = this.selector.selectList(jwe, this.jsonWebKeys);
            if (selectedList.isEmpty()) {
                selected = null;
            } else if (selectedList.size() == 1 || !this.disambiguateWithAttemptDecrypt) {
                selected = selectedList.get(0);
            } else {
                selected = this.selector.attemptDecryptDisambiguate(jwe, selectedList);
                if (selected == null) {
                    StringBuilder sb2 = new StringBuilder();
                    sb2.append("Unable to find a suitable key for JWE w/ header ").append(jwe.getHeaders().getFullHeaderAsJsonString());
                    sb2.append(" using attempted decryption to disambiguate from filtered candidate JWKs ").append(this.jsonWebKeys);
                    throw new UnresolvableKeyException(sb2.toString());
                }
            }
        }
        catch (JoseException e11) {
            StringBuilder sb3 = new StringBuilder();
            sb3.append("Unable to find a suitable key for JWE w/ header ").append(jwe.getHeaders().getFullHeaderAsJsonString());
            sb3.append(" due to an unexpected exception (").append(e11).append(") selecting from keys: ").append(this.jsonWebKeys);
            throw new UnresolvableKeyException(sb3.toString(), e11);
        }
        if (selected == null) {
            StringBuilder sb4 = new StringBuilder();
            sb4.append("Unable to find a suitable key for JWE w/ header ").append(jwe.getHeaders().getFullHeaderAsJsonString());
            sb4.append(" from JWKs ").append(this.jsonWebKeys);
            throw new UnresolvableKeyException(sb4.toString());
        }
        return selected instanceof PublicJsonWebKey ? ((PublicJsonWebKey)selected).getPrivateKey() : selected.getKey();
    }

    public void setDisambiguateWithAttemptDecrypt(boolean disambiguateWithAttemptDecrypt) {
        this.disambiguateWithAttemptDecrypt = disambiguateWithAttemptDecrypt;
    }
}

