/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Internal;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

abstract class AbstractProtobufList<E>
extends AbstractList<E>
implements Internal.ProtobufList<E> {
    protected static final int DEFAULT_CAPACITY = 10;
    private boolean isMutable = true;

    AbstractProtobufList() {
    }

    @Override
    public boolean equals(Object o11) {
        if (o11 == this) {
            return true;
        }
        if (!(o11 instanceof List)) {
            return false;
        }
        if (!(o11 instanceof RandomAccess)) {
            return super.equals(o11);
        }
        List other = (List)o11;
        int size = this.size();
        if (size != other.size()) {
            return false;
        }
        for (int i11 = 0; i11 < size; ++i11) {
            if (this.get(i11).equals(other.get(i11))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int size = this.size();
        int hashCode = 1;
        for (int i11 = 0; i11 < size; ++i11) {
            hashCode = 31 * hashCode + this.get(i11).hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean add(E e11) {
        this.ensureIsMutable();
        return super.add(e11);
    }

    @Override
    public void add(int index, E element) {
        this.ensureIsMutable();
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c11) {
        this.ensureIsMutable();
        return super.addAll(c11);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c11) {
        this.ensureIsMutable();
        return super.addAll(index, c11);
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        super.clear();
    }

    @Override
    public boolean isModifiable() {
        return this.isMutable;
    }

    @Override
    public final void makeImmutable() {
        this.isMutable = false;
    }

    @Override
    public E remove(int index) {
        this.ensureIsMutable();
        return super.remove(index);
    }

    @Override
    public boolean remove(Object o11) {
        this.ensureIsMutable();
        int index = this.indexOf(o11);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c11) {
        this.ensureIsMutable();
        return super.removeAll(c11);
    }

    @Override
    public boolean retainAll(Collection<?> c11) {
        this.ensureIsMutable();
        return super.retainAll(c11);
    }

    @Override
    public E set(int index, E element) {
        this.ensureIsMutable();
        return super.set(index, element);
    }

    protected void ensureIsMutable() {
        if (!this.isMutable) {
            throw new UnsupportedOperationException();
        }
    }
}

