/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.arsc;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.arsc.FlagsOffset;
import java.util.logging.Logger;

public final class ARSCData {
    public static final Logger LOGGER = Logger.getLogger(ARSCData.class.getName());
    public final ResPackage[] mPackages;
    public final FlagsOffset[] mFlagsOffsets;

    public ARSCData(ResPackage[] resPackageArray, FlagsOffset[] flagsOffsetArray) {
        this.mPackages = resPackageArray;
        this.mFlagsOffsets = flagsOffsetArray;
    }

    public final ResPackage getOnePackage() {
        ResPackage[] resPackageArray = this.mPackages;
        if (this.mPackages.length != 0) {
            if (resPackageArray.length != 1) {
                int n = resPackageArray[0].mResSpecs.size();
                int n2 = 0;
                int n3 = 0;
                while (true) {
                    ResPackage[] resPackageArray2 = this.mPackages;
                    if (n3 >= this.mPackages.length) break;
                    if (resPackageArray2[n3].mResSpecs.size() >= n) {
                        n = this.mPackages[n3].mResSpecs.size();
                        n2 = n3;
                    }
                    ++n3;
                }
                LOGGER.info("Arsc file contains multiple packages. Using package " + this.mPackages[n2].mName + " as default.");
                return this.mPackages[n2];
            }
            return resPackageArray[0];
        }
        throw new AndrolibException("Arsc file contains zero packages");
    }
}

